/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnHandler {
    private static final String CLASS_NAME = TxnHandler.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private HiveConf conf = new HiveConf();
    private TxnStore txnHandler;

    public TestTxnHandler() throws Exception {
        TestTxnDbUtil.setConfValues((org.apache.hadoop.conf.Configuration)this.conf);
        TestTxnDbUtil.prepDb((org.apache.hadoop.conf.Configuration)this.conf);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = ctx.getConfiguration();
        conf.getLoggerConfig(CLASS_NAME).setLevel(Level.DEBUG);
        ctx.updateLoggers(conf);
        this.tearDown();
    }

    @Test
    public void testValidTxnsEmpty() throws Exception {
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)0L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertTrue((boolean)txnsInfo.getOpen_txns().isEmpty());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        junit.framework.Assert.assertEquals((long)0L, (long)txns.getTxn_high_water_mark());
        junit.framework.Assert.assertTrue((boolean)txns.getOpen_txns().isEmpty());
    }

    @Test
    public void testOpenTxn() throws Exception {
        long first = this.openTxn();
        junit.framework.Assert.assertEquals((long)1L, (long)first);
        long second = this.openTxn();
        junit.framework.Assert.assertEquals((long)2L, (long)second);
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        junit.framework.Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        junit.framework.Assert.assertEquals((long)2L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        junit.framework.Assert.assertEquals((String)"me", (String)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getUser());
        junit.framework.Assert.assertEquals((String)"localhost", (String)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getHostname());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        junit.framework.Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)2, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[3];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        for (int i = 1; i < saw.length; ++i) {
            junit.framework.Assert.assertTrue((boolean)saw[i]);
        }
    }

    @Test
    public void testAbortTxn() throws Exception {
        OpenTxnsResponse openedTxns = this.txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        List txnList = openedTxns.getTxn_ids();
        long first = (Long)txnList.get(0);
        junit.framework.Assert.assertEquals((long)1L, (long)first);
        long second = (Long)txnList.get(1);
        junit.framework.Assert.assertEquals((long)2L, (long)second);
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("p=1");
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest("default", "T");
        rqst.setTxnIds(Collections.singletonList(3L));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        long writeId = ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId();
        junit.framework.Assert.assertEquals((long)3L, (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        junit.framework.Assert.assertEquals((long)1L, (long)writeId);
        AddDynamicPartitions adp = new AddDynamicPartitions(3L, writeId, "default", "T", parts);
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)3L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)3, (int)txnsInfo.getOpen_txns().size());
        junit.framework.Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        junit.framework.Assert.assertEquals((long)2L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        junit.framework.Assert.assertEquals((long)3L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(2)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(2)).getState());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        junit.framework.Assert.assertEquals((long)3L, (long)txns.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)3, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[4];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        for (int i = 1; i < saw.length; ++i) {
            junit.framework.Assert.assertTrue((boolean)saw[i]);
        }
        this.txnHandler.commitTxn(new CommitTxnRequest(2L));
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        boolean gotException = false;
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(2L));
        }
        catch (NoSuchTxnException ex) {
            gotException = true;
            Assert.assertEquals((Object)("Transaction " + JavaUtils.txnIdToString((long)2L) + " is already committed."), (Object)ex.getMessage());
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        this.txnHandler.commitTxn(new CommitTxnRequest(3L));
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(3L));
        }
        catch (NoSuchTxnException ex) {
            gotException = true;
            Assert.assertEquals((Object)("Transaction " + JavaUtils.txnIdToString((long)3L) + " is already committed."), (Object)ex.getMessage());
        }
        Assert.assertTrue((boolean)gotException);
        this.txnHandler.setOpenTxnTimeOutMillis(1L);
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
        gotException = false;
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(2L));
        }
        catch (NoSuchTxnException ex) {
            gotException = true;
            Assert.assertEquals((Object)("No such transaction " + JavaUtils.txnIdToString((long)2L)), (Object)ex.getMessage());
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(4L));
        }
        catch (NoSuchTxnException ex) {
            gotException = true;
            Assert.assertEquals((Object)("No such transaction " + JavaUtils.txnIdToString((long)4L)), (Object)ex.getMessage());
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void testAbortTxns() throws Exception {
        this.createDatabaseForReplTests("default", MetaStoreUtils.getDefaultCatalog((org.apache.hadoop.conf.Configuration)this.conf));
        OpenTxnsResponse openedTxns = this.txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        List txnList = openedTxns.getTxn_ids();
        this.txnHandler.abortTxns(new AbortTxnsRequest(txnList));
        OpenTxnRequest replRqst = new OpenTxnRequest(2, "me", "localhost");
        replRqst.setReplPolicy("default.*");
        replRqst.setTxn_type(TxnType.REPL_CREATED);
        replRqst.setReplSrcTxnIds(Arrays.asList(1L, 2L));
        List targetTxns = this.txnHandler.openTxns(replRqst).getTxn_ids();
        junit.framework.Assert.assertTrue((boolean)this.targetTxnsPresentInReplTxnMap(1L, 2L, targetTxns));
        this.txnHandler.abortTxns(new AbortTxnsRequest(targetTxns));
        junit.framework.Assert.assertFalse((boolean)this.targetTxnsPresentInReplTxnMap(1L, 2L, targetTxns));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((int)5, (int)txnsInfo.getOpen_txns().size());
        txnsInfo.getOpen_txns().forEach(txn -> junit.framework.Assert.assertEquals((Object)TxnState.ABORTED, (Object)txn.getState()));
    }

    @Test
    public void testAbortInvalidTxn() throws Exception {
        boolean caught = false;
        try {
            this.txnHandler.abortTxn(new AbortTxnRequest(195L));
        }
        catch (NoSuchTxnException e) {
            caught = true;
        }
        junit.framework.Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testValidTxnsNoneOpen() throws Exception {
        this.txnHandler.openTxns(new OpenTxnRequest(2, "me", "localhost"));
        this.txnHandler.commitTxn(new CommitTxnRequest(1L));
        this.txnHandler.commitTxn(new CommitTxnRequest(2L));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)0, (int)txnsInfo.getOpen_txns().size());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        junit.framework.Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)0, (int)txns.getOpen_txns().size());
    }

    @Test
    public void testValidTxnsSomeOpen() throws Exception {
        this.txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        this.txnHandler.commitTxn(new CommitTxnRequest(2L));
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)3L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        junit.framework.Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        junit.framework.Assert.assertEquals((long)3L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        junit.framework.Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        junit.framework.Assert.assertEquals((long)3L, (long)txns.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)2, (int)txns.getOpen_txns().size());
        boolean[] saw = new boolean[4];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        junit.framework.Assert.assertTrue((boolean)saw[1]);
        junit.framework.Assert.assertFalse((boolean)saw[2]);
        junit.framework.Assert.assertTrue((boolean)saw[3]);
    }

    @Test
    public void testLockDifferentDBs() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "yourdb");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSameDB() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDbLocksTable() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        comp.setTablename("mytable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDbDoesNotLockTableInDifferentDB() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "yourdb");
        comp.setOperationType(DataOperationType.NO_TXN);
        comp.setTablename("mytable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentTables() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        comp.setTablename("mytable");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        comp.setTablename("yourtable");
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSameTable() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockTableLocksPartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentTableDoesntLockPartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockDifferentPartitions() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("yourpartition=yourvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSamePartition() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSRE() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockESRE() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockSWSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockSWSWSW() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testLockEWEWSR() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Ignore(value="now that every op has a txn ctx, we don't produce the error expected here....")
    @Test
    public void testWrongLockForOperation() throws Exception {
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        Exception expectedError = null;
        try {
            this.txnHandler.lock(req);
        }
        catch (Exception e) {
            expectedError = e;
        }
        Assert.assertTrue((expectedError != null && expectedError.getMessage().contains("Unexpected DataOperationType") ? 1 : 0) != 0);
    }

    @Test
    public void testLockEWEWEW() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockEESW() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testLockEESR() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.SELECT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
    }

    @Test
    public void testCheckLockAcquireAfterWaiting() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCL_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        long txnId = this.openTxn();
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        long lockid1 = res.getLockid();
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.INSERT);
        components.clear();
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(this.openTxn());
        res = this.txnHandler.lock(req);
        long lockid2 = res.getLockid();
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnId));
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid2));
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testCheckLockNoSuchLock() throws Exception {
        try {
            this.txnHandler.checkLock(new CheckLockRequest(23L));
            junit.framework.Assert.fail((String)"Allowed to check lock on non-existent lock");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckLockTxnAborted() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        try {
            this.txnHandler.checkLock(new CheckLockRequest(lockid));
            junit.framework.Assert.fail((String)"Allowed to check lock on aborted transaction.");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleLock() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(2);
        components.add(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("anotherpartition=anothervalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid));
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.unlock(new UnlockRequest(lockid));
        junit.framework.Assert.assertEquals((int)0, (int)this.txnHandler.getNumLocks());
    }

    @Test
    public void testMultipleLockWait() throws Exception {
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(2);
        components.add(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("anotherpartition=anothervalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long lockid1 = res.getLockid();
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        res = this.txnHandler.lock(req);
        long lockid2 = res.getLockid();
        junit.framework.Assert.assertTrue((res.getState() == LockState.WAITING ? 1 : 0) != 0);
        this.txnHandler.unlock(new UnlockRequest(lockid1));
        res = this.txnHandler.checkLock(new CheckLockRequest(lockid2));
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void testUnlockOnCommit() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        junit.framework.Assert.assertEquals((int)0, (int)this.txnHandler.getNumLocks());
    }

    @Test
    public void testUnlockOnAbort() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        junit.framework.Assert.assertEquals((int)0, (int)this.txnHandler.getNumLocks());
    }

    @Test
    public void testUnlockWithTxn() throws Exception {
        LOG.debug("Starting testUnlockWithTxn");
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long lockid = res.getLockid();
        try {
            this.txnHandler.unlock(new UnlockRequest(lockid));
            junit.framework.Assert.fail((String)"Allowed to unlock lock associated with transaction.");
        }
        catch (TxnOpenException txnOpenException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatTxnAborted() throws Exception {
        this.openTxn();
        this.txnHandler.abortTxn(new AbortTxnRequest(1L));
        HeartbeatRequest h = new HeartbeatRequest();
        h.setTxnid(1L);
        try {
            this.txnHandler.heartbeat(h);
            junit.framework.Assert.fail((String)"Told there was a txn, when it should have been aborted.");
        }
        catch (TxnAbortedException txnAbortedException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatNoTxn() throws Exception {
        HeartbeatRequest h = new HeartbeatRequest();
        h.setTxnid(939393L);
        try {
            this.txnHandler.heartbeat(h);
            junit.framework.Assert.fail((String)"Told there was a txn, when there wasn't.");
        }
        catch (NoSuchTxnException noSuchTxnException) {
            // empty catch block
        }
    }

    @Test
    public void testHeartbeatLock() throws Exception {
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 1L, TimeUnit.SECONDS);
        HeartbeatRequest h = new HeartbeatRequest();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        h.setLockid(res.getLockid());
        for (int i = 0; i < 30; ++i) {
            try {
                this.txnHandler.heartbeat(h);
                continue;
            }
            catch (NoSuchLockException e) {
                junit.framework.Assert.fail((String)"Told there was no lock, when the heartbeat should have kept it.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockTimeout() throws Exception {
        long timeout = this.txnHandler.setTimeout(1L);
        try {
            LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
            comp.setTablename("mytable");
            comp.setPartitionname("mypartition=myvalue");
            comp.setOperationType(DataOperationType.NO_TXN);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            LockResponse res = this.txnHandler.lock(req);
            junit.framework.Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
            Thread.sleep(1000L);
            this.txnHandler.performTimeOuts();
            this.txnHandler.checkLock(new CheckLockRequest(res.getLockid()));
            junit.framework.Assert.fail((String)"Told there was a lock, when it should have timed out.");
        }
        catch (NoSuchLockException noSuchLockException) {
        }
        finally {
            this.txnHandler.setTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverManyTimeouts() throws Exception {
        long timeout = this.txnHandler.setTimeout(1L);
        try {
            this.txnHandler.openTxns(new OpenTxnRequest(503, "me", "localhost"));
            Thread.sleep(1000L);
            this.txnHandler.performTimeOuts();
            GetOpenTxnsInfoResponse rsp = this.txnHandler.getOpenTxnsInfo();
            int numAborted = 0;
            for (TxnInfo txnInfo : rsp.getOpen_txns()) {
                junit.framework.Assert.assertEquals((Object)TxnState.ABORTED, (Object)txnInfo.getState());
                ++numAborted;
            }
            junit.framework.Assert.assertEquals((int)503, (int)numAborted);
        }
        finally {
            this.txnHandler.setTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplTimeouts() throws Exception {
        this.createDatabaseForReplTests("default", MetaStoreUtils.getDefaultCatalog((org.apache.hadoop.conf.Configuration)this.conf));
        long timeout = this.txnHandler.setTimeout(1L);
        try {
            OpenTxnRequest request = new OpenTxnRequest(3, "me", "localhost");
            OpenTxnsResponse response = this.txnHandler.openTxns(request);
            request.setReplPolicy("default.*");
            request.setReplSrcTxnIds(response.getTxn_ids());
            request.setTxn_type(TxnType.REPL_CREATED);
            OpenTxnsResponse responseRepl = this.txnHandler.openTxns(request);
            Thread.sleep(1000L);
            this.txnHandler.performTimeOuts();
            GetOpenTxnsInfoResponse rsp = this.txnHandler.getOpenTxnsInfo();
            int numAborted = 0;
            int numOpen = 0;
            for (TxnInfo txnInfo : rsp.getOpen_txns()) {
                if (TxnState.ABORTED == txnInfo.getState()) {
                    junit.framework.Assert.assertTrue((boolean)response.getTxn_ids().contains(txnInfo.getId()));
                    ++numAborted;
                }
                if (TxnState.OPEN != txnInfo.getState()) continue;
                junit.framework.Assert.assertTrue((boolean)responseRepl.getTxn_ids().contains(txnInfo.getId()));
                ++numOpen;
            }
            junit.framework.Assert.assertEquals((int)3, (int)numAborted);
            junit.framework.Assert.assertEquals((int)3, (int)numOpen);
        }
        finally {
            this.txnHandler.setTimeout(timeout);
        }
    }

    @Test
    public void testHeartbeatNoLock() throws Exception {
        HeartbeatRequest h = new HeartbeatRequest();
        h.setLockid(29389839L);
        try {
            this.txnHandler.heartbeat(h);
            junit.framework.Assert.fail((String)"Told there was a lock, when there wasn't.");
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @Test
    public void testCompactMajorWithPartition() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        junit.framework.Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        junit.framework.Assert.assertEquals((String)"foo", (String)c.getDbname());
        junit.framework.Assert.assertEquals((String)"bar", (String)c.getTablename());
        junit.framework.Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        junit.framework.Assert.assertEquals((Object)CompactionType.MAJOR, (Object)c.getType());
        junit.framework.Assert.assertEquals((String)"initiated", (String)c.getState());
        junit.framework.Assert.assertEquals((long)0L, (long)c.getStart());
    }

    @Test
    public void testCompactWhenAlreadyCompacting() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        CompactionResponse resp = this.txnHandler.compact(rqst);
        Assert.assertEquals((Object)resp, (Object)new CompactionResponse(1L, "initiated", true));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        junit.framework.Assert.assertEquals((int)1, (int)compacts.size());
        rqst.setType(CompactionType.MINOR);
        resp = this.txnHandler.compact(rqst);
        Assert.assertFalse((boolean)resp.isAccepted());
        Assert.assertEquals((Object)"refused", (Object)resp.getState());
        Assert.assertEquals((Object)"Compaction is already scheduled with state='initiated' and id=1", (Object)resp.getErrormessage());
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        junit.framework.Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        junit.framework.Assert.assertEquals((String)"foo", (String)c.getDbname());
        junit.framework.Assert.assertEquals((String)"bar", (String)c.getTablename());
        junit.framework.Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        junit.framework.Assert.assertEquals((Object)CompactionType.MAJOR, (Object)c.getType());
        junit.framework.Assert.assertEquals((String)"initiated", (String)c.getState());
        junit.framework.Assert.assertEquals((long)0L, (long)c.getStart());
    }

    @Test
    public void testCompactMinorNoPartition() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setRunas("fred");
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        junit.framework.Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        junit.framework.Assert.assertEquals((String)"foo", (String)c.getDbname());
        junit.framework.Assert.assertEquals((String)"bar", (String)c.getTablename());
        junit.framework.Assert.assertNull((Object)c.getPartitionname());
        junit.framework.Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        junit.framework.Assert.assertEquals((String)"initiated", (String)c.getState());
        junit.framework.Assert.assertEquals((long)0L, (long)c.getStart());
        junit.framework.Assert.assertEquals((String)"fred", (String)c.getRunAs());
    }

    @Test
    public void showLocks() throws Exception {
        long begining = System.currentTimeMillis();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setOperationType(DataOperationType.NO_TXN);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        long txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.SELECT);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        components = new ArrayList(1);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.PARTITION, "yourdb");
        comp.setTablename("yourtable");
        comp.setPartitionname("yourpartition=yourvalue");
        comp.setOperationType(DataOperationType.INSERT);
        components.add(comp);
        req = new LockRequest(components, "you", "remotehost");
        res = this.txnHandler.lock(req);
        ShowLocksResponse rsp = this.txnHandler.showLocks(new ShowLocksRequest());
        List locks = rsp.getLocks();
        junit.framework.Assert.assertEquals((int)3, (int)locks.size());
        boolean[] saw = new boolean[locks.size()];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (ShowLocksResponseElement lock : locks) {
            if (lock.getLockid() == 1L) {
                junit.framework.Assert.assertEquals((long)0L, (long)lock.getTxnid());
                junit.framework.Assert.assertEquals((String)"mydb", (String)lock.getDbname());
                junit.framework.Assert.assertNull((Object)lock.getTablename());
                junit.framework.Assert.assertNull((Object)lock.getPartname());
                junit.framework.Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
                junit.framework.Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)lock.getType());
                junit.framework.Assert.assertTrue((String)lock.toString(), (0L != lock.getLastheartbeat() ? 1 : 0) != 0);
                junit.framework.Assert.assertTrue((String)("Expected acquired at " + lock.getAcquiredat() + " to be between " + begining + " and " + System.currentTimeMillis()), (begining <= lock.getAcquiredat() && System.currentTimeMillis() >= lock.getAcquiredat() ? 1 : 0) != 0);
                junit.framework.Assert.assertEquals((String)"me", (String)lock.getUser());
                junit.framework.Assert.assertEquals((String)"localhost", (String)lock.getHostname());
                saw[0] = true;
                continue;
            }
            if (lock.getLockid() == 2L) {
                junit.framework.Assert.assertEquals((long)1L, (long)lock.getTxnid());
                junit.framework.Assert.assertEquals((String)"mydb", (String)lock.getDbname());
                junit.framework.Assert.assertEquals((String)"mytable", (String)lock.getTablename());
                junit.framework.Assert.assertNull((Object)lock.getPartname());
                junit.framework.Assert.assertEquals((Object)LockState.WAITING, (Object)lock.getState());
                junit.framework.Assert.assertEquals((Object)LockType.SHARED_READ, (Object)lock.getType());
                junit.framework.Assert.assertTrue((String)lock.toString(), (0L == lock.getLastheartbeat() && lock.getTxnid() != 0L ? 1 : 0) != 0);
                junit.framework.Assert.assertEquals((long)0L, (long)lock.getAcquiredat());
                junit.framework.Assert.assertEquals((String)"me", (String)lock.getUser());
                junit.framework.Assert.assertEquals((String)"localhost", (String)lock.getHostname());
                saw[1] = true;
                continue;
            }
            if (lock.getLockid() == 3L) {
                junit.framework.Assert.assertEquals((long)0L, (long)lock.getTxnid());
                junit.framework.Assert.assertEquals((String)"yourdb", (String)lock.getDbname());
                junit.framework.Assert.assertEquals((String)"yourtable", (String)lock.getTablename());
                junit.framework.Assert.assertEquals((String)"yourpartition=yourvalue", (String)lock.getPartname());
                junit.framework.Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
                junit.framework.Assert.assertEquals((Object)LockType.SHARED_READ, (Object)lock.getType());
                junit.framework.Assert.assertTrue((String)lock.toString(), (begining <= lock.getLastheartbeat() && System.currentTimeMillis() >= lock.getLastheartbeat() ? 1 : 0) != 0);
                junit.framework.Assert.assertTrue((begining <= lock.getAcquiredat() && System.currentTimeMillis() >= lock.getAcquiredat() ? 1 : 0) != 0);
                junit.framework.Assert.assertEquals((String)"you", (String)lock.getUser());
                junit.framework.Assert.assertEquals((String)"remotehost", (String)lock.getHostname());
                saw[2] = true;
                continue;
            }
            junit.framework.Assert.fail((String)"Unknown lock id");
        }
        for (int i = 0; i < saw.length; ++i) {
            junit.framework.Assert.assertTrue((String)("Didn't see lock id " + i), (boolean)saw[i]);
        }
    }

    @Ignore(value="multiple threads wedge Derby")
    @Test
    public void testMutexAPI() throws Exception {
        final TxnStore.MutexAPI api = this.txnHandler.getMutexAPI();
        final AtomicInteger stepTracker = new AtomicInteger(0);
        Thread t1 = new Thread("MutexTest1"){

            @Override
            public void run() {
                try {
                    stepTracker.incrementAndGet();
                    TxnStore.MutexAPI.LockHandle handle = api.acquireLock(TxnStore.MUTEX_KEY.HouseKeeper.name());
                    Thread.sleep(4000L);
                    Assert.assertEquals((String)"Thread2 should have started by now but not done work", (long)2L, (long)stepTracker.get());
                    stepTracker.incrementAndGet();
                    handle.releaseLocks();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        };
        t1.setDaemon(true);
        ErrorHandle ueh1 = new ErrorHandle();
        t1.setUncaughtExceptionHandler(ueh1);
        Thread t2 = new Thread("MutexTest2"){

            @Override
            public void run() {
                try {
                    stepTracker.incrementAndGet();
                    TxnStore.MutexAPI.LockHandle handle = api.acquireLock(TxnStore.MUTEX_KEY.HouseKeeper.name());
                    stepTracker.incrementAndGet();
                    Assert.assertEquals((long)4L, (long)stepTracker.get());
                    handle.releaseLocks();
                    stepTracker.incrementAndGet();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        };
        t2.setDaemon(true);
        ErrorHandle ueh2 = new ErrorHandle();
        t2.setUncaughtExceptionHandler(ueh2);
        t1.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOG.info("Sleep was interrupted");
        }
        t2.start();
        t1.join(6000L);
        t2.join(6000L);
        if (ueh1.error != null) {
            Assert.assertTrue((String)("Unexpected error from t1: " + StringUtils.stringifyException((Throwable)ueh1.error)), (boolean)false);
        }
        if (ueh2.error != null) {
            Assert.assertTrue((String)("Unexpected error from t2: " + StringUtils.stringifyException((Throwable)ueh2.error)), (boolean)false);
        }
        Assert.assertEquals((String)"5 means both threads have completed", (long)5L, (long)stepTracker.get());
    }

    private List<Long> replOpenTxnForTest(long startId, int numTxn, String replPolicy) throws Exception {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_TXN_MAX_OPEN_BATCH, numTxn);
        long lastId = startId + (long)numTxn - 1L;
        OpenTxnRequest rqst = new OpenTxnRequest(numTxn, "me", "localhost");
        rqst.setReplPolicy(replPolicy);
        rqst.setReplSrcTxnIds(LongStream.rangeClosed(startId, lastId).boxed().collect(Collectors.toList()));
        rqst.setTxn_type(TxnType.REPL_CREATED);
        OpenTxnsResponse openedTxns = this.txnHandler.openTxns(rqst);
        List txnList = openedTxns.getTxn_ids();
        junit.framework.Assert.assertEquals((int)txnList.size(), (int)numTxn);
        int numTxnPresentNow = TestTxnDbUtil.countQueryAgent((org.apache.hadoop.conf.Configuration)this.conf, (String)("SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_ID\" >= " + txnList.get(0) + " and \"TXN_ID\" <= " + txnList.get(numTxn - 1)));
        junit.framework.Assert.assertEquals((int)numTxn, (int)numTxnPresentNow);
        this.checkReplTxnForTest(startId, lastId, replPolicy, txnList);
        return txnList;
    }

    private void replAbortTxnForTest(List<Long> txnList, String replPolicy) throws Exception {
        for (Long txnId : txnList) {
            AbortTxnRequest rqst = new AbortTxnRequest(txnId.longValue());
            rqst.setReplPolicy(replPolicy);
            rqst.setTxn_type(TxnType.REPL_CREATED);
            this.txnHandler.abortTxn(rqst);
        }
        this.checkReplTxnForTest(txnList.get(0), txnList.get(txnList.size() - 1), replPolicy, new ArrayList<Long>());
    }

    private void checkReplTxnForTest(Long startTxnId, Long endTxnId, String replPolicy, List<Long> targetTxnId) throws Exception {
        String[] output = TestTxnDbUtil.queryToString((org.apache.hadoop.conf.Configuration)this.conf, (String)("SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE  \"RTM_SRC_TXN_ID\" >=  " + startTxnId + "AND \"RTM_SRC_TXN_ID\" <=  " + endTxnId + " AND \"RTM_REPL_POLICY\" = '" + replPolicy + "'")).split("\n");
        junit.framework.Assert.assertEquals((int)(output.length - 1), (int)targetTxnId.size());
        for (int idx = 1; idx < output.length; ++idx) {
            long txnId = Long.parseLong(output[idx].trim());
            junit.framework.Assert.assertEquals((long)txnId, (long)targetTxnId.get(idx - 1));
        }
    }

    private boolean targetTxnsPresentInReplTxnMap(Long startTxnId, Long endTxnId, List<Long> targetTxnId) throws Exception {
        String[] output = TestTxnDbUtil.queryToString((org.apache.hadoop.conf.Configuration)this.conf, (String)("SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE  \"RTM_SRC_TXN_ID\" >=  " + startTxnId + "AND \"RTM_SRC_TXN_ID\" <=  " + endTxnId)).split("\n");
        ArrayList<Long> replayedTxns = new ArrayList<Long>();
        for (int idx = 1; idx < output.length; ++idx) {
            replayedTxns.add(Long.parseLong(output[idx].trim()));
        }
        return replayedTxns.equals(targetTxnId);
    }

    private void createDatabaseForReplTests(String dbName, String catalog) throws Exception {
        String query = "select \"DB_ID\" from \"DBS\" where \"NAME\" = '" + dbName + "' and \"CTLG_NAME\" = '" + catalog + "'";
        String[] output = TestTxnDbUtil.queryToString((org.apache.hadoop.conf.Configuration)this.conf, (String)query).split("\n");
        if (output.length == 1) {
            query = "INSERT INTO \"DBS\"(\"DB_ID\", \"NAME\", \"CTLG_NAME\", \"DB_LOCATION_URI\")  VALUES (1, '" + dbName + "','" + catalog + "','dummy')";
            TestTxnDbUtil.executeUpdate((org.apache.hadoop.conf.Configuration)this.conf, (String)query);
        }
    }

    @Test
    public void testReplOpenTxn() throws Exception {
        this.createDatabaseForReplTests("default", MetaStoreUtils.getDefaultCatalog((org.apache.hadoop.conf.Configuration)this.conf));
        int numTxn = 50000;
        String[] output = TestTxnDbUtil.queryToString((org.apache.hadoop.conf.Configuration)this.conf, (String)"SELECT MAX(\"TXN_ID\") + 1 FROM \"TXNS\"").split("\n");
        long startTxnId = Long.parseLong(output[1].trim());
        this.txnHandler.setOpenTxnTimeOutMillis(50000L);
        List<Long> txnList = this.replOpenTxnForTest(startTxnId, numTxn, "default.*");
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
        assert (txnList.size() == numTxn);
        this.txnHandler.abortTxns(new AbortTxnsRequest(txnList));
    }

    @Test
    public void testReplAllocWriteId() throws Exception {
        int idx;
        int numTxn = 2;
        String[] output = TestTxnDbUtil.queryToString((org.apache.hadoop.conf.Configuration)this.conf, (String)"SELECT MAX(\"TXN_ID\") + 1 FROM \"TXNS\"").split("\n");
        long startTxnId = Long.parseLong(output[1].trim());
        List<Long> srcTxnIdList = LongStream.rangeClosed(startTxnId, (long)numTxn + startTxnId - 1L).boxed().collect(Collectors.toList());
        List<Long> targetTxnList = this.replOpenTxnForTest(startTxnId, numTxn, "destdb.*");
        assert (targetTxnList.size() == numTxn);
        ArrayList<TxnToWriteId> srcTxnToWriteId = new ArrayList<TxnToWriteId>();
        for (int idx2 = 0; idx2 < numTxn; ++idx2) {
            srcTxnToWriteId.add(new TxnToWriteId(startTxnId + (long)idx2, (long)(idx2 + 1)));
        }
        AllocateTableWriteIdsRequest allocMsg = new AllocateTableWriteIdsRequest("destdb", "tbl1");
        allocMsg.setReplPolicy("destdb.*");
        allocMsg.setSrcTxnToWriteIdList(srcTxnToWriteId);
        List targetTxnToWriteId = this.txnHandler.allocateTableWriteIds(allocMsg).getTxnToWriteIds();
        for (idx = 0; idx < targetTxnList.size(); ++idx) {
            junit.framework.Assert.assertEquals((long)((TxnToWriteId)targetTxnToWriteId.get(idx)).getWriteId(), (long)((TxnToWriteId)srcTxnToWriteId.get(idx)).getWriteId());
            junit.framework.Assert.assertEquals((Object)((TxnToWriteId)targetTxnToWriteId.get(idx)).getTxnId(), (Object)targetTxnList.get(idx));
        }
        targetTxnToWriteId = this.txnHandler.allocateTableWriteIds(allocMsg).getTxnToWriteIds();
        for (idx = 0; idx < targetTxnList.size(); ++idx) {
            junit.framework.Assert.assertEquals((long)((TxnToWriteId)targetTxnToWriteId.get(idx)).getWriteId(), (long)((TxnToWriteId)srcTxnToWriteId.get(idx)).getWriteId());
            junit.framework.Assert.assertEquals((Object)((TxnToWriteId)targetTxnToWriteId.get(idx)).getTxnId(), (Object)targetTxnList.get(idx));
        }
        boolean failed = false;
        srcTxnToWriteId = new ArrayList();
        srcTxnToWriteId.add(new TxnToWriteId(startTxnId, (long)(2 * numTxn + 1)));
        allocMsg = new AllocateTableWriteIdsRequest("destdb", "tbl2");
        allocMsg.setReplPolicy("destdb.*");
        allocMsg.setSrcTxnToWriteIdList(srcTxnToWriteId);
        try {
            this.txnHandler.allocateTableWriteIds(allocMsg).getTxnToWriteIds();
        }
        catch (IllegalStateException e) {
            failed = true;
        }
        junit.framework.Assert.assertFalse((boolean)failed);
        this.replAbortTxnForTest(srcTxnIdList, "destdb.*");
        failed = false;
        try {
            this.txnHandler.allocateTableWriteIds(allocMsg).getTxnToWriteIds();
        }
        catch (RuntimeException e) {
            failed = true;
        }
        junit.framework.Assert.assertFalse((boolean)failed);
    }

    @Test
    public void allocateNextWriteIdRetriesAfterDetectingConflictingConcurrentInsert() throws Exception {
        String dbName = "abc";
        String tableName = "def";
        int numTxns = 2;
        int iterations = 20;
        long originalLimit = MetastoreConf.getLongVar((org.apache.hadoop.conf.Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
        MetastoreConf.setLongVar((org.apache.hadoop.conf.Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS, (long)(iterations + 1));
        TxnStore txnHandler = TxnUtils.getTxnStore((org.apache.hadoop.conf.Configuration)this.conf);
        try (Connection dbConn = TestTxnDbUtil.getConnection((org.apache.hadoop.conf.Configuration)this.conf);
             Statement stmt = dbConn.createStatement();){
            for (int i = 0; i < iterations; ++i) {
                stmt.executeUpdate("TRUNCATE TABLE \"NEXT_WRITE_ID\"");
                stmt.executeUpdate("TRUNCATE TABLE \"TXN_TO_WRITE_ID\"");
                dbConn.commit();
                OpenTxnsResponse resp = txnHandler.openTxns(new OpenTxnRequest(numTxns, "me", "localhost"));
                AllocateTableWriteIdsRequest request = new AllocateTableWriteIdsRequest(dbName, tableName);
                resp.getTxn_ids().forEach(arg_0 -> ((AllocateTableWriteIdsRequest)request).addToTxnIds(arg_0));
                CompletableFuture<AllocateTableWriteIdsResponse> future1 = CompletableFuture.supplyAsync(() -> {
                    try {
                        return txnHandler.allocateTableWriteIds(request);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(10L);
                        stmt.executeUpdate(String.format("INSERT INTO \"NEXT_WRITE_ID\" VALUES ('%s', '%s', 1)", dbName, tableName));
                        dbConn.commit();
                    }
                    catch (Exception e) {
                        LOG.warn("Inserting next_write_id directly into DB failed: " + e.getMessage());
                    }
                });
                CompletableFuture.allOf(future1, future2).join();
                AllocateTableWriteIdsResponse result = future1.get();
                junit.framework.Assert.assertEquals((int)2, (int)result.getTxnToWriteIds().size());
                junit.framework.Assert.assertEquals((long)(i * numTxns + 1), (long)((TxnToWriteId)result.getTxnToWriteIds().get(0)).getTxnId());
                junit.framework.Assert.assertEquals((long)1L, (long)((TxnToWriteId)result.getTxnToWriteIds().get(0)).getWriteId());
                junit.framework.Assert.assertEquals((long)(i * numTxns + 2), (long)((TxnToWriteId)result.getTxnToWriteIds().get(1)).getTxnId());
                junit.framework.Assert.assertEquals((long)2L, (long)((TxnToWriteId)result.getTxnToWriteIds().get(1)).getWriteId());
            }
            MetastoreConf.setLongVar((org.apache.hadoop.conf.Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS, (long)originalLimit);
        }
    }

    @Test
    public void testGetMaterializationInvalidationInfo() throws MetaException {
        this.testGetMaterializationInvalidationInfo(new ValidReadTxnList(new long[]{6L, 11L}, new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[]{2L}, new BitSet(), 1L));
    }

    @Test
    public void testGetMaterializationInvalidationInfoWhenTableHasNoException() throws MetaException {
        this.testGetMaterializationInvalidationInfo(new ValidReadTxnList(new long[]{6L, 11L}, new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[0], new BitSet(), 1L));
    }

    @Test
    public void testGetMaterializationInvalidationInfoWhenCurrentTxnListHasNoException() throws MetaException {
        this.testGetMaterializationInvalidationInfo(new ValidReadTxnList(new long[0], new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[]{2L}, new BitSet(), 1L));
    }

    private void testGetMaterializationInvalidationInfo(ValidReadTxnList currentValidTxnList, ValidReaderWriteIdList ... tableWriteIdList) throws MetaException {
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(Long.valueOf(5L));
        for (ValidReaderWriteIdList tableWriteId : tableWriteIdList) {
            validTxnWriteIdList.addTableValidWriteIdList((ValidWriteIdList)tableWriteId);
        }
        Table table = new Table();
        table.setDbName("default");
        table.setTableName("t1");
        HashMap<String, String> tableParameters = new HashMap<String, String>(){
            {
                this.put("transactional", "true");
                this.put("transactional_properties", "insert_only");
            }
        };
        table.setParameters((Map)tableParameters);
        SourceTable sourceTable = new SourceTable();
        sourceTable.setTable(table);
        CreationMetadata creationMetadata = new CreationMetadata();
        creationMetadata.setDbName("default");
        creationMetadata.setTblName("mat1");
        creationMetadata.setTablesUsed((Set)new HashSet<String>(){
            {
                this.add("default.t1");
            }
        });
        creationMetadata.setValidTxnList(validTxnWriteIdList.toString());
        Materialization materialization = this.txnHandler.getMaterializationInvalidationInfo(creationMetadata, currentValidTxnList.toString());
        junit.framework.Assert.assertFalse((boolean)materialization.isSourceTablesUpdateDeleteModified());
    }

    @Test
    public void testGetMaterializationInvalidationInfoWithValidReaderWriteIdList() throws MetaException {
        this.testGetMaterializationInvalidationInfoWithValidReaderWriteIdList(new ValidReadTxnList(new long[]{6L, 11L}, new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[]{2L}, new BitSet(), 1L));
    }

    @Test
    public void testGetMaterializationInvalidationInfoWithValidReaderWriteIdListWhenTableHasNoException() throws MetaException {
        this.testGetMaterializationInvalidationInfoWithValidReaderWriteIdList(new ValidReadTxnList(new long[]{6L, 11L}, new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[0], new BitSet(), 1L));
    }

    @Test
    public void testGetMaterializationInvalidationInfoWithValidReaderWriteIdListWhenCurrentTxnListHasNoException() throws MetaException {
        this.testGetMaterializationInvalidationInfoWithValidReaderWriteIdList(new ValidReadTxnList(new long[0], new BitSet(), 10L, 12L), new ValidReaderWriteIdList(TableName.getDbTable((String)"default", (String)"t1"), new long[]{2L}, new BitSet(), 1L));
    }

    @Test
    public void testHeartbeatLockMaterializationRebuild() throws MetaException {
        this.txnHandler.lockMaterializationRebuild("default", "table1", 1L);
        boolean result = this.txnHandler.heartbeatLockMaterializationRebuild("default", "table1", 1L);
        junit.framework.Assert.assertTrue((boolean)result);
    }

    private void testGetMaterializationInvalidationInfoWithValidReaderWriteIdList(ValidReadTxnList currentValidTxnList, ValidReaderWriteIdList ... tableWriteIdList) throws MetaException {
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(Long.valueOf(5L));
        for (ValidReaderWriteIdList tableWriteId : tableWriteIdList) {
            validTxnWriteIdList.addTableValidWriteIdList((ValidWriteIdList)tableWriteId);
        }
        CreationMetadata creationMetadata = new CreationMetadata();
        creationMetadata.setDbName("default");
        creationMetadata.setTblName("mat1");
        creationMetadata.setTablesUsed((Set)new HashSet<String>(){
            {
                this.add("default.t1");
            }
        });
        creationMetadata.setValidTxnList(validTxnWriteIdList.toString());
        Materialization materialization = this.txnHandler.getMaterializationInvalidationInfo(creationMetadata, currentValidTxnList.toString());
        junit.framework.Assert.assertFalse((boolean)materialization.isSourceTablesUpdateDeleteModified());
    }

    private void updateTxns(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = \"TXN_LAST_HEARTBEAT\" + 1");
    }

    private void updateLocks(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("UPDATE \"HIVE_LOCKS\" SET \"HL_LAST_HEARTBEAT\" = \"HL_LAST_HEARTBEAT\" + 1");
    }

    @Before
    public void setUp() throws Exception {
        this.txnHandler = TxnUtils.getTxnStore((org.apache.hadoop.conf.Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((org.apache.hadoop.conf.Configuration)this.conf);
    }

    private long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }

    private static final class ErrorHandle
    implements Thread.UncaughtExceptionHandler {
        Throwable error = null;

        private ErrorHandle() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("Uncaught exception from " + t.getName() + ": " + e.getMessage());
            this.error = e;
        }
    }
}

