/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHeartbeatTxnRangeFunction {
    private static final HiveConf conf = new HiveConf();
    private static TxnStore txnHandler;

    @BeforeClass
    public static void setUp() throws Exception {
        TestTxnDbUtil.setConfValues((Configuration)conf);
        TestTxnDbUtil.prepDb((Configuration)conf);
        txnHandler = TxnUtils.getTxnStore((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((Configuration)conf);
    }

    @Test
    public void testHeartbeatTxnRangeFunction_NoSuchTxn() throws MetaException {
        HeartbeatTxnRangeRequest request = new HeartbeatTxnRangeRequest(1L, 1L);
        HeartbeatTxnRangeResponse response = txnHandler.heartbeatTxnRange(request);
        Assert.assertEquals((long)1L, (long)response.getNosuchSize());
    }

    @Test
    public void testHeartbeatTxnRangeFunction_AbortedTxn() throws MetaException, TxnAbortedException, NoSuchTxnException {
        this.openTxn();
        this.openTxn();
        long txnId = this.openTxn();
        txnHandler.abortTxn(new AbortTxnRequest(txnId));
        HeartbeatTxnRangeRequest request = new HeartbeatTxnRangeRequest(1L, txnId);
        HeartbeatTxnRangeResponse response = txnHandler.heartbeatTxnRange(request);
        Assert.assertEquals((long)1L, (long)response.getAbortedSize());
        Long txn = (Long)response.getAbortedIterator().next();
        Assert.assertEquals((long)3L, (long)txn);
        Assert.assertEquals((long)0L, (long)response.getNosuch().size());
    }

    @Test
    public void testHeartbeatTxnRangeFunction_Success() throws Exception {
        this.openTxn();
        this.openTxn();
        long txnId = this.openTxn();
        String firstHeartbeat = TestTxnDbUtil.queryToString((Configuration)conf, (String)("select \"TXN_LAST_HEARTBEAT\" from \"TXNS\" where \"TXN_ID\" = " + txnId), (boolean)false);
        HeartbeatTxnRangeRequest request = new HeartbeatTxnRangeRequest(1L, txnId);
        HeartbeatTxnRangeResponse response = txnHandler.heartbeatTxnRange(request);
        String updatedHeartbeat = TestTxnDbUtil.queryToString((Configuration)conf, (String)("select \"TXN_LAST_HEARTBEAT\" from \"TXNS\" where \"TXN_ID\" = " + txnId), (boolean)false);
        Assert.assertEquals((long)0L, (long)response.getAbortedSize());
        Assert.assertEquals((long)0L, (long)response.getNosuchSize());
        Assert.assertNotNull((Object)firstHeartbeat);
        Assert.assertNotNull((Object)updatedHeartbeat);
        Assert.assertNotEquals((Object)firstHeartbeat, (Object)updatedHeartbeat);
    }

    @Test
    public void testHeartbeatTxnRangeOneCommitted_Mixed() throws Exception {
        this.openTxn();
        txnHandler.commitTxn(new CommitTxnRequest(1L));
        this.openTxn();
        long txnId = this.openTxn();
        HeartbeatTxnRangeResponse rsp = txnHandler.heartbeatTxnRange(new HeartbeatTxnRangeRequest(1L, txnId));
        Assert.assertEquals((long)1L, (long)rsp.getNosuchSize());
        long noSuchTxnId = (Long)rsp.getNosuchIterator().next();
        Assert.assertEquals((long)1L, (long)noSuchTxnId);
        Assert.assertEquals((long)0L, (long)rsp.getAbortedSize());
    }

    private long openTxn() throws MetaException {
        List txns = txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }
}

