/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hive.common.util.HiveVersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompactionTxnHandler {
    public static final String WORKER_VERSION = HiveVersionInfo.getShortVersion();
    private HiveConf conf = new HiveConf();
    private TxnStore txnHandler;

    public TestCompactionTxnHandler() throws Exception {
        TestTxnDbUtil.setConfValues((Configuration)this.conf);
        TestTxnDbUtil.prepDb((Configuration)this.conf);
        this.conf.setIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_QUERY_LENGTH, 1);
        this.conf.setIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE, 10);
        this.tearDown();
    }

    @Test
    public void testFindNextToCompact() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        long now = System.currentTimeMillis();
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"foo", (Object)ci.dbname);
        Assert.assertEquals((Object)"bar", (Object)ci.tableName);
        Assert.assertEquals((Object)"ds=today", (Object)ci.partName);
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        Assert.assertNull((Object)ci.runAs);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        ci.runAs = "bob";
        this.txnHandler.updateCompactorState(ci, this.openTxn());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((Object)"foo", (Object)c.getDbname());
        Assert.assertEquals((Object)"bar", (Object)c.getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((Object)"working", (Object)c.getState());
        Assert.assertTrue((c.getStart() - 5000L < now && c.getStart() + 5000L > now ? 1 : 0) != 0);
        Assert.assertEquals((Object)"fred", (Object)c.getWorkerid());
        Assert.assertEquals((Object)"bob", (Object)c.getRunAs());
    }

    @Test
    public void testFindNextToCompact2() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=yesterday");
        this.txnHandler.compact(rqst);
        long now = System.currentTimeMillis();
        boolean expectToday = false;
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"foo", (Object)ci.dbname);
        Assert.assertEquals((Object)"bar", (Object)ci.tableName);
        if ("ds=today".equals(ci.partName)) {
            expectToday = false;
        } else if ("ds=yesterday".equals(ci.partName)) {
            expectToday = true;
        } else {
            Assert.fail((String)("partition name should have been today or yesterday but was " + ci.partName));
        }
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)"foo", (Object)ci.dbname);
        Assert.assertEquals((Object)"bar", (Object)ci.tableName);
        if (expectToday) {
            Assert.assertEquals((Object)"ds=today", (Object)ci.partName);
        } else {
            Assert.assertEquals((Object)"ds=yesterday", (Object)ci.partName);
        }
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        for (ShowCompactResponseElement e : compacts) {
            Assert.assertEquals((Object)"working", (Object)e.getState());
            Assert.assertTrue((e.getStart() - 5000L < now && e.getStart() + 5000L > now ? 1 : 0) != 0);
            Assert.assertEquals((Object)"fred", (Object)e.getWorkerid());
        }
    }

    @Test
    public void testFindNextToCompactNothingToCompact() throws Exception {
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
    }

    @Test
    public void testMarkCompacted() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((Object)"foo", (Object)c.getDbname());
        Assert.assertEquals((Object)"bar", (Object)c.getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((Object)"ready for cleaning", (Object)c.getState());
        Assert.assertNull((Object)c.getWorkerid());
    }

    @Test
    public void testFindNextToClean() throws Exception {
        long txnid;
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.highestWriteId = 41L;
        ci.txnId = txnid = this.openTxn();
        this.txnHandler.updateCompactorState(ci, txnid);
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((long)1L, (long)toClean.size());
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((Object)"foo", (Object)c.getDbname());
        Assert.assertEquals((Object)"bar", (Object)c.getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((Object)"ready for cleaning", (Object)c.getState());
        Assert.assertNull((Object)c.getWorkerid());
    }

    @Test
    public void testMarkCleaned() throws Exception {
        long txnid;
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.highestWriteId = 41L;
        ci.txnId = txnid = this.openTxn();
        this.txnHandler.updateCompactorState(ci, txnid);
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((long)1L, (long)toClean.size());
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        this.txnHandler.markCleaned(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
    }

    @Test
    public void testShowCompactions() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        showCompactResponse.getCompacts().forEach(e -> {
            Assert.assertEquals((Object)"foo", (Object)e.getDbname());
            Assert.assertEquals((Object)"bar", (Object)e.getTablename());
            Assert.assertEquals((Object)"ds=today", (Object)e.getPartitionname());
            Assert.assertEquals((Object)"initiated", (Object)e.getState());
            Assert.assertEquals((Object)CompactionType.MINOR, (Object)e.getType());
            Assert.assertEquals((long)1L, (long)e.getId());
        });
    }

    @Test
    public void testGetLatestCommittedCompaction() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String errorMessage = "Dummy error";
        this.addSucceededCompaction("foo", "bar", null, CompactionType.MINOR);
        this.addFailedCompaction("foo", "bar", CompactionType.MINOR, null, "Dummy error");
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        rqst.setDbname("foo");
        rqst.setTablename("bar");
        GetLatestCommittedCompactionInfoResponse response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single compaction record", (long)1L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the first succeeded compaction record", (long)1L, (long)lci.getId());
        Assert.assertNull((String)"Expecting null partitionname for a non-partitioned table", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
        rqst.setPartitionnames(new ArrayList());
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single compaction record", (long)1L, (long)response.getCompactionsSize());
        lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the first succeeded compaction record", (long)1L, (long)lci.getId());
        Assert.assertEquals((Object)"foo", (Object)lci.getDbname());
        Assert.assertEquals((Object)"bar", (Object)lci.getTablename());
        Assert.assertNull((String)"Expecting null partitionname for a non-partitioned table", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
    }

    @Test
    public void testGetLatestCommittedCompactionPartition() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        String errorMessage = "Dummy error";
        this.addSucceededCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        this.addFailedCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        rqst.setDbname("foo");
        rqst.setTablename("bar");
        rqst.addToPartitionnames("ds=today");
        GetLatestCommittedCompactionInfoResponse response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single compaction record", (long)1L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the first succeeded compaction record", (long)1L, (long)lci.getId());
        Assert.assertEquals((Object)"ds=today", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
        String anotherPartitionName = "ds=yesterday";
        this.addWaitingForCleaningCompaction("foo", "bar", CompactionType.MINOR, "ds=yesterday", "Dummy error");
        rqst.addToPartitionnames("ds=yesterday");
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single compaction record for each partition", (long)2L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci1 = response.getCompactions().stream().filter(c -> c.getPartitionname().equals("ds=today")).findFirst().get();
        Assert.assertEquals((long)1L, (long)lci1.getId());
        CompactionInfoStruct lci2 = response.getCompactions().stream().filter(c -> c.getPartitionname().equals("ds=yesterday")).findFirst().get();
        Assert.assertEquals((long)3L, (long)lci2.getId());
        rqst.unsetPartitionnames();
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single compaction record for each partition", (long)2L, (long)response.getCompactionsSize());
        lci1 = response.getCompactions().stream().filter(c -> c.getPartitionname().equals("ds=today")).findFirst().get();
        Assert.assertEquals((long)1L, (long)lci1.getId());
        lci2 = response.getCompactions().stream().filter(c -> c.getPartitionname().equals("ds=yesterday")).findFirst().get();
        Assert.assertEquals((long)3L, (long)lci2.getId());
    }

    @Test
    public void testGetLatestSucceededCompaction() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        String errorMessage = "Dummy error";
        this.addSucceededCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        this.addSucceededCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        rqst.setDbname("foo");
        rqst.setTablename("bar");
        rqst.addToPartitionnames("ds=today");
        this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        GetLatestCommittedCompactionInfoResponse response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single record", (long)1L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the second succeeded compaction record", (long)2L, (long)lci.getId());
        Assert.assertEquals((Object)"ds=today", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
        this.addWaitingForCleaningCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single record", (long)1L, (long)response.getCompactionsSize());
        lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the last compaction record waiting for cleaning", (long)3L, (long)lci.getId());
        Assert.assertEquals((Object)"ds=today", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
    }

    @Test
    public void testGetLatestCompactionWithIdFilter() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        this.addSucceededCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        this.addSucceededCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        rqst.setDbname("foo");
        rqst.setTablename("bar");
        rqst.addToPartitionnames("ds=today");
        GetLatestCommittedCompactionInfoResponse response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single record", (long)1L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the second succeeded compaction record", (long)2L, (long)lci.getId());
        Assert.assertEquals((Object)"ds=today", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
        rqst.setLastCompactionId(1L);
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting a single record", (long)1L, (long)response.getCompactionsSize());
        lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((String)"Expecting the second succeeded compaction record", (long)2L, (long)lci.getId());
        Assert.assertEquals((Object)"ds=today", (Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
        rqst.setLastCompactionId(2L);
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((String)"Expecting no record", (long)0L, (long)response.getCompactionsSize());
    }

    @Test
    public void testGetNoCompaction() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String errorMessage = "Dummy error";
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        rqst.setDbname("foo");
        rqst.setTablename("bar");
        GetLatestCommittedCompactionInfoResponse response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertEquals((long)0L, (long)response.getCompactionsSize());
        this.addFailedCompaction("foo", "bar", CompactionType.MINOR, null, "Dummy error");
        response = this.txnHandler.getLatestCommittedCompactionInfo(rqst);
        Assert.assertEquals((long)0L, (long)response.getCompactionsSize());
    }

    @Test
    public void testMarkFailed() throws Exception {
        int i;
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        String workerId = "fred";
        String status = "failed";
        String errorMessage = "Dummy error";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        ci.errorMessage = "Dummy error";
        this.txnHandler.markFailed(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        boolean failedCheck = this.txnHandler.checkFailedCompactions(ci);
        Assert.assertFalse((boolean)failedCheck);
        try {
            this.txnHandler.markFailed(ci);
            Assert.fail((String)"The first call to markFailed() must have failed as this call did not throw the expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No record with CQ_ID="));
        }
        Assert.assertFalse((boolean)this.txnHandler.checkFailedCompactions(ci));
        for (i = 1; i < MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD); ++i) {
            this.addFailedCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        }
        Assert.assertTrue((boolean)this.txnHandler.checkFailedCompactions(ci));
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.txnHandler.checkFailedCompactions(ci));
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (long)7L, (TimeUnit)TimeUnit.DAYS);
        this.checkShowCompaction("foo", "bar", "ds=today", "failed", "Dummy error");
        for (i = 0; i < 300; ++i) {
            this.addFailedCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        }
        this.checkShowCompaction("foo", "bar", "ds=today", "failed", "Dummy error");
        this.txnHandler.purgeCompactionHistory();
    }

    private void checkShowCompaction(String dbName, String tableName, String partition, String status, String errorMessage) throws MetaException {
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        showCompactResponse.getCompacts().forEach(e -> {
            Assert.assertEquals((Object)dbName, (Object)e.getDbname());
            Assert.assertEquals((Object)tableName, (Object)e.getTablename());
            Assert.assertEquals((Object)partition, (Object)e.getPartitionname());
            Assert.assertEquals((Object)status, (Object)e.getState());
            Assert.assertEquals((Object)errorMessage, (Object)e.getErrorMessage());
        });
    }

    private void addFailedCompaction(String dbName, String tableName, CompactionType type, String partitionName, String errorMessage) throws MetaException {
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, type);
        if (partitionName != null) {
            rqst.setPartitionname(partitionName);
        }
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.errorMessage = errorMessage;
        this.txnHandler.markFailed(ci);
    }

    private void addSucceededCompaction(String dbName, String tableName, String partitionName, CompactionType type) throws MetaException {
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, type);
        if (partitionName != null) {
            rqst.setPartitionname(partitionName);
        }
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        this.txnHandler.markCleaned(ci);
    }

    private void addWaitingForCleaningCompaction(String dbName, String tableName, CompactionType type, String partitionName, String errorMessage) throws MetaException {
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, type);
        if (partitionName != null) {
            rqst.setPartitionname(partitionName);
        }
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.errorMessage = errorMessage;
        this.txnHandler.markCompacted(ci);
    }

    private void addDidNotInitiateCompaction(String dbName, String tableName, String partitionName, CompactionType type, String errorMessage) throws MetaException {
        CompactionInfo ci = new CompactionInfo(dbName, tableName, partitionName, type);
        ci.errorMessage = errorMessage;
        ci.id = 0L;
        this.txnHandler.markFailed(ci);
    }

    private void addRefusedCompaction(String dbName, String tableName, String partitionName, CompactionType type, String errorMessage) throws MetaException {
        CompactionInfo ci = new CompactionInfo(dbName, tableName, partitionName, type);
        ci.errorMessage = errorMessage;
        ci.id = 0L;
        this.txnHandler.markRefused(ci);
    }

    @Test
    public void testPurgeCompactionHistory() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_REFUSED, (long)2L);
        this.txnHandler.setConf((Configuration)this.conf);
        String dbName = "default";
        String tableName = "tpch";
        String part1 = "(p=1)";
        String part2 = "(p=2)";
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MAJOR);
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MAJOR);
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MAJOR);
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part1, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part1, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part1, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part2, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part2, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part2, "message");
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part2, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.countCompactionsInHistory(dbName, tableName, part1, 3, 3, 3, 3);
        this.countCompactionsInHistory(dbName, tableName, part2, 0, 4, 0, 0);
        this.txnHandler.purgeCompactionHistory();
        this.countCompactionsInHistory(dbName, tableName, part1, 2, 2, 2, 2);
        this.countCompactionsInHistory(dbName, tableName, part2, 0, 2, 0, 0);
    }

    @Test
    public void testPurgeCompactionHistoryTimeout() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED, (long)2L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_REFUSED, (long)2L);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_TIMEOUT, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.txnHandler.setConf((Configuration)this.conf);
        String dbName = "default";
        String tableName = "tpch";
        String part1 = "(p=1)";
        this.addFailedCompaction(dbName, tableName, CompactionType.MINOR, part1, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MINOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MINOR, "message");
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MINOR);
        this.addFailedCompaction(dbName, tableName, CompactionType.MINOR, part1, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MINOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MINOR, "message");
        this.countCompactionsInHistory(dbName, tableName, part1, 1, 2, 2, 2);
        this.txnHandler.purgeCompactionHistory();
        this.countCompactionsInHistory(dbName, tableName, part1, 1, 1, 1, 1);
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MAJOR);
        this.txnHandler.purgeCompactionHistory();
        this.countCompactionsInHistory(dbName, tableName, part1, 2, 0, 0, 0);
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part1, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MINOR);
        this.txnHandler.purgeCompactionHistory();
        this.countCompactionsInHistory(dbName, tableName, part1, 2, 1, 1, 1);
        this.addFailedCompaction(dbName, tableName, CompactionType.MAJOR, part1, "message");
        this.addDidNotInitiateCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addRefusedCompaction(dbName, tableName, part1, CompactionType.MAJOR, "message");
        this.addSucceededCompaction(dbName, tableName, part1, CompactionType.MAJOR);
        this.txnHandler.purgeCompactionHistory();
        this.countCompactionsInHistory(dbName, tableName, part1, 2, 0, 0, 0);
        this.checkShowCompaction(dbName, tableName, part1, "succeeded", null);
    }

    private void countCompactionsInHistory(String dbName, String tableName, String partition, int expectedSucceeded, int expectedFailed, int expectedDidNotInitiate, int expextedRefused) throws MetaException {
        ShowCompactResponse resp = this.txnHandler.showCompact(new ShowCompactRequest());
        List filteredToPartition = resp.getCompacts().stream().filter(e -> e.getDbname().equals(dbName) && e.getTablename().equals(tableName) && (partition == null || partition.equals(e.getPartitionname()))).collect(Collectors.toList());
        Assert.assertEquals((long)expectedSucceeded, (long)filteredToPartition.stream().filter(e -> e.getState().equals("succeeded")).count());
        Assert.assertEquals((long)expectedFailed, (long)filteredToPartition.stream().filter(e -> e.getState().equals("failed")).count());
        Assert.assertEquals((long)expectedDidNotInitiate, (long)filteredToPartition.stream().filter(e -> e.getState().equals("did not initiate")).count());
        Assert.assertEquals((long)expextedRefused, (long)filteredToPartition.stream().filter(e -> e.getState().equals("refused")).count());
    }

    @Test
    public void testRevokeFromLocalWorkers() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "baz", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "bazzoo", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred-193892", WORKER_VERSION)));
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("bob-193892", WORKER_VERSION)));
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred-193893", WORKER_VERSION)));
        this.txnHandler.revokeFromLocalWorkers("fred");
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)3L, (long)compacts.size());
        boolean sawWorkingBob = false;
        int initiatedCount = 0;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                Assert.assertEquals((Object)"bob-193892", (Object)c.getWorkerid());
                sawWorkingBob = true;
                continue;
            }
            if (c.getState().equals("initiated")) {
                ++initiatedCount;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawWorkingBob);
        Assert.assertEquals((long)2L, (long)initiatedCount);
    }

    @Test
    public void testRevokeTimedOutWorkers() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "baz", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred-193892", WORKER_VERSION)));
        Thread.sleep(200L);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred-193892", WORKER_VERSION)));
        this.txnHandler.revokeTimedoutWorkers(100L);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        boolean sawWorking = false;
        boolean sawInitiated = false;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                sawWorking = true;
                continue;
            }
            if (c.getState().equals("initiated")) {
                sawInitiated = true;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawWorking);
        Assert.assertTrue((boolean)sawInitiated);
    }

    @Test
    public void testFindPotentialCompactions() throws Exception {
        CompactionInfo ci2;
        long txnid = this.openTxn();
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "mytable", null, DataOperationType.UPDATE));
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "yourtable", "mypartition=myvalue", DataOperationType.UPDATE));
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        Assert.assertEquals((long)0L, (long)this.txnHandler.getNumLocks());
        Set potentials = this.txnHandler.findPotentialCompactions(100, -1L);
        Assert.assertEquals((long)2L, (long)potentials.size());
        boolean sawMyTable = false;
        boolean sawYourTable = false;
        for (CompactionInfo ci2 : potentials) {
            sawMyTable |= ci2.dbname.equals("mydb") && ci2.tableName.equals("mytable") && ci2.partName == null;
            sawYourTable |= ci2.dbname.equals("mydb") && ci2.tableName.equals("yourtable") && ci2.partName.equals("mypartition=myvalue");
        }
        Assert.assertTrue((boolean)sawMyTable);
        Assert.assertTrue((boolean)sawYourTable);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, Instant.now().minusSeconds(1L).toEpochMilli());
        Assert.assertEquals((long)2L, (long)potentials.size());
        TimeUnit.SECONDS.sleep(2L);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, Instant.now().minusSeconds(1L).toEpochMilli());
        Assert.assertEquals((long)0L, (long)potentials.size());
        CompactionRequest rqst = new CompactionRequest("mydb", "mytable", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        ci2 = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        this.txnHandler.markFailed(ci2);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, Instant.now().minusSeconds(1L).toEpochMilli());
        Assert.assertEquals((long)1L, (long)potentials.size());
    }

    @Test
    public void testMarkCleanedCleansTxnsAndTxnComponents() throws Exception {
        long txnid = this.openTxn();
        long mytableWriteId = this.allocateTableWriteIds("mydb", "mytable", txnid);
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        comp.setOperationType(DataOperationType.DELETE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        txnid = this.openTxn();
        long fooWriteId = this.allocateTableWriteIds("mydb", "foo", txnid);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("foo");
        comp.setPartitionname("bar=compact");
        comp.setOperationType(DataOperationType.UPDATE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("foo");
        comp.setPartitionname("baz=compact");
        comp.setOperationType(DataOperationType.UPDATE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        CompactionRequest rqst = new CompactionRequest("mydb", "mytable", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.highestWriteId = mytableWriteId;
        ci.txnId = 1L;
        this.txnHandler.updateCompactorState(ci, 1L);
        this.txnHandler.markCompacted(ci);
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((long)1L, (long)toClean.size());
        this.txnHandler.markCleaned(ci);
        GetOpenTxnsResponse txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)txnList.getOpen_txnsSize());
        txnid = this.openTxn();
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)txnList.getOpen_txnsSize());
        rqst = new CompactionRequest("mydb", "foo", CompactionType.MAJOR);
        rqst.setPartitionname("bar");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((long)0L, (long)this.txnHandler.findReadyToClean(0L, 0L).size());
        ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.highestWriteId = fooWriteId;
        this.txnHandler.updateCompactorState(ci, 2L);
        ci.txnId = 2L;
        this.txnHandler.markCompacted(ci);
        toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((long)1L, (long)toClean.size());
        this.txnHandler.markCleaned(ci);
        this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost"));
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        this.txnHandler.setOpenTxnTimeOutMillis(1L);
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)3L, (long)txnList.getOpen_txnsSize());
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
    }

    @Test
    public void addDynamicPartitions() throws Exception {
        String dbName = "default";
        String tableName = "adp_table";
        OpenTxnsResponse openTxns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost"));
        long txnId = (Long)openTxns.getTxn_ids().get(0);
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setTxnIds(openTxns.getTxn_ids());
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        long writeId = ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId();
        Assert.assertEquals((long)txnId, (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        Assert.assertEquals((long)1L, (long)writeId);
        LockComponent lc = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, dbName);
        lc.setIsDynamicPartitionWrite(true);
        lc.setTablename(tableName);
        DataOperationType dop = DataOperationType.UPDATE;
        lc.setOperationType(dop);
        LockRequest lr = new LockRequest(Arrays.asList(lc), "me", "localhost");
        lr.setTxnid(txnId);
        LockResponse lock = this.txnHandler.lock(lr);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, dbName, tableName, Arrays.asList("ds=yesterday", "ds=today"));
        adp.setOperationType(dop);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        Set potentials = this.txnHandler.findPotentialCompactions(1000, -1L);
        Assert.assertEquals((long)2L, (long)potentials.size());
        TreeSet sorted = new TreeSet(potentials);
        int i = 0;
        block4: for (CompactionInfo ci : sorted) {
            Assert.assertEquals((Object)dbName, (Object)ci.dbname);
            Assert.assertEquals((Object)tableName, (Object)ci.tableName);
            switch (i++) {
                case 0: {
                    Assert.assertEquals((Object)"ds=today", (Object)ci.partName);
                    continue block4;
                }
                case 1: {
                    Assert.assertEquals((Object)"ds=yesterday", (Object)ci.partName);
                    continue block4;
                }
            }
            throw new RuntimeException("What?");
        }
    }

    @Test
    public void testEnqueueTimeEvenAfterFailed() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        long before = System.currentTimeMillis();
        this.txnHandler.compact(rqst);
        long after = System.currentTimeMillis();
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        long enqueueTime = element.getEnqueueTime();
        Assert.assertTrue((enqueueTime <= after ? 1 : 0) != 0);
        Assert.assertTrue((enqueueTime >= before ? 1 : 0) != 0);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        this.txnHandler.markFailed(ci);
        this.checkEnqueueTime(enqueueTime);
    }

    @Test
    public void testEnqueueTimeThroughLifeCycle() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        long before = System.currentTimeMillis();
        this.txnHandler.compact(rqst);
        long after = System.currentTimeMillis();
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        long enqueueTime = element.getEnqueueTime();
        Assert.assertTrue((enqueueTime <= after ? 1 : 0) != 0);
        Assert.assertTrue((enqueueTime >= before ? 1 : 0) != 0);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        ci.runAs = "bob";
        this.txnHandler.updateCompactorState(ci, this.openTxn());
        this.checkEnqueueTime(enqueueTime);
        this.txnHandler.markCompacted(ci);
        this.checkEnqueueTime(enqueueTime);
        this.txnHandler.markCleaned(ci);
        this.checkEnqueueTime(enqueueTime);
    }

    @Test
    public void testFindPotentialCompactions_limitFetchSize() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE, (long)1L);
        long txnId = this.openTxn();
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "mytable", "mypartition=myvalue", DataOperationType.UPDATE));
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "yourtable", "mypartition=myvalue", DataOperationType.UPDATE));
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertSame((Object)res.getState(), (Object)LockState.ACQUIRED);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        Assert.assertEquals((long)0L, (long)this.txnHandler.getNumLocks());
        Set potentials = this.txnHandler.findPotentialCompactions(100, -1L);
        Assert.assertEquals((long)1L, (long)potentials.size());
    }

    @Test
    public void testFindNextToClean_limitFetchSize() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE, (long)1L);
        this.createAReadyToCleanCompaction("foo", "bar", "ds=today", CompactionType.MINOR);
        this.createAReadyToCleanCompaction("foo2", "bar2", "ds=today", CompactionType.MINOR);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((long)1L, (long)toClean.size());
        Assert.assertNull((Object)this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION)));
    }

    @Test
    public void testFindReadyToCleanAborts_limitFetchSize() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE, (long)1L);
        long txnId = this.openTxn();
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "mytable", "mypartition=myvalue", DataOperationType.UPDATE));
        components.add(this.createLockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb", "yourtable", "mypartition=myvalue", DataOperationType.UPDATE));
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertSame((Object)res.getState(), (Object)LockState.ACQUIRED);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnId));
        List potentials = this.txnHandler.findReadyToCleanAborts(1L, 0);
        Assert.assertEquals((long)1L, (long)potentials.size());
    }

    private static FindNextCompactRequest aFindNextCompactRequest(String workerId, String workerVersion) {
        FindNextCompactRequest request = new FindNextCompactRequest();
        request.setWorkerId(workerId);
        request.setWorkerVersion(workerVersion);
        return request;
    }

    private void checkEnqueueTime(long enqueueTime) throws MetaException {
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        Assert.assertEquals((long)enqueueTime, (long)element.getEnqueueTime());
    }

    @Before
    public void setUp() throws Exception {
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((Configuration)this.conf);
    }

    private long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }

    private long allocateTableWriteIds(String dbName, String tblName, long txnid) throws Exception {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        rqst.setTxnIds(Collections.singletonList(txnid));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        return ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId();
    }

    private void createAReadyToCleanCompaction(String dbName, String tableName, String partitionName, CompactionType compactionType) throws MetaException {
        long txnId;
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, compactionType);
        rqst.setPartitionname(partitionName);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact(TestCompactionTxnHandler.aFindNextCompactRequest("fred", WORKER_VERSION));
        Assert.assertNotNull((Object)ci);
        ci.highestWriteId = 41L;
        ci.txnId = txnId = this.openTxn();
        this.txnHandler.updateCompactorState(ci, txnId);
        this.txnHandler.markCompacted(ci);
    }

    private LockComponent createLockComponent(LockType lockType, LockLevel lockLevel, String dbName, String tableName, String partitionName, DataOperationType dataOperationType) {
        LockComponent lockComponent = new LockComponent(lockType, lockLevel, dbName);
        lockComponent.setTablename(tableName);
        lockComponent.setPartitionname(partitionName);
        lockComponent.setOperationType(dataOperationType);
        return lockComponent;
    }
}

