/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestTablesListByFilter
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "test_tables_list_by_filter";
    private AbstractMetaStoreService metaStore;
    private HiveMetaStoreClient client;
    private Table[] testTables = new Table[6];

    public TestTablesListByFilter(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setupDb() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DEFAULT_DATABASE, true, true, true);
        Configuration conf = this.metaStore.getConf();
        new DatabaseBuilder().setName(DEFAULT_DATABASE).create((IMetaStoreClient)this.client, conf);
        this.testTables[0] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_0").addCol("test_col", "int")).setOwner("Owner1").setLastAccessTime(1000).addTableParam("param1", "value1").create((IMetaStoreClient)this.client, conf);
        this.testTables[1] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_1").addCol("test_col", "int")).setOwner("Owner1").setLastAccessTime(2000).addTableParam("param1", "value2").create((IMetaStoreClient)this.client, conf);
        this.testTables[2] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_2").addCol("test_col", "int")).setOwner("Owner2").setLastAccessTime(1000).addTableParam("param1", "value2").create((IMetaStoreClient)this.client, conf);
        this.testTables[3] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_3").addCol("test_col", "int")).setOwner("Owner3").setLastAccessTime(3000).addTableParam("param1", "value2").create((IMetaStoreClient)this.client, conf);
        this.testTables[4] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_4").addCol("test_col", "int")).setOwner("Tester").setLastAccessTime(2500).addTableParam("param1", "value4").create((IMetaStoreClient)this.client, conf);
        this.testTables[5] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_5").addCol("test_col", "int")).create((IMetaStoreClient)this.client, conf);
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDownDb() throws Exception {
        try {
            if (this.client != null) {
                this.client.dropDatabase(DEFAULT_DATABASE, true, true, true);
            }
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
    }

    @Test
    public void testListTableNamesByFilterCheckParameter() throws Exception {
        String filter = "hive_filter_field_params__param1=\"value2\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)3L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[3].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckNotEquals() throws Exception {
        String filter = "hive_filter_field_params__param1<>\"value2\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        filter = "hive_filter_field_params__param1 != \"value2\"";
        List tableNames1 = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((Object)tableNames, (Object)tableNames1);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[4].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckCombined() throws Exception {
        String filter = "hive_filter_field_last_access__<3000 and (hive_filter_field_owner__=\"Tester\" or hive_filter_field_params__param1=\"value2\")";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)3L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[4].getTableName()));
    }
}

