/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TestMetastoreExpr;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionFilterMode;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.TestListPartitions;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestListPartitionsWithXIncludeParams
extends TestListPartitions {
    private Configuration hiveConf;
    private Set<String> includeKeys = new HashSet<String>();
    private Set<String> excludeKeys = new HashSet<String>();
    private Map<String, String> partParams = new HashMap<String, String>();

    public TestListPartitionsWithXIncludeParams(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.partParams.put("key1", "value1");
        this.partParams.put("akey1", "avalue1");
        this.partParams.put("akey10", "avalue10");
        this.partParams.put("excludekey1", "value1");
        this.partParams.put("excludekey2", "value1");
        this.includeKeys.add("key1");
        this.includeKeys.add("akey1");
        this.excludeKeys.add("excludekey1");
        this.excludeKeys.add("excludekey2");
        this.hiveConf = metaStore.getConf();
        MetastoreConf.setVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, (String)PartitionExpressionForMetastoreTest.class.getName());
        MetastoreConf.setVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_INCLUDE_PATTERN, (String)"%k_y_");
        MetastoreConf.setVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_EXCLUDE_PATTERN, (String)"%exclu%");
    }

    protected void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder partitionBuilder = new PartitionBuilder().inTable(table);
        values.forEach(val -> partitionBuilder.addValue(val));
        this.partParams.forEach((k, v) -> partitionBuilder.addPartParam(k, v));
        client.add_partition(partitionBuilder.build(this.getMetaStore().getConf()));
    }

    protected void addPartitions(IMetaStoreClient client, List<Partition> partitions) throws TException {
        partitions.stream().forEach(partition -> partition.setParameters(this.partParams));
        super.addPartitions(client, partitions);
    }

    protected void assertPartitionsHaveCorrectParams(List<Partition> partitions) {
        for (int i = 0; i < partitions.size(); ++i) {
            Map parameters = partitions.get(i).getParameters();
            TestCase.assertTrue((String)"included parameter key is not found in the partition", (boolean)parameters.keySet().containsAll(this.includeKeys));
            Assert.assertFalse((String)"excluded parameter key is found in the partition", (boolean)parameters.keySet().stream().anyMatch(key -> this.excludeKeys.contains(key)));
            Assert.assertEquals((long)this.includeKeys.size(), (long)parameters.size());
        }
    }

    @Test
    public void testGetPartitionsByNames() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        List<String> part_names = Arrays.asList("yyyy=1999/mm=01/dd=02", "yyyy=2009/mm=02/dd=10", "yyyy=1999/mm=03/dd=02");
        GetPartitionsByNamesRequest request = MetaStoreUtils.convertToGetPartitionsByNamesRequest((String)MetaStoreUtils.prependCatalogToDbName((String)t.getCatName(), (String)t.getDbName(), (Configuration)this.hiveConf), (String)t.getTableName(), part_names);
        List partitions = this.getClient().getPartitionsByNames(request).getPartitions();
        List values = partitions.stream().map(partition -> partition.getValues()).collect(Collectors.toList());
        this.assertCorrectPartitionNames(part_names.subList(0, 2), values, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        this.assertPartitionsHaveCorrectParams(partitions);
        part_names = Arrays.asList("yyyy=1999/mm=03/dd=02", "yyyy=2017/mm=02/dd=13");
        request = MetaStoreUtils.convertToGetPartitionsByNamesRequest((String)MetaStoreUtils.prependCatalogToDbName((String)t.getCatName(), (String)t.getDbName(), (Configuration)this.hiveConf), (String)t.getTableName(), part_names);
        partitions = this.getClient().getPartitionsByNames(request).getPartitions();
        TestCase.assertTrue((boolean)partitions.isEmpty());
    }

    @Test
    public void testGetPartitionsRequest() throws Exception {
        TestListPartitions.ReturnTable returnTable = this.createTable4PartColsParts(this.getClient());
        Table t = returnTable.table;
        GetPartitionsRequest request = new GetPartitionsRequest(t.getDbName(), t.getTableName(), new GetProjectionsSpec(), new GetPartitionsFilterSpec());
        request.setCatName(t.getCatName());
        List partitions = MetaStoreServerUtils.getPartitionsByProjectSpec((IMetaStoreClient)this.getClient(), (GetPartitionsRequest)request);
        this.assertPartitionsHaveCorrectParams(partitions);
        List values = partitions.stream().map(partition -> partition.getValues()).collect(Collectors.toList());
        Assert.assertEquals((Object)returnTable.testValues, values);
        request.getProjectionSpec().setFieldList(Arrays.asList("dbName", "tableName", "catName", "parameters", "values"));
        partitions = MetaStoreServerUtils.getPartitionsByProjectSpec((IMetaStoreClient)this.getClient(), (GetPartitionsRequest)request);
        this.assertPartitionsHaveCorrectParams(partitions);
        values = partitions.stream().map(partition -> partition.getValues()).collect(Collectors.toList());
        Assert.assertEquals((Object)returnTable.testValues, values);
        request.getFilterSpec().setFilterMode(PartitionFilterMode.BY_VALUES);
        request.getFilterSpec().setFilters(Arrays.asList("2017"));
        partitions = MetaStoreServerUtils.getPartitionsByProjectSpec((IMetaStoreClient)this.getClient(), (GetPartitionsRequest)request);
        this.assertPartitionsHaveCorrectParams(partitions);
        values = partitions.stream().map(partition -> partition.getValues()).collect(Collectors.toList());
        Assert.assertEquals((String)"Two partitions expected", (long)2L, (long)values.size());
        Assert.assertEquals(Arrays.asList(Arrays.asList("2017", "10", "26"), Arrays.asList("2017", "11", "27")), returnTable.testValues.subList(2, 4));
    }

    @Test
    public void testListPartitionsByExr() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        this.checkExpr(2, e.strCol("yyyy").val("2017").pred("=", 2).build());
        this.checkExpr(3, e.strCol("mm").val("11").pred(">", 2).build());
        this.checkExpr(4, e.strCol("dd").val("29").pred(">=", 2).build());
        this.checkExpr(2, e.strCol("yyyy").val("2017").pred("!=", 2).build());
        this.checkExpr(1, e.strCol("yyyy").val("2017").pred("=", 2).strCol("mm").val("10").pred(">=", 2).pred("and", 2).build());
        this.checkExpr(3, e.strCol("dd").val("10").pred("<", 2).strCol("yyyy").val("2009").pred("!=", 2).pred("or", 2).build());
        this.checkExpr(0, e.strCol("yyyy").val("2019").pred("=", 2).build());
    }

    private void checkExpr(int numParts, ExprNodeGenericFuncDesc expr) throws Exception {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        byte[] exprBytes = SerializationUtilities.serializeObjectWithTypeInformation((Serializable)expr);
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", exprBytes, null, (short)-1, partitions);
        Assert.assertEquals((String)("Partition check failed: " + expr.getExprString()), (long)numParts, (long)partitions.size());
        this.assertPartitionsHaveCorrectParams(partitions);
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(exprBytes));
        ArrayList msParts = new ArrayList();
        this.getClient().listPartitionsSpecByExpr(req, msParts);
        int numPartitions = 0;
        for (PartitionSpec partitionSpec : msParts) {
            TestCase.assertTrue((partitionSpec.getPartitionList() == null || partitionSpec.getPartitionList().getPartitions() == null || partitionSpec.getPartitionList().getPartitions().isEmpty() ? 1 : 0) != 0);
            for (PartitionWithoutSD partitionWithoutSD : partitionSpec.getSharedSDPartitionSpec().getPartitions()) {
                ++numPartitions;
                Map parameters = partitionWithoutSD.getParameters();
                TestCase.assertTrue((String)"included parameter key is not found in the partition", (boolean)parameters.keySet().containsAll(this.includeKeys));
                Assert.assertFalse((String)"excluded parameter key is found in the partition", (boolean)parameters.keySet().stream().anyMatch(key -> this.excludeKeys.contains(key)));
                Assert.assertEquals((long)this.includeKeys.size(), (long)parameters.size());
            }
        }
        Assert.assertEquals((String)("Partition check failed: " + expr.getExprString()), (long)numParts, (long)numPartitions);
    }

    public static class PartitionExpressionForMetastoreTest
    extends PartitionExpressionForMetastore {
    }
}

