/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringGroupColConcatStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringGroupConcatColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringScalarConcatStringGroupCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;

@Description(name="concat", value="_FUNC_(str1, str2, ... strN) - returns the concatenation of str1, str2, ... strN or _FUNC_(bin1, bin2, ... binN) - returns the concatenation of bytes in binary data  bin1, bin2, ... binN", extended="Returns NULL if any argument is NULL.\nExample:\n  > SELECT _FUNC_('abc', 'def') FROM src LIMIT 1;\n  'abcdef'")
@VectorizedExpressions(value={StringGroupConcatColCol.class, StringGroupColConcatStringScalar.class, StringScalarConcatStringGroupCol.class})
public class GenericUDFConcat
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private transient PrimitiveObjectInspectorConverter.StringConverter[] stringConverters;
    private transient PrimitiveObjectInspector.PrimitiveCategory returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
    private transient BytesWritable[] bw;
    private transient GenericUDFUtils.StringHelper returnHelper;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.argumentOIs = arguments;
        boolean fixedLengthReturnValue = true;
        int returnLength = 0;
        for (int idx = 0; idx < arguments.length; ++idx) {
            if (arguments[idx].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentException("CONCAT only takes primitive arguments");
            }
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)arguments[idx];
            PrimitiveObjectInspector.PrimitiveCategory currentCategory = poi.getPrimitiveCategory();
            if (idx == 0) {
                this.returnType = currentCategory;
            }
            switch (currentCategory) {
                case BINARY: {
                    fixedLengthReturnValue = false;
                    if (this.returnType == currentCategory) break;
                    this.returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    if (!fixedLengthReturnValue) {
                        this.returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                    }
                    if (!fixedLengthReturnValue || currentCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) break;
                    this.returnType = PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
                    break;
                }
                default: {
                    this.returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                    fixedLengthReturnValue = false;
                }
            }
            if (!fixedLengthReturnValue || (this.returnType != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR || (returnLength += GenericUDFUtils.StringHelper.getFixedStringSizeForType(poi)) <= 65535) && (this.returnType != PrimitiveObjectInspector.PrimitiveCategory.CHAR || returnLength <= 255)) continue;
            this.returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
            fixedLengthReturnValue = false;
        }
        if (this.returnType == PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            this.bw = new BytesWritable[arguments.length];
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        this.createStringConverters();
        this.returnHelper = new GenericUDFUtils.StringHelper(this.returnType);
        switch (this.returnType) {
            case STRING: {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
            case CHAR: {
                CharTypeInfo typeInfo = TypeInfoFactory.getCharTypeInfo((int)returnLength);
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
            }
            case VARCHAR: {
                VarcharTypeInfo typeInfo = TypeInfoFactory.getVarcharTypeInfo((int)returnLength);
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
            }
        }
        throw new UDFArgumentException("Unexpected CONCAT return type of " + this.returnType);
    }

    private void createStringConverters() {
        this.stringConverters = new PrimitiveObjectInspectorConverter.StringConverter[this.argumentOIs.length];
        for (int idx = 0; idx < this.argumentOIs.length; ++idx) {
            this.stringConverters[idx] = new PrimitiveObjectInspectorConverter.StringConverter((PrimitiveObjectInspector)this.argumentOIs[idx]);
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.returnType == PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            return this.binaryEvaluate(arguments);
        }
        return this.returnHelper.setReturnValue(this.stringEvaluate(arguments));
    }

    public Object binaryEvaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int len = 0;
        for (int idx = 0; idx < arguments.length; ++idx) {
            this.bw[idx] = ((BinaryObjectInspector)this.argumentOIs[idx]).getPrimitiveWritableObject(arguments[idx].get());
            if (this.bw[idx] == null) {
                return null;
            }
            len += this.bw[idx].getLength();
        }
        byte[] out = new byte[len];
        int curLen = 0;
        for (BytesWritable bytes : this.bw) {
            System.arraycopy(bytes.getBytes(), 0, out, curLen, bytes.getLength());
            curLen += bytes.getLength();
        }
        return new BytesWritable(out);
    }

    public String stringEvaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < arguments.length; ++idx) {
            String val = null;
            if (arguments[idx] != null) {
                val = (String)this.stringConverters[idx].convert(arguments[idx].get());
            }
            if (val == null) {
                return null;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("concat", children);
    }
}

