/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MinorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MinorQueryCompactor.class.getName());

    MinorQueryCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException {
        LOG.info("Running query based minor compaction");
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        AcidUtils.setAcidOperationalProperties((Configuration)hiveConf, true, AcidUtils.getAcidOperationalProperties(table.getParameters()));
        StorageDescriptor storageDescriptor = context.getSd();
        AcidDirectory dir = context.getAcidDirectory();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        HiveConf conf = this.setUpDriverSession(hiveConf);
        String tmpTableName = table.getDbName() + "_tmp_compactor_" + table.getTableName() + "_" + System.currentTimeMillis();
        Path resultDeltaDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, conf, false, false, false, dir);
        Path resultDeleteDeltaDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, conf, false, true, false, dir);
        List<String> createQueries = this.getCreateQueries(table, tmpTableName, dir, writeIds, resultDeltaDir, resultDeleteDeltaDir);
        List<String> compactionQueries = this.getCompactionQueries(tmpTableName, table, writeIds);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(conf, tmpTableName, context.getCompactionInfo(), Lists.newArrayList((Object[])new Path[]{resultDeltaDir, resultDeleteDeltaDir}), createQueries, compactionQueries, dropQueries, table.getParameters());
        return true;
    }

    @Override
    protected HiveConf setUpDriverSession(HiveConf hiveConf) {
        HiveConf conf = super.setUpDriverSession(hiveConf);
        conf.set(HiveConf.ConfVars.SPLIT_GROUPING_MODE.varname, "compactor");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS, false);
        return conf;
    }

    @Override
    protected void commitCompaction(String tmpTableName, HiveConf conf) throws IOException, HiveException {
        QueryCompactor.Util.cleanupEmptyTableDir(conf, "delta_" + tmpTableName + "_result");
        QueryCompactor.Util.cleanupEmptyTableDir(conf, "delete_delta_" + tmpTableName + "_result");
    }

    private List<String> getCreateQueries(Table table, String tempTableBase, AcidDirectory dir, ValidWriteIdList writeIds, Path tmpTableResultLocation, Path tmpTableDeleteResultLocation) {
        ArrayList<String> queries = new ArrayList<String>();
        String tmpTableName = "delta_" + tempTableBase;
        queries.add(this.buildCreateTableQuery(table, tmpTableName, true, false, null));
        String alterQuery = this.buildAlterTableQuery(tmpTableName, dir, writeIds, false);
        if (!alterQuery.isEmpty()) {
            queries.add(alterQuery);
        }
        queries.add(this.buildCreateTableQuery(table, tmpTableName + "_result", false, true, tmpTableResultLocation.toString()));
        String tmpDeleteTableName = "delete_delta_" + tempTableBase;
        queries.add(this.buildCreateTableQuery(table, tmpDeleteTableName, true, false, null));
        alterQuery = this.buildAlterTableQuery(tmpDeleteTableName, dir, writeIds, true);
        if (!alterQuery.isEmpty()) {
            queries.add(alterQuery);
        }
        queries.add(this.buildCreateTableQuery(table, tmpDeleteTableName + "_result", false, true, tmpTableDeleteResultLocation.toString()));
        return queries;
    }

    private String buildCreateTableQuery(Table table, String newTableName, boolean isPartitioned, boolean isBucketed, String location) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, false).setOperation(CompactionQueryBuilder.Operation.CREATE).setResultTableName(newTableName).setSourceTab(table).setBucketed(isBucketed).setPartitioned(isPartitioned).setLocation(location).build();
    }

    private String buildAlterTableQuery(String tableName, AcidDirectory dir, ValidWriteIdList validWriteIdList, boolean isDeleteDelta) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, false).setOperation(CompactionQueryBuilder.Operation.ALTER).setResultTableName(tableName).setDir(dir).setValidWriteIdList(validWriteIdList).setIsDeleteDelta(isDeleteDelta).build();
    }

    private List<String> getCompactionQueries(String tmpTableBase, Table table, ValidWriteIdList validWriteIdList) {
        ArrayList<String> queries = new ArrayList<String>();
        String sourceTableName = "delta_" + tmpTableBase;
        String resultTableName = sourceTableName + "_result";
        queries.add(this.buildCompactionQuery(sourceTableName, resultTableName, table, validWriteIdList));
        String sourceDeleteTableName = "delete_delta_" + tmpTableBase;
        String resultDeleteTableName = sourceDeleteTableName + "_result";
        queries.add(this.buildCompactionQuery(sourceDeleteTableName, resultDeleteTableName, table, validWriteIdList));
        return queries;
    }

    private String buildCompactionQuery(String sourceTableName, String resultTableName, Table table, ValidWriteIdList validWriteIdList) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, false).setOperation(CompactionQueryBuilder.Operation.INSERT).setResultTableName(resultTableName).setSourceTabForInsert(sourceTableName).setSourceTab(table).setValidWriteIdList(validWriteIdList).build();
    }

    private List<String> getDropQueries(String tmpTableBase) {
        return Lists.newArrayList((Object[])new String[]{this.getDropQuery("delta_" + tmpTableBase), this.getDropQuery("delete_delta_" + tmpTableBase), this.getDropQuery("delta_" + tmpTableBase + "_result"), this.getDropQuery("delete_delta_" + tmpTableBase + "_result")});
    }

    private String getDropQuery(String tableToDrop) {
        return new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, false).setOperation(CompactionQueryBuilder.Operation.DROP).setResultTableName(tableToDrop).build();
    }
}

