/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSStatsPublisher
implements StatsPublisher {
    private Configuration conf;
    private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private Map<String, Map<String, String>> statsMap;

    @Override
    public boolean init(StatsCollectionContext context) {
        try {
            for (String tmpDir : context.getStatsTmpDirs()) {
                Path statsDir = new Path(tmpDir);
                this.LOG.debug("Initing FSStatsPublisher with : " + statsDir);
                statsDir.getFileSystem(context.getHiveConf()).mkdirs(statsDir);
                this.LOG.info("created : " + statsDir);
            }
            return true;
        }
        catch (IOException e) {
            this.LOG.error("Failed to create dir", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean connect(StatsCollectionContext context) {
        this.conf = context.getHiveConf();
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        this.LOG.debug("Connecting to : " + statsDir);
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            return statsDir.getFileSystem(this.conf).exists(statsDir);
        }
        catch (IOException e) {
            this.LOG.error("Failed to check if dir exists", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean publishStat(String partKV, Map<String, String> stats) {
        HashMap<String, String> cpy = new HashMap<String, String>(stats);
        Map<String, String> statMap = this.statsMap.get(partKV);
        if (null != statMap) {
            for (Map.Entry<String, String> e : statMap.entrySet()) {
                cpy.put(e.getKey(), String.valueOf(Long.parseLong(e.getValue()) + Long.parseLong((String)cpy.get(e.getKey()))));
            }
        }
        this.statsMap.put(partKV, cpy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnection(StatsCollectionContext context) {
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        if (context.getContextSuffix() == null) {
            throw new RuntimeException("ContextSuffix must be set before publishing!");
        }
        Path statsDir = new Path(statsDirs.get(0));
        try {
            Object suffix = Integer.toString(this.conf.getInt("mapred.task.partition", 0));
            if (context.getContextSuffix() != null) {
                suffix = (String)suffix + "_" + context.getContextSuffix();
            }
            Path statsFile = new Path(statsDir, "tmpstats-" + (String)suffix);
            Utilities.FILE_OP_LOGGER.trace("About to create stats file for this task : {}", (Object)statsFile);
            Output output = new Output((OutputStream)statsFile.getFileSystem(this.conf).create(statsFile, true));
            this.LOG.debug("Created file : " + statsFile);
            this.LOG.debug("Writing stats in it : " + this.statsMap);
            Kryo kryo = SerializationUtilities.borrowKryo();
            try {
                kryo.writeObject(output, this.statsMap);
            }
            finally {
                SerializationUtilities.releaseKryo(kryo);
            }
            output.close();
            return true;
        }
        catch (IOException e) {
            Utilities.FILE_OP_LOGGER.error("Failed to persist stats on filesystem", (Throwable)e);
            return false;
        }
    }
}

