/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SetClausePatcher;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class SplitUpdateRewriter
implements Rewriter<UpdateStatement> {
    private static final Context.Operation OPERATION = Context.Operation.UPDATE;
    private final HiveConf conf;
    protected final SqlGeneratorFactory sqlGeneratorFactory;
    private final SetClausePatcher setClausePatcher;

    public SplitUpdateRewriter(HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        this.conf = conf;
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.setClausePatcher = new SetClausePatcher();
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context context, UpdateStatement updateBlock) throws SemanticException {
        HashMap<Integer, ASTNode> setColExprs = new HashMap<Integer, ASTNode>(updateBlock.getSetClauseTree().getChildCount());
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        sqlGenerator.append("FROM\n");
        sqlGenerator.append("(SELECT ");
        sqlGenerator.appendAcidSelectColumns(OPERATION);
        List<String> deleteValues = sqlGenerator.getDeleteValues(OPERATION);
        int columnOffset = deleteValues.size();
        ArrayList<String> insertValues = new ArrayList<String>(updateBlock.getTargetTable().getCols().size());
        boolean first = true;
        List<FieldSchema> nonPartCols = updateBlock.getTargetTable().getCols();
        for (int i = 0; i < nonPartCols.size(); ++i) {
            if (first) {
                first = false;
            } else {
                sqlGenerator.append(",");
            }
            String name = nonPartCols.get(i).getName();
            ASTNode setCol = updateBlock.getSetCols().get(name);
            String identifier = HiveUtils.unparseIdentifier(name, (Configuration)this.conf);
            if (setCol != null) {
                if (setCol.getType() == 1270 && setCol.getChildCount() == 1 && setCol.getChild(0).getType() == 986) {
                    sqlGenerator.append(updateBlock.getColNameToDefaultConstraint().get(name));
                } else {
                    sqlGenerator.append(identifier);
                    setColExprs.put(i + columnOffset, setCol);
                }
            } else {
                sqlGenerator.append(identifier);
            }
            sqlGenerator.append(" AS ");
            sqlGenerator.append(identifier);
            insertValues.add(sqlGenerator.qualify(identifier));
        }
        if (updateBlock.getTargetTable().getPartCols() != null) {
            updateBlock.getTargetTable().getPartCols().forEach(fieldSchema -> insertValues.add(sqlGenerator.qualify(HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf))));
        }
        sqlGenerator.append(" FROM ").append(sqlGenerator.getTargetTableFullName()).append(") ");
        sqlGenerator.appendSubQueryAlias().append("\n");
        sqlGenerator.appendInsertBranch(null, insertValues);
        sqlGenerator.appendInsertBranch(null, deleteValues);
        sqlGenerator.appendSortKeys();
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(context, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(rewrittenTree, 1032, 1236, 1055);
        rewrittenCtx.setOperation(Context.Operation.UPDATE, true);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.INSERT);
        rewrittenCtx.addDeleteOfUpdateDestNamePrefix(2, Context.DestClausePrefix.DELETE);
        if (updateBlock.getWhereTree() != null) {
            rewrittenInsert.addChild((Tree)updateBlock.getWhereTree());
        }
        this.setClausePatcher.patchProjectionForUpdate(rewrittenInsert, setColExprs);
        rewrittenCtx.setEnableUnparse(false);
        return rr;
    }
}

