/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.lib.CostLessRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ExpressionWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.Quotation;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveUtils {
    static final byte[] escapeEscapeBytes = "\\\\".getBytes();
    static final byte[] escapeUnescapeBytes = "\\".getBytes();
    static final byte[] newLineEscapeBytes = "\\n".getBytes();
    static final byte[] newLineUnescapeBytes = "\n".getBytes();
    static final byte[] carriageReturnEscapeBytes = "\\r".getBytes();
    static final byte[] carriageReturnUnescapeBytes = "\r".getBytes();
    static final byte[] tabEscapeBytes = "\\t".getBytes();
    static final byte[] tabUnescapeBytes = "\t".getBytes();
    static final byte[] ctrlABytes = "\u0001".getBytes();
    static final Pattern TAG = Pattern.compile("tag_(.*)");
    static final Pattern SNAPSHOT_REF = Pattern.compile("(?:branch_|tag_)(.*)");
    public static final Logger LOG = LoggerFactory.getLogger(HiveUtils.class);

    public static String escapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static Text escapeText(Text text) {
        int length = text.getLength();
        byte[] textBytes = text.getBytes();
        Text escape = new Text(text);
        escape.clear();
        for (int i = 0; i < length; ++i) {
            int start;
            byte[] escaped;
            int c = text.charAt(i);
            escape.append(escaped, start, switch (c) {
                case 92 -> {
                    escaped = escapeEscapeBytes;
                    start = 0;
                    yield escaped.length;
                }
                case 10 -> {
                    escaped = newLineEscapeBytes;
                    start = 0;
                    yield escaped.length;
                }
                case 13 -> {
                    escaped = carriageReturnEscapeBytes;
                    start = 0;
                    yield escaped.length;
                }
                case 9 -> {
                    escaped = tabEscapeBytes;
                    start = 0;
                    yield escaped.length;
                }
                case 1 -> {
                    escaped = tabUnescapeBytes;
                    start = 0;
                    yield escaped.length;
                }
                default -> {
                    escaped = textBytes;
                    start = i;
                    yield 1;
                }
            });
        }
        return escape;
    }

    public static int unescapeText(Text text) {
        Text escape = new Text(text);
        text.clear();
        int length = escape.getLength();
        byte[] textBytes = escape.getBytes();
        boolean hadSlash = false;
        block7: for (int i = 0; i < length; ++i) {
            int c = escape.charAt(i);
            switch (c) {
                case 92: {
                    if (hadSlash) {
                        text.append(textBytes, i, 1);
                        hadSlash = false;
                        continue block7;
                    }
                    hadSlash = true;
                    continue block7;
                }
                case 110: {
                    if (hadSlash) {
                        byte[] newLine = newLineUnescapeBytes;
                        text.append(newLine, 0, newLine.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 114: {
                    if (hadSlash) {
                        byte[] carriageReturn = carriageReturnUnescapeBytes;
                        text.append(carriageReturn, 0, carriageReturn.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 116: {
                    if (hadSlash) {
                        byte[] tab = tabUnescapeBytes;
                        text.append(tab, 0, tab.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 9: {
                    if (hadSlash) {
                        text.append(textBytes, i - 1, 1);
                        hadSlash = false;
                    }
                    byte[] ctrlA = ctrlABytes;
                    text.append(ctrlA, 0, ctrlA.length);
                    continue block7;
                }
                default: {
                    if (hadSlash) {
                        text.append(textBytes, i - 1, 1);
                        hadSlash = false;
                    }
                    text.append(textBytes, i, 1);
                }
            }
        }
        return text.getLength();
    }

    public static String lightEscapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block5;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block5;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block5;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String unparseIdentifier(String identifier, Configuration conf) {
        Quotation quotation = Quotation.from((Configuration)conf);
        if (quotation != Quotation.NONE) {
            return HiveUtils.unparseIdentifier(identifier, Quotation.BACKTICKS);
        }
        return "`" + identifier + "`";
    }

    public static String unparseIdentifier(String identifier, Quotation quotation) {
        return String.format("%s%s%s", quotation.getQuotationChar(), identifier.replaceAll(quotation.getQuotationChar(), quotation.getQuotationChar() + quotation.getQuotationChar()), quotation.getQuotationChar());
    }

    public static String unparseIdentifier(String identifier) {
        return HiveUtils.unparseIdentifier(identifier, Quotation.BACKTICKS);
    }

    public static UnparseTranslator collectUnescapeIdentifierTranslations(ASTNode node) throws SemanticException {
        UnparseTranslator unparseTranslator = new UnparseTranslator(Quotation.BACKTICKS);
        unparseTranslator.enable();
        HashMultimap astNodeToProcessor = HashMultimap.create();
        astNodeToProcessor.put((Object)1270, (Object)new ColumnExprProcessor());
        astNodeToProcessor.put((Object)16, (Object)new ColumnExprProcessor());
        QuotedIdExpressionContext nodeProcessorCtx = new QuotedIdExpressionContext(unparseTranslator);
        CostLessRuleDispatcher costLessRuleDispatcher = new CostLessRuleDispatcher((nd, stack, procCtx, nodeOutputs) -> null, (SetMultimap<Integer, SemanticNodeProcessor>)astNodeToProcessor, nodeProcessorCtx);
        ExpressionWalker walker = new ExpressionWalker(costLessRuleDispatcher);
        walker.startWalking(Collections.singletonList(node), null);
        return unparseTranslator;
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, String className) throws HiveException {
        if (className == null) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
            HiveStorageHandler storageHandler = (HiveStorageHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return storageHandler;
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Error in loading storage handler." + e.getMessage(), (Throwable)e);
        }
    }

    private HiveUtils() {
    }

    public static List<HiveMetastoreAuthorizationProvider> getMetaStoreAuthorizeProviderManagers(Configuration conf, HiveConf.ConfVars authorizationProviderConfKey, HiveAuthenticationProvider authenticator) throws HiveException {
        String clsStrs = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)authorizationProviderConfKey);
        if (clsStrs == null) {
            return null;
        }
        ArrayList<HiveMetastoreAuthorizationProvider> authProviders = new ArrayList<HiveMetastoreAuthorizationProvider>();
        for (String clsStr : clsStrs.trim().split(",")) {
            LOG.info("Adding metastore authorization provider: " + clsStr);
            authProviders.add((HiveMetastoreAuthorizationProvider)HiveUtils.getAuthorizeProviderManager(conf, clsStr, authenticator, false));
        }
        return authProviders;
    }

    public static HiveAuthorizationProvider getAuthorizeProviderManager(Configuration conf, String authzClassName, HiveAuthenticationProvider authenticator, boolean nullIfOtherClass) throws HiveException {
        HiveAuthorizationProvider ret = null;
        try {
            Class cls = null;
            if (authzClassName == null || authzClassName.trim().equals("")) {
                cls = DefaultHiveAuthorizationProvider.class;
            } else {
                Class<?> configClass = Class.forName(authzClassName, true, JavaUtils.getClassLoader());
                if (nullIfOtherClass && !HiveAuthorizationProvider.class.isAssignableFrom(configClass)) {
                    return null;
                }
                cls = configClass;
            }
            if (cls != null) {
                ret = (HiveAuthorizationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        ret.setAuthenticator(authenticator);
        return ret;
    }

    public static HiveAuthorizerFactory getAuthorizerFactory(Configuration conf, HiveConf.ConfVars authorizationProviderConfKey) throws HiveException {
        Class cls = conf.getClass(authorizationProviderConfKey.varname, SQLStdHiveAuthorizerFactory.class, HiveAuthorizerFactory.class);
        if (cls == null) {
            throw new HiveException("Configuration value " + authorizationProviderConfKey.varname + " is not set to valid HiveAuthorizerFactory subclass");
        }
        HiveAuthorizerFactory authFactory = (HiveAuthorizerFactory)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        return authFactory;
    }

    public static HiveAuthenticationProvider getAuthenticator(Configuration conf, HiveConf.ConfVars authenticatorConfKey) throws HiveException {
        String clsStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)authenticatorConfKey);
        HiveAuthenticationProvider ret = null;
        try {
            Class cls = null;
            cls = clsStr == null || clsStr.trim().equals("") ? HadoopDefaultAuthenticator.class : Class.forName(clsStr, true, JavaUtils.getClassLoader());
            if (cls != null) {
                ret = (HiveAuthenticationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return ret;
    }

    public static String getLocalDirList(Configuration conf) {
        TezContext tezContext;
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && (tezContext = (TezContext)TezContext.get()) != null && tezContext.getTezProcessorContext() != null) {
            return StringUtils.arrayToString((String[])tezContext.getTezProcessorContext().getWorkDirs());
        }
        return null;
    }

    public static String getReplPolicy(String dbName) {
        if (dbName == null || dbName.isEmpty()) {
            return "*.*";
        }
        return dbName.toLowerCase() + ".*";
    }

    public static Path getDumpPath(Path root, String dbName, String tableName) {
        assert (dbName != null);
        if (tableName != null && !tableName.isEmpty()) {
            return new Path(root, dbName + "." + tableName);
        }
        return new Path(root, dbName);
    }

    public static String getTableSnapshotRef(String refName) {
        Matcher ref = SNAPSHOT_REF.matcher(String.valueOf(refName));
        return ref.matches() ? ref.group(1) : null;
    }

    public static Boolean isTableTag(String refName) {
        Matcher ref = TAG.matcher(refName);
        return ref.matches();
    }

    public static String getLowerCaseTableName(String refName) {
        String[] refParts = refName.split("\\.");
        if (refParts.length == 3 && SNAPSHOT_REF.matcher(refParts[2]).matches()) {
            return (refParts[0] + "." + refParts[1]).toLowerCase() + "." + refParts[2];
        }
        return refName.toLowerCase();
    }

    static class ColumnExprProcessor
    implements SemanticNodeProcessor {
        ColumnExprProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnparseTranslator unparseTranslator = ((QuotedIdExpressionContext)procCtx).getUnparseTranslator();
            ASTNode tokTableOrColNode = (ASTNode)nd;
            for (int i = 0; i < tokTableOrColNode.getChildCount(); ++i) {
                ASTNode child = (ASTNode)tokTableOrColNode.getChild(i);
                if (child.getType() != 24) continue;
                unparseTranslator.addIdentifierTranslation(child);
            }
            return null;
        }
    }

    static class QuotedIdExpressionContext
    implements NodeProcessorCtx {
        private final UnparseTranslator unparseTranslator;

        public QuotedIdExpressionContext(UnparseTranslator unparseTranslator) {
            this.unparseTranslator = unparseTranslator;
        }

        public UnparseTranslator getUnparseTranslator() {
            return this.unparseTranslator;
        }
    }
}

