/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHooks {
    private static final Logger LOG = LoggerFactory.getLogger(HiveHooks.class);
    private final HiveConf conf;
    private final Map<HookContext.HookType, Hooks> typeHooks;
    private SessionState.LogHelper console;

    public HiveHooks(HiveConf conf) {
        this.conf = conf;
        this.typeHooks = new HashMap<HookContext.HookType, Hooks>();
    }

    public HiveHooks(HiveConf conf, SessionState.LogHelper console) {
        this(conf);
        this.console = console;
    }

    @VisibleForTesting
    void loadHooksFromConf(HookContext.HookType type) {
        Hooks hooks = this.typeHooks.get((Object)type);
        if (hooks == null) {
            hooks = new Hooks();
            this.typeHooks.put(type, hooks);
            List hookList = hooks.getHooks();
            HiveConf.ConfVars confVar = type.getConfVar();
            Collection csHooks = this.conf.getStringCollection(confVar.varname);
            try {
                for (String clzName : csHooks) {
                    Class<?> hookCls = Class.forName(clzName.trim(), true, Utilities.getSessionSpecifiedClassLoader());
                    if (type.getHookClass().isAssignableFrom(hookCls)) {
                        Object hookObj = hookCls.newInstance();
                        hookList.add(hookObj);
                        continue;
                    }
                    String message = "The class: " + clzName + " should be the subclass of " + type.getHookClass().getName() + ", as the type: " + type + " defined";
                    this.logErrorMessage(message);
                    throw new ClassCastException(clzName + " cannot be cast to " + type.getHookClass().getName());
                }
            }
            catch (Exception e) {
                String message = "Error loading hooks(" + confVar + "): " + HiveStringUtils.stringifyException((Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
    }

    private void logErrorMessage(String message) {
        if (this.console != null) {
            this.console.printError(message);
        } else {
            LOG.error(message);
        }
    }

    public void addHook(HookContext.HookType type, Object hook) {
        if (!type.getHookClass().isAssignableFrom(hook.getClass())) {
            String message = "Error adding hook: " + hook.getClass().getName() + " into type: " + type + ", as the hook doesn't implement or extend: " + type.getHookClass().getName();
            this.logErrorMessage(message);
            throw new IllegalArgumentException(message);
        }
        this.loadHooksFromConf(type);
        this.typeHooks.get((Object)type).addHook(hook);
    }

    public <T> List<T> getHooks(HookContext.HookType type, Class<T> clazz) {
        if (!type.getHookClass().isAssignableFrom(clazz)) {
            String message = "The arg class: " + clazz.getName() + " should be the same as, or the subclass of " + type.getHookClass().getName() + ", as the type: " + type + " defined";
            this.logErrorMessage(message);
            throw new IllegalArgumentException(message);
        }
        this.loadHooksFromConf(type);
        return this.typeHooks.get((Object)type).getHooks();
    }

    @VisibleForTesting
    List getHooks(HookContext.HookType type, boolean loadFromConf) {
        if (loadFromConf) {
            return this.getHooks(type);
        }
        return this.typeHooks.getOrDefault((Object)type, new Hooks()).getHooks();
    }

    public List getHooks(HookContext.HookType type) {
        return this.getHooks(type, type.getHookClass());
    }

    private class Hooks<T> {
        private List<T> hooks = new ArrayList<T>();

        private Hooks() {
        }

        void addHook(T hook) {
            this.hooks.add(hook);
        }

        List<T> getHooks() {
            return this.hooks;
        }
    }
}

