/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import java.util.stream.IntStream;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.Range;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public abstract class VectorPTFEvaluatorAbstractLeadLag
extends VectorPTFEvaluatorBase {
    protected int amt;
    protected Object defaultValue;
    protected int defaultValueColumn = -1;
    protected ColumnVector.Type type;

    public VectorPTFEvaluatorAbstractLeadLag(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum, ColumnVector.Type type, int amt, VectorExpression defaultValueExpression) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.type = type;
        this.amt = amt;
        this.initDefaultValue(defaultValueExpression);
    }

    private void initDefaultValue(VectorExpression defaultValueExpression) {
        if (defaultValueExpression == null) {
            this.defaultValue = null;
            return;
        }
        if (defaultValueExpression instanceof ConstantVectorExpression) {
            long longValue = ((ConstantVectorExpression)defaultValueExpression).getLongValue();
            switch (this.type) {
                case LONG: {
                    this.defaultValue = longValue;
                    break;
                }
                case DOUBLE: {
                    this.defaultValue = (double)longValue;
                    break;
                }
                case DECIMAL: {
                    this.defaultValue = new HiveDecimalWritable(longValue);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + this.type + " for lag function");
                }
            }
        } else if (defaultValueExpression instanceof IdentityExpression) {
            this.defaultValueColumn = ((IdentityExpression)defaultValueExpression).getOutputColumnNum();
        } else {
            throw new RuntimeException("Unexpected vector expression type for default value in lag function: " + defaultValueExpression.getClass().getName());
        }
    }

    @Override
    public boolean canRunOptimizedCalculation(int rowNum, Range range) {
        return true;
    }

    protected Object getDefaultValue(int rowNum, VectorPTFGroupBatches batches) throws HiveException {
        if (this.defaultValueColumn > -1) {
            return batches.getValue(rowNum, this.defaultValueColumn);
        }
        return this.defaultValue;
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return this.type;
    }

    @Override
    public void resetEvaluator() {
    }

    @Override
    public boolean isCacheableForRange() {
        return false;
    }

    @Override
    public void mapCustomColumns(int[] bufferedColumnMap) {
        if (this.defaultValueColumn > -1) {
            this.defaultValueColumn = IntStream.range(0, bufferedColumnMap.length).filter(j -> bufferedColumnMap[j] == this.defaultValueColumn).findFirst().orElseGet(() -> this.defaultValueColumn);
        }
    }
}

