/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.DirCopyWork;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirCopyTask
extends Task<DirCopyWork>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DirCopyTask.class);
    private static final String CUSTOM_PATH_CONFIG_PREFIX = "hive.dbpath.";

    private boolean createAndSetPathOwner(Path destPath, Path sourcePath, HiveConf clonedConf) throws IOException {
        FileStatus status;
        FileSystem targetFs = destPath.getFileSystem((Configuration)clonedConf);
        boolean createdDir = false;
        if (!targetFs.exists(destPath)) {
            if (!targetFs.mkdirs(destPath)) {
                throw new IOException(ErrorMsg.REPL_FILE_SYSTEM_OPERATION_RETRY.format(destPath + " is not a directory or unable to create one"));
            }
            createdDir = true;
        }
        try {
            status = sourcePath.getFileSystem((Configuration)clonedConf).getFileStatus(sourcePath);
        }
        catch (FileNotFoundException e) {
            LOG.warn("source path missing " + sourcePath);
            return createdDir;
        }
        LOG.info("Setting permission for path dest {} from source {} owner {} : {} : {}", new Object[]{destPath, sourcePath, status.getOwner(), status.getGroup(), status.getPermission()});
        this.preserveDistCpAttributes(destPath, sourcePath, clonedConf, status);
        return createdDir;
    }

    private void preserveDistCpAttributes(Path destPath, Path sourcePath, HiveConf clonedConf, FileStatus status) throws IOException {
        String preserveString = this.getPreserveString(clonedConf);
        LOG.info("Preserving DistCp Attributes: {}", (Object)preserveString);
        FileSystem destFs = destPath.getFileSystem((Configuration)clonedConf);
        if (preserveString.contains("u") && preserveString.contains("g")) {
            destFs.setOwner(destPath, status.getOwner(), status.getGroup());
        } else if (preserveString.contains("u")) {
            destFs.setOwner(destPath, status.getOwner(), null);
        } else if (preserveString.contains("g")) {
            destFs.setOwner(destPath, null, status.getGroup());
        }
        if (preserveString.contains("p")) {
            destFs.setPermission(destPath, status.getPermission());
        }
        if (preserveString.contains("a")) {
            this.setAclsToTarget(status, sourcePath, destPath, clonedConf);
        }
    }

    private void setAclsToTarget(FileStatus sourceStatus, Path sourcePath, Path destPath, HiveConf clonedConf) throws IOException {
        AclStatus sourceAcls = sourcePath.getFileSystem((Configuration)clonedConf).getAclStatus(sourcePath);
        if (sourceAcls != null && sourceAcls.getEntries().size() > 0) {
            destPath.getFileSystem((Configuration)clonedConf).removeAcl(destPath);
            List effectiveAclEntries = AclUtil.getAclFromPermAndEntries((FsPermission)sourceStatus.getPermission(), (List)sourceAcls.getEntries());
            destPath.getFileSystem((Configuration)clonedConf).setAcl(destPath, effectiveAclEntries);
        }
    }

    private String getPreserveString(HiveConf clonedConf) {
        List distCpOptions = HdfsUtils.constructDistCpOptions((Configuration)clonedConf);
        for (String option : distCpOptions) {
            if (!option.startsWith("-p")) continue;
            return option.replaceFirst("-p", "");
        }
        return "";
    }

    private boolean setTargetPathOwner(Path targetPath, Path sourcePath, UserGroupInformation proxyUser, HiveConf clonedConf) throws IOException, InterruptedException {
        if (proxyUser == null) {
            return this.createAndSetPathOwner(targetPath, sourcePath, clonedConf);
        }
        return (Boolean)proxyUser.doAs(() -> this.createAndSetPathOwner(targetPath, sourcePath, clonedConf));
    }

    private boolean checkIfPathExist(Path sourcePath, UserGroupInformation proxyUser, HiveConf clonedConf) throws Exception {
        if (proxyUser == null) {
            return sourcePath.getFileSystem((Configuration)clonedConf).exists(sourcePath);
        }
        return (Boolean)proxyUser.doAs(() -> sourcePath.getFileSystem((Configuration)clonedConf).exists(sourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() {
        int n;
        LOG.info("Started DirCopyTask for table {} from source: {} to target: {}", new Object[]{((DirCopyWork)this.work).getTableName(), ((DirCopyWork)this.work).getFullyQualifiedSourcePath(), ((DirCopyWork)this.work).getFullyQualifiedTargetPath()});
        HiveConf clonedConf = this.getConf(this.conf);
        String distCpDoAsUser = clonedConf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        Retryable retryable = Retryable.builder().withHiveConf(clonedConf).withRetryOnException(IOException.class).withFailOnException(SnapshotException.class).build();
        long startTime = System.currentTimeMillis();
        AtomicInteger retries = new AtomicInteger(-1);
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            n = retryable.executeCallable(() -> {
                Path targetPath;
                Path sourcePath;
                UserGroupInformation proxyUser;
                block11: {
                    Integer n2;
                    block12: {
                        retries.getAndIncrement();
                        proxyUser = null;
                        sourcePath = ((DirCopyWork)this.work).getFullyQualifiedSourcePath();
                        targetPath = ((DirCopyWork)this.work).getFullyQualifiedTargetPath();
                        try {
                            if (clonedConf.getBoolVar(HiveConf.ConfVars.REPL_ADD_RAW_RESERVED_NAMESPACE)) {
                                sourcePath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).getFullyQualifiedSourcePath().toUri());
                                targetPath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).getFullyQualifiedTargetPath().toUri());
                            }
                            UserGroupInformation ugi = Utils.getUGI();
                            String currentUser = ugi.getShortUserName();
                            if (distCpDoAsUser != null && !currentUser.equals(distCpDoAsUser)) {
                                proxyUser = UserGroupInformation.createProxyUser((String)distCpDoAsUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                            }
                            this.setTargetPathOwner(targetPath, sourcePath, proxyUser, clonedConf);
                            try {
                                if (this.checkIfPathExist(sourcePath, proxyUser, clonedConf)) break block11;
                                LOG.info("Source path is missing. Ignoring exception.");
                                n2 = 0;
                                if (proxyUser == null) break block12;
                            }
                            catch (Exception ex) {
                                LOG.warn("Source path missing check failed. ", (Throwable)ex);
                                throw new IOException(ex);
                            }
                        }
                        catch (Throwable throwable) {
                            if (proxyUser != null) {
                                FileSystem.closeAllForUGI(proxyUser);
                            }
                            throw throwable;
                        }
                        FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                    }
                    return n2;
                }
                if (!((DirCopyWork)this.getWork()).getCopyMode().equals((Object)SnapshotUtils.SnapshotCopyMode.FALLBACK_COPY)) {
                    LOG.info("Using Snapshot mode of copy for source: {} and target: {}", (Object)sourcePath, (Object)targetPath);
                    result.set(this.copyUsingDistCpSnapshots(sourcePath, targetPath, proxyUser, clonedConf));
                } else {
                    LOG.info("Using Normal copy for source: {} and target: {}", (Object)sourcePath, (Object)targetPath);
                    result.set(this.runFallbackDistCp(sourcePath, targetPath, proxyUser, clonedConf));
                }
                Integer n = 0;
                if (proxyUser != null) {
                    FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                }
                return n;
            });
        }
        catch (Exception e) {
            int n2;
            try {
                LOG.error("Replication failed ", (Throwable)e);
                SecurityException ex = new SecurityException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
                this.setException(ex);
                n2 = ReplUtils.handleException(true, ex, ((DirCopyWork)this.work).getDumpDirectory(), ((DirCopyWork)this.work).getMetricCollector(), this.getName(), clonedConf);
            }
            catch (Throwable throwable) {
                String jobId = clonedConf.get("distcp.job.id", "UNAVAILABLE");
                LOG.info("DirCopyTask status for source: {} to  target: {}. Took {}. DistCp JobId {}. Number of retries {}. Result: {}", new Object[]{((DirCopyWork)this.work).getFullyQualifiedSourcePath(), ((DirCopyWork)this.work).getFullyQualifiedTargetPath(), ReplUtils.convertToHumanReadableTime(System.currentTimeMillis() - startTime), jobId, retries.get(), result.get() ? "SUCCEEDED" : "FAILED"});
                if (result.get()) {
                    FileSystem srcFs = null;
                    try {
                        srcFs = ((DirCopyWork)this.work).getFullyQualifiedSourcePath().getFileSystem((Configuration)clonedConf);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    ContentSummary summary = null;
                    try {
                        summary = srcFs.getContentSummary(((DirCopyWork)this.work).getFullyQualifiedSourcePath());
                    }
                    catch (IOException e3) {
                        throw new RuntimeException(e3);
                    }
                    long totalBytesCopied = summary.getLength();
                    LOG.debug("DirCopyTask copied {} number of bytes by using distcp", (Object)totalBytesCopied);
                    if (((DirCopyWork)this.work).getMetricCollector() != null) {
                        ((DirCopyWork)this.work).getMetricCollector().incrementSizeOfDataReplicated(totalBytesCopied);
                    }
                }
                throw throwable;
            }
            String jobId = clonedConf.get("distcp.job.id", "UNAVAILABLE");
            LOG.info("DirCopyTask status for source: {} to  target: {}. Took {}. DistCp JobId {}. Number of retries {}. Result: {}", new Object[]{((DirCopyWork)this.work).getFullyQualifiedSourcePath(), ((DirCopyWork)this.work).getFullyQualifiedTargetPath(), ReplUtils.convertToHumanReadableTime(System.currentTimeMillis() - startTime), jobId, retries.get(), result.get() ? "SUCCEEDED" : "FAILED"});
            if (result.get()) {
                FileSystem srcFs = null;
                try {
                    srcFs = ((DirCopyWork)this.work).getFullyQualifiedSourcePath().getFileSystem((Configuration)clonedConf);
                }
                catch (IOException e4) {
                    throw new RuntimeException(e4);
                }
                ContentSummary summary = null;
                try {
                    summary = srcFs.getContentSummary(((DirCopyWork)this.work).getFullyQualifiedSourcePath());
                }
                catch (IOException e5) {
                    throw new RuntimeException(e5);
                }
                long totalBytesCopied = summary.getLength();
                LOG.debug("DirCopyTask copied {} number of bytes by using distcp", (Object)totalBytesCopied);
                if (((DirCopyWork)this.work).getMetricCollector() != null) {
                    ((DirCopyWork)this.work).getMetricCollector().incrementSizeOfDataReplicated(totalBytesCopied);
                }
            }
            return n2;
        }
        String jobId = clonedConf.get("distcp.job.id", "UNAVAILABLE");
        LOG.info("DirCopyTask status for source: {} to  target: {}. Took {}. DistCp JobId {}. Number of retries {}. Result: {}", new Object[]{((DirCopyWork)this.work).getFullyQualifiedSourcePath(), ((DirCopyWork)this.work).getFullyQualifiedTargetPath(), ReplUtils.convertToHumanReadableTime(System.currentTimeMillis() - startTime), jobId, retries.get(), result.get() ? "SUCCEEDED" : "FAILED"});
        if (result.get()) {
            FileSystem srcFs = null;
            try {
                srcFs = ((DirCopyWork)this.work).getFullyQualifiedSourcePath().getFileSystem((Configuration)clonedConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ContentSummary summary = null;
            try {
                summary = srcFs.getContentSummary(((DirCopyWork)this.work).getFullyQualifiedSourcePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            long totalBytesCopied = summary.getLength();
            LOG.debug("DirCopyTask copied {} number of bytes by using distcp", (Object)totalBytesCopied);
            if (((DirCopyWork)this.work).getMetricCollector() != null) {
                ((DirCopyWork)this.work).getMetricCollector().incrementSizeOfDataReplicated(totalBytesCopied);
            }
        }
        return n;
    }

    private HiveConf getConf(HiveConf conf) {
        HiveConf clonedConf = new HiveConf(conf);
        if (((DirCopyWork)this.work).getTableName().startsWith("dbPath:")) {
            for (Map.Entry entry : conf.getPropsWithPrefix(CUSTOM_PATH_CONFIG_PREFIX).entrySet()) {
                clonedConf.set(((String)entry.getKey()).replaceFirst(CUSTOM_PATH_CONFIG_PREFIX, ""), (String)entry.getValue());
            }
        }
        return clonedConf;
    }

    private static Path reservedRawPath(URI uri) {
        return new Path(uri.getScheme(), uri.getAuthority(), "/.reserved/raw/" + uri.getPath());
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    public String getName() {
        return "DIR_COPY_TASK";
    }

    @Override
    public boolean canExecuteInParallel() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean copyUsingDistCpSnapshots(Path sourcePath, Path targetPath, UserGroupInformation proxyUser, HiveConf clonedConf) throws IOException {
        DistributedFileSystem targetFs = SnapshotUtils.getDFS(targetPath, clonedConf);
        boolean result = false;
        if (((DirCopyWork)this.getWork()).getCopyMode().equals((Object)SnapshotUtils.SnapshotCopyMode.DIFF_COPY)) {
            LOG.info("Using snapshot diff copy for source: {} and target: {}", (Object)sourcePath, (Object)targetPath);
            boolean overwriteTarget = clonedConf.getBoolVar(HiveConf.ConfVars.REPL_SNAPSHOT_OVERWRITE_TARGET_FOR_EXTERNAL_TABLE_COPY);
            LOG.debug("Overwrite target in case the target location is modified is turned {}", (Object)(overwriteTarget ? "on" : "off"));
            result = FileUtils.distCpWithSnapshot((String)SnapshotUtils.firstSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()), (String)SnapshotUtils.secondSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()), Collections.singletonList(sourcePath), (Path)targetPath, (boolean)overwriteTarget, (HiveConf)clonedConf, (HadoopShims)ShimLoader.getHadoopShims(), (UserGroupInformation)proxyUser);
            if (!result) throw new SnapshotException("Can not successfully copy external table data using snapshot diff. source: " + sourcePath + " and target: " + targetPath);
            targetFs.deleteSnapshot(targetPath, SnapshotUtils.firstSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()));
        } else if (((DirCopyWork)this.getWork()).getCopyMode().equals((Object)SnapshotUtils.SnapshotCopyMode.INITIAL_COPY)) {
            LOG.info("Using snapshot initial copy for source: {} and target: {}", (Object)sourcePath, (Object)targetPath);
            Path snapRelPath = new Path(sourcePath, ".snapshot/" + SnapshotUtils.secondSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()));
            SnapshotUtils.allowSnapshot(targetFs, ((DirCopyWork)this.work).getFullyQualifiedTargetPath(), clonedConf);
            SnapshotUtils.deleteSnapshotIfExists(targetFs, targetPath, SnapshotUtils.firstSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()), clonedConf);
            result = this.runFallbackDistCp(snapRelPath, targetPath, proxyUser, clonedConf);
        }
        if (!result) return result;
        SnapshotUtils.createSnapshot((FileSystem)targetFs, targetPath, SnapshotUtils.firstSnapshot(((DirCopyWork)this.work).getSnapshotPrefix()), clonedConf);
        return result;
    }

    private boolean runFallbackDistCp(Path sourcePath, Path targetPath, UserGroupInformation proxyUser, HiveConf clonedConf) throws IOException {
        boolean response = FileUtils.distCp((FileSystem)sourcePath.getFileSystem((Configuration)clonedConf), Collections.singletonList(sourcePath), (Path)targetPath, (boolean)false, (UserGroupInformation)proxyUser, (HiveConf)clonedConf, (HadoopShims)ShimLoader.getHadoopShims());
        return response;
    }
}

