/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

class HiveWritableComparator
extends WritableComparator {
    private WritableComparator comparator = null;
    protected final transient boolean nullSafe;
    protected final transient NullOrdering nullOrdering;
    protected final int not_null = 2;

    HiveWritableComparator(boolean nullSafe, NullOrdering nullOrdering) {
        this.nullSafe = nullSafe;
        this.nullOrdering = nullOrdering;
    }

    protected int checkNull(Object key1, Object key2) {
        if (key1 == null && key2 == null) {
            if (this.nullSafe) {
                return 0;
            }
            return -1;
        }
        if (key1 == null) {
            return this.nullOrdering == null ? -1 : this.nullOrdering.getNullValueOption().getCmpReturnValue();
        }
        if (key2 == null) {
            return this.nullOrdering == null ? 1 : -this.nullOrdering.getNullValueOption().getCmpReturnValue();
        }
        return 2;
    }

    public int compare(Object key1, Object key2) {
        int result = this.checkNull(key1, key2);
        if (result != 2) {
            return result;
        }
        if (key1 instanceof DoubleWritable && key2 instanceof DoubleWritable && ((DoubleWritable)key1).get() == 0.0 && ((DoubleWritable)key2).get() == 0.0 || key1 instanceof FloatWritable && key2 instanceof FloatWritable && ((FloatWritable)key1).get() == 0.0f && ((FloatWritable)key2).get() == 0.0f) {
            return 0;
        }
        if (this.comparator == null) {
            this.comparator = WritableComparator.get(((WritableComparable)key1).getClass());
        }
        return this.comparator.compare((WritableComparable)key1, (WritableComparable)key2);
    }
}

