/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.columnstats;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.exec.ColumnStatsUpdateTask;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;

@DDLSemanticAnalyzerFactory.DDLType(types={896, 854})
public class AlterTableUpdateColumnStatistictAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableUpdateColumnStatistictAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        String columnName = AlterTableUpdateColumnStatistictAnalyzer.getUnescapedName((ASTNode)command.getChild(0));
        Map<String, String> properties = AlterTableUpdateColumnStatistictAnalyzer.getProps((ASTNode)command.getChild(1).getChild(0));
        String partitionName = AcidUtils.getPartitionName(partitionSpec);
        String columnType = this.getColumnType(table, columnName);
        ColumnStatsUpdateWork work = new ColumnStatsUpdateWork(partitionName, properties, table.getDbName(), table.getTableName(), columnName, columnType);
        ColumnStatsUpdateTask task = (ColumnStatsUpdateTask)TaskFactory.get(work);
        this.addInputsOutputsAlterTable(tableName, partitionSpec, null, AlterTableType.UPDATESTATS, false);
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(work);
        }
        this.rootTasks.add(task);
    }

    private String getColumnType(Table table, String columnName) throws SemanticException {
        for (FieldSchema column : table.getCols()) {
            if (!columnName.equalsIgnoreCase(column.getName())) continue;
            return column.getType();
        }
        throw new SemanticException("column type not found");
    }
}

