/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.testutils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.CuratorFrameworkSingleton;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.testutils.MiniZooKeeperCluster;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class HiveTestEnvSetup
extends ExternalResource {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + HiveTestEnvSetup.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    public static final String HIVE_ROOT = HiveTestEnvSetup.getHiveRoot();
    public static final String DATA_DIR = HIVE_ROOT + "/data/";
    List<IHiveTestRule> parts = new ArrayList<IHiveTestRule>();
    TemporaryFolder tmpFolderRule = new TemporaryFolder(new File(HIVE_ROOT + "/target/tmp"));
    private HiveTestEnvContext testEnvContext = new HiveTestEnvContext();

    public HiveTestEnvSetup() {
        this.parts.add(new TmpDirSetup());
        this.parts.add(new SetTestEnvs());
        this.parts.add(new SetupHiveConf());
        this.parts.add(new SetupZookeeper());
        this.parts.add(new SetupTez());
    }

    protected void before() throws Throwable {
        for (IHiveTestRule p : this.parts) {
            p.beforeClass(this.testEnvContext);
        }
    }

    protected void after() {
        try {
            for (IHiveTestRule p : Lists.reverse(this.parts)) {
                p.afterClass(this.testEnvContext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("test-subsystem error", e);
        }
    }

    private static String getHiveRoot() {
        ArrayList<String> candidateSiblings = new ArrayList<String>();
        if (System.getProperty("hive.root") != null) {
            try {
                candidateSiblings.add(new File(System.getProperty("hive.root")).getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException("error getting hive.root", e);
            }
        }
        candidateSiblings.add(new File(".").getAbsolutePath());
        for (String string : candidateSiblings) {
            File curr = new File(string);
            do {
                HashSet lls;
                if (!(lls = Sets.newHashSet((Object[])curr.list())).contains("itests") || !lls.contains("ql") || !lls.contains("metastore")) continue;
                System.out.println("detected hiveRoot: " + curr);
                return HiveTestEnvSetup.ensurePathEndsInSlash(curr.getAbsolutePath());
            } while ((curr = curr.getParentFile()) != null);
        }
        throw new RuntimeException("unable to find hiveRoot");
    }

    public static String ensurePathEndsInSlash(String path) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null");
        }
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public File getDir(String string) {
        try {
            return this.tmpFolderRule.newFolder(string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TestRule getMethodRule() {
        return new MethodRuleProxy();
    }

    public HiveTestEnvContext getTestCtx() {
        return this.testEnvContext;
    }

    class MethodRuleProxy
    extends ExternalResource {
        MethodRuleProxy() {
        }

        protected void before() throws Throwable {
            for (IHiveTestRule p : HiveTestEnvSetup.this.parts) {
                p.beforeMethod(HiveTestEnvSetup.this.testEnvContext);
            }
        }

        protected void after() {
            try {
                for (IHiveTestRule p : Lists.reverse(HiveTestEnvSetup.this.parts)) {
                    p.afterMethod(HiveTestEnvSetup.this.testEnvContext);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("test-subsystem error", e);
            }
        }
    }

    static class SetupTez
    implements IHiveTestRule {
        private HadoopShims.MiniMrShim mr1;

        SetupTez() {
        }

        @Override
        public void beforeClass(HiveTestEnvContext ctx) throws Exception {
            HadoopShims shims = ShimLoader.getHadoopShims();
            this.mr1 = shims.getLocalMiniTezCluster((Configuration)ctx.hiveConf, true);
            this.mr1.setupConfiguration((Configuration)ctx.hiveConf);
            this.setupTez(ctx.hiveConf);
        }

        @Override
        public void afterClass(HiveTestEnvContext ctx) throws Exception {
            this.mr1.shutdown();
        }

        private void setupTez(HiveConf conf) {
            conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "tez");
            conf.setVar(HiveConf.ConfVars.HIVE_USER_INSTALL_DIR, TEST_DATA_DIR);
            conf.set("tez.am.resource.memory.mb", "128");
            conf.set("tez.am.dag.scheduler.class", "org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrderControlled");
            conf.setBoolean("tez.local.mode", true);
            conf.set("fs.defaultFS", "file:///");
            conf.setBoolean("tez.runtime.optimize.local.fetch", true);
            conf.set("tez.staging-dir", TEST_DATA_DIR);
            conf.setBoolean("tez.ignore.lib.uris", true);
        }
    }

    static class SetupZookeeper
    implements IHiveTestRule {
        private ZooKeeper zooKeeper;
        private MiniZooKeeperCluster zooKeeperCluster;
        private int zkPort;

        SetupZookeeper() {
        }

        @Override
        public void beforeClass(HiveTestEnvContext ctx) throws Exception {
            File tmpDir = new File(ctx.tmpFolder, "zookeeper");
            this.zooKeeperCluster = new MiniZooKeeperCluster();
            this.zkPort = this.zooKeeperCluster.startup(tmpDir);
        }

        @Override
        public void beforeMethod(HiveTestEnvContext ctx) throws Exception {
            int sessionTimeout = (int)ctx.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
            this.zooKeeper = new ZooKeeper("localhost:" + this.zkPort, sessionTimeout, new Watcher(){

                public void process(WatchedEvent arg0) {
                }
            });
            String zkServer = "localhost";
            ctx.hiveConf.set("hive.zookeeper.quorum", zkServer);
            ctx.hiveConf.set("hive.zookeeper.client.port", "" + this.zkPort);
        }

        @Override
        public void afterMethod(HiveTestEnvContext ctx) throws Exception {
            this.zooKeeper.close();
            ZooKeeperHiveLockManager.releaseAllLocks((HiveConf)ctx.hiveConf);
        }

        @Override
        public void afterClass(HiveTestEnvContext ctx) throws Exception {
            CuratorFrameworkSingleton.closeAndReleaseInstance();
            if (this.zooKeeperCluster != null) {
                this.zooKeeperCluster.shutdown();
                this.zooKeeperCluster = null;
            }
        }
    }

    static class SetupHiveConf
    implements IHiveTestRule {
        private HiveConf savedConf;

        SetupHiveConf() {
        }

        @Override
        public void beforeClass(HiveTestEnvContext ctx) throws Exception {
            File confFolder = new File(ctx.tmpFolder, "conf");
            FileUtils.copyDirectory((File)new File(DATA_DIR + "/conf/"), (File)confFolder);
            FileUtils.copyDirectory((File)new File(DATA_DIR + "/conf/tez"), (File)confFolder);
            HiveConf.setHiveSiteLocation((URL)new File(confFolder, "hive-site.xml").toURI().toURL());
            HiveConf.setHivemetastoreSiteUrl((URL)new File(confFolder, "hivemetastore-site.xml").toURI().toURL());
            ctx.hiveConf = new HiveConf(IDriver.class);
            ctx.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_IDE, true);
        }

        @Override
        public void beforeMethod(HiveTestEnvContext ctx) throws Exception {
            if (this.savedConf == null) {
                this.savedConf = new HiveConf(ctx.hiveConf);
            }
            ctx.hiveConf = new HiveConf(this.savedConf);
        }

        @Override
        public void afterMethod(HiveTestEnvContext ctx) throws Exception {
            ctx.hiveConf = new HiveConf(this.savedConf);
        }

        @Override
        public void afterClass(HiveTestEnvContext ctx) throws Exception {
            this.savedConf = null;
            ctx.hiveConf = null;
        }
    }

    static class SetTestEnvs
    implements IHiveTestRule {
        SetTestEnvs() {
        }

        @Override
        public void beforeClass(HiveTestEnvContext ctx) throws Exception {
            File tmpFolder = ctx.tmpFolder;
            String tmpFolderPath = tmpFolder.getAbsolutePath();
            System.setProperty("build.test.dir", tmpFolderPath);
            System.setProperty("derby.stream.error.file", tmpFolderPath + "/derby.log");
            System.setProperty("hadoop.bin.path", HIVE_ROOT + "/testutils/hadoop");
            System.setProperty("hadoop.log.dir", tmpFolderPath);
            System.setProperty("mapred.job.tracker", "local");
            System.setProperty("log4j.configurationFile", "file://" + tmpFolderPath + "/conf/hive-log4j2.properties");
            System.setProperty("log4j.debug", "true");
            System.setProperty("java.io.tmpdir", tmpFolderPath);
            System.setProperty("test.build.data", tmpFolderPath);
            System.setProperty("test.data.files", DATA_DIR + "/files");
            System.setProperty("test.data.dir", DATA_DIR + "/files");
            System.setProperty("test.tmp.dir", tmpFolderPath);
            System.setProperty("test.tmp.dir.uri", "file://" + tmpFolderPath);
            System.setProperty("test.dfs.mkdir", "-mkdir -p");
            System.setProperty("test.warehouse.dir", tmpFolderPath + "/warehouse");
            System.setProperty("java.net.preferIPv4Stack", "true");
            System.setProperty("test.src.tables", "src");
            System.setProperty("hive.jar.directory", tmpFolderPath);
        }
    }

    static class TmpDirSetup
    implements IHiveTestRule {
        public TemporaryFolder tmpFolderRule = new TemporaryFolder(new File(HIVE_ROOT + "/target/tmp"));

        TmpDirSetup() {
        }

        @Override
        public void beforeClass(HiveTestEnvContext ctx) throws Exception {
            this.tmpFolderRule.create();
            ctx.tmpFolder = this.tmpFolderRule.getRoot();
        }

        @Override
        public void afterClass(HiveTestEnvContext ctx) {
            this.tmpFolderRule.delete();
            ctx.tmpFolder = null;
        }
    }

    public static class HiveTestEnvContext {
        public File tmpFolder;
        public HiveConf hiveConf;
    }

    static interface IHiveTestRule {
        default public void beforeClass(HiveTestEnvContext ctx) throws Exception {
        }

        default public void afterClass(HiveTestEnvContext ctx) throws Exception {
        }

        default public void beforeMethod(HiveTestEnvContext ctx) throws Exception {
        }

        default public void afterMethod(HiveTestEnvContext ctx) throws Exception {
        }
    }
}

