/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hive.ql.util.CloseableThreadLocal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class CloseableThreadLocalTest {
    @Test
    public void testResourcesAreInitiallyNotClosed() {
        CloseableThreadLocal closeableThreadLocal = new CloseableThreadLocal(() -> new AutoCloseableStub(), 1);
        Assert.assertThat((Object)((AutoCloseableStub)closeableThreadLocal.get()).isClosed(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testAfterCallingCloseAllInstancesAreClosed() throws ExecutionException, InterruptedException {
        CloseableThreadLocal closeableThreadLocal = new CloseableThreadLocal(() -> new AutoCloseableStub(), 2);
        AutoCloseableStub asyncInstance = CompletableFuture.supplyAsync(() -> ((CloseableThreadLocal)closeableThreadLocal).get()).get();
        AutoCloseableStub syncInstance = (AutoCloseableStub)closeableThreadLocal.get();
        closeableThreadLocal.close();
        Assert.assertThat((Object)asyncInstance.isClosed(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)syncInstance.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSubsequentGetsInTheSameThreadGivesBackTheSameObject() {
        CloseableThreadLocal closeableThreadLocal = new CloseableThreadLocal(() -> new AutoCloseableStub(), 2);
        AutoCloseableStub ref1 = (AutoCloseableStub)closeableThreadLocal.get();
        AutoCloseableStub ref2 = (AutoCloseableStub)closeableThreadLocal.get();
        Assert.assertThat((Object)ref1, (Matcher)Is.is((Object)ref2));
    }

    @Test
    public void testDifferentThreadsHasDifferentInstancesOfTheResource() throws ExecutionException, InterruptedException {
        CloseableThreadLocal closeableThreadLocal = new CloseableThreadLocal(() -> new AutoCloseableStub(), 2);
        AutoCloseableStub asyncInstance = CompletableFuture.supplyAsync(() -> ((CloseableThreadLocal)closeableThreadLocal).get()).get();
        AutoCloseableStub syncInstance = (AutoCloseableStub)closeableThreadLocal.get();
        Assert.assertThat((Object)asyncInstance, (Matcher)Is.is((Matcher)CoreMatchers.not((Object)syncInstance)));
    }

    private static class AutoCloseableStub
    implements AutoCloseable {
        private boolean closed = false;

        private AutoCloseableStub() {
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }
    }
}

