/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.ql.exec.BoundaryCache;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.LongValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBoundaryCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestBoundaryCache.class);
    private static final LinkedList<List<IntWritable>> TEST_PARTITION = new LinkedList();
    private static final List<Integer> CACHE_SIZES = Lists.newArrayList((Object[])new Integer[]{null, 2, 5, 9, 15});
    private static final List<PTFInvocationSpec.Order> ORDERS = Lists.newArrayList((Object[])new PTFInvocationSpec.Order[]{PTFInvocationSpec.Order.ASC, PTFInvocationSpec.Order.DESC});
    private static final int ORDER_BY_COL = 2;

    @BeforeClass
    public static void setupTests() throws Exception {
        TestBoundaryCache.addRow(TEST_PARTITION, 1, 1, -7);
        TestBoundaryCache.addRow(TEST_PARTITION, 2, 1, -1);
        TestBoundaryCache.addRow(TEST_PARTITION, 3, 1, -1);
        TestBoundaryCache.addRow(TEST_PARTITION, 4, 1, 1);
        TestBoundaryCache.addRow(TEST_PARTITION, 5, 1, 1);
        TestBoundaryCache.addRow(TEST_PARTITION, 6, 1, 1);
        TestBoundaryCache.addRow(TEST_PARTITION, 7, 1, 1);
        TestBoundaryCache.addRow(TEST_PARTITION, 8, 1, 2);
        TestBoundaryCache.addRow(TEST_PARTITION, 9, 1, 2);
        TestBoundaryCache.addRow(TEST_PARTITION, 10, 1, 2);
        TestBoundaryCache.addRow(TEST_PARTITION, 11, 1, 2);
        TestBoundaryCache.addRow(TEST_PARTITION, 12, 1, 3);
        TestBoundaryCache.addRow(TEST_PARTITION, 13, 1, 5);
        TestBoundaryCache.addRow(TEST_PARTITION, 14, 1, 5);
        TestBoundaryCache.addRow(TEST_PARTITION, 15, 1, 5);
        TestBoundaryCache.addRow(TEST_PARTITION, 16, 1, 5);
        TestBoundaryCache.addRow(TEST_PARTITION, 17, 1, 6);
        TestBoundaryCache.addRow(TEST_PARTITION, 18, 1, 6);
        TestBoundaryCache.addRow(TEST_PARTITION, 19, 1, 9);
        TestBoundaryCache.addRow(TEST_PARTITION, 20, 1, null);
        TestBoundaryCache.addRow(TEST_PARTITION, 21, 1, null);
    }

    @Test
    public void testPrecedingUnboundedFollowingUnbounded() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE, WindowingSpec.Direction.FOLLOWING, Integer.MAX_VALUE);
    }

    @Test
    public void testPrecedingUnboundedCurrentRow() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE, WindowingSpec.Direction.CURRENT, 0);
    }

    @Test
    public void testPrecedingUnboundedPreceding2() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE, WindowingSpec.Direction.PRECEDING, 2);
    }

    @Test
    public void testPreceding4Preceding1() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, 4, WindowingSpec.Direction.PRECEDING, 1);
    }

    @Test
    public void testPreceding2CurrentRow() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, 2, WindowingSpec.Direction.CURRENT, 0);
    }

    @Test
    public void testPreceding2Following100() throws Exception {
        this.runTest(WindowingSpec.Direction.PRECEDING, 1, WindowingSpec.Direction.FOLLOWING, 100);
    }

    @Test
    public void testCurrentRowFollowing3() throws Exception {
        this.runTest(WindowingSpec.Direction.CURRENT, 0, WindowingSpec.Direction.FOLLOWING, 3);
    }

    @Test
    public void testCurrentRowFFollowingUnbounded() throws Exception {
        this.runTest(WindowingSpec.Direction.CURRENT, 0, WindowingSpec.Direction.FOLLOWING, Integer.MAX_VALUE);
    }

    @Test
    public void testFollowing2Following4() throws Exception {
        this.runTest(WindowingSpec.Direction.FOLLOWING, 2, WindowingSpec.Direction.FOLLOWING, 4);
    }

    @Test
    public void testFollowing2FollowingUnbounded() throws Exception {
        this.runTest(WindowingSpec.Direction.FOLLOWING, 2, WindowingSpec.Direction.FOLLOWING, Integer.MAX_VALUE);
    }

    private void runTest(WindowingSpec.Direction startDirection, int startAmount, WindowingSpec.Direction endDirection, int endAmount) throws Exception {
        BoundaryDef startBoundary = new BoundaryDef(startDirection, startAmount);
        BoundaryDef endBoundary = new BoundaryDef(endDirection, endAmount);
        AtomicInteger readCounter = new AtomicInteger(0);
        int[] expectedBoundaryStarts = new int[TEST_PARTITION.size()];
        int[] expectedBoundaryEnds = new int[TEST_PARTITION.size()];
        int expectedReadCountWithoutCache = -1;
        for (PTFInvocationSpec.Order order : ORDERS) {
            for (Integer cacheSize : CACHE_SIZES) {
                LOG.info(Thread.currentThread().getStackTrace()[2].getMethodName());
                LOG.info("Cache: " + cacheSize + " order: " + order);
                BoundaryCache cache = cacheSize == null ? null : new BoundaryCache(cacheSize.intValue());
                Pair<PTFPartition, ValueBoundaryScanner> mocks = TestBoundaryCache.setupMocks(TEST_PARTITION, 2, startBoundary, endBoundary, order, cache, readCounter);
                PTFPartition ptfPartition = (PTFPartition)mocks.getLeft();
                ValueBoundaryScanner scanner = (ValueBoundaryScanner)mocks.getRight();
                for (int i = 0; i < TEST_PARTITION.size(); ++i) {
                    scanner.handleCache(i, ptfPartition);
                    int start = scanner.computeStart(i, ptfPartition);
                    int end = scanner.computeEnd(i, ptfPartition) - 1;
                    if (cache == null) {
                        expectedBoundaryStarts[i] = start;
                        expectedBoundaryEnds[i] = end;
                    } else {
                        Assert.assertEquals((long)expectedBoundaryStarts[i], (long)start);
                        Assert.assertEquals((long)expectedBoundaryEnds[i], (long)end);
                    }
                    Integer col0 = Optional.ofNullable(TEST_PARTITION.get(i).get(0)).map(v -> v.get()).orElse(null);
                    Integer col1 = Optional.ofNullable(TEST_PARTITION.get(i).get(1)).map(v -> v.get()).orElse(null);
                    Integer col2 = Optional.ofNullable(TEST_PARTITION.get(i).get(2)).map(v -> v.get()).orElse(null);
                    LOG.info(String.format("%d|\t%d\t%d\t%d\t|%d-%d", i, col0, col1, col2, start, end));
                }
                if (cache == null) {
                    expectedReadCountWithoutCache = readCounter.get();
                } else {
                    Assert.assertTrue((expectedReadCountWithoutCache >= readCounter.get() ? 1 : 0) != 0);
                    if (startAmount != Integer.MAX_VALUE || endAmount != Integer.MAX_VALUE) {
                        Assert.assertTrue((TEST_PARTITION.size() <= readCounter.get() ? 1 : 0) != 0);
                    }
                }
                readCounter.set(0);
            }
        }
    }

    private static Pair<PTFPartition, ValueBoundaryScanner> setupMocks(List<List<IntWritable>> partition, int orderByCol, BoundaryDef start, BoundaryDef end, PTFInvocationSpec.Order order, BoundaryCache cache, AtomicInteger readCounter) throws Exception {
        PTFPartition partitionMock = (PTFPartition)Mockito.mock(PTFPartition.class);
        ((PTFPartition)Mockito.doAnswer(invocationOnMock -> {
            int idx = (Integer)invocationOnMock.getArgument(0, Integer.class);
            return partition.get(idx);
        }).when((Object)partitionMock)).getAt(((Integer)ArgumentMatchers.any(Integer.class)).intValue());
        ((PTFPartition)Mockito.doAnswer(invocationOnMock -> partition.size()).when((Object)partitionMock)).size();
        Mockito.when((Object)partitionMock.getBoundaryCache()).thenReturn((Object)cache);
        OrderExpressionDef orderDef = (OrderExpressionDef)Mockito.mock(OrderExpressionDef.class);
        Mockito.when((Object)orderDef.getOrder()).thenReturn((Object)order);
        LongValueBoundaryScanner scan = new LongValueBoundaryScanner(start, end, orderDef, order == PTFInvocationSpec.Order.ASC);
        ValueBoundaryScanner scannerSpy = (ValueBoundaryScanner)Mockito.spy((Object)scan);
        ((ValueBoundaryScanner)Mockito.doAnswer(invocationOnMock -> {
            readCounter.incrementAndGet();
            List row = (List)invocationOnMock.getArgument(0, List.class);
            return row.get(orderByCol);
        }).when((Object)scannerSpy)).computeValue(ArgumentMatchers.any(Object.class));
        ((ValueBoundaryScanner)Mockito.doAnswer(invocationOnMock -> {
            IntWritable v1 = (IntWritable)invocationOnMock.getArgument(0, IntWritable.class);
            IntWritable v2 = (IntWritable)invocationOnMock.getArgument(1, IntWritable.class);
            return v1 != null && v2 != null ? v1.get() == v2.get() : v1 == null && v2 == null;
        }).when((Object)scannerSpy)).isEqual(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class));
        ((ValueBoundaryScanner)Mockito.doAnswer(invocationOnMock -> {
            IntWritable v1 = (IntWritable)invocationOnMock.getArgument(0, IntWritable.class);
            IntWritable v2 = (IntWritable)invocationOnMock.getArgument(1, IntWritable.class);
            Integer amt = (Integer)invocationOnMock.getArgument(2, Integer.class);
            return v1 != null && v2 != null ? v1.get() - v2.get() > amt : v1 != null || v2 != null;
        }).when((Object)scannerSpy)).isDistanceGreater(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class), ((Integer)ArgumentMatchers.any(Integer.class)).intValue());
        TestBoundaryCache.setOrderOnTestPartitions(order);
        return new ImmutablePair((Object)partitionMock, (Object)scannerSpy);
    }

    private static void addRow(List<List<IntWritable>> partition, Integer col0, Integer col1, Integer col2) {
        partition.add(Lists.newArrayList((Object[])new IntWritable[]{col0 != null ? new IntWritable(col0.intValue()) : null, col1 != null ? new IntWritable(col1.intValue()) : null, col2 != null ? new IntWritable(col2.intValue()) : null}));
    }

    private static void setOrderOnTestPartitions(PTFInvocationSpec.Order order) {
        boolean isAscCurrently;
        LinkedList notNulls = TEST_PARTITION.stream().filter(r -> r.get(2) != null).collect(Collectors.toCollection(LinkedList::new));
        List nulls = TEST_PARTITION.stream().filter(r -> r.get(2) == null).collect(Collectors.toList());
        boolean bl = isAscCurrently = ((IntWritable)((List)notNulls.getFirst()).get(2)).get() < ((IntWritable)((List)notNulls.getLast()).get(2)).get();
        if (PTFInvocationSpec.Order.ASC.equals((Object)order) && !isAscCurrently || PTFInvocationSpec.Order.DESC.equals((Object)order) && isAscCurrently) {
            Collections.reverse(notNulls);
            TEST_PARTITION.clear();
            TEST_PARTITION.addAll(notNulls);
            TEST_PARTITION.addAll(nulls);
        }
    }
}

