/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToPrivilege;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestUDFSplitMapPrivs
extends TestCase {
    private final GenericUDFStringToPrivilege udf = new GenericUDFStringToPrivilege();
    private final Object p0 = new Text("SELECT");
    private final Object p1 = new Text("UPDATE");
    private final Object p2 = new Text("CREATE");
    private final Object p3 = new Text("DROP");
    private final Object p4 = new Text("ALTER");
    private final Object p5 = new Text("INDEX");
    private final Object p6 = new Text("LOCK");
    private final Object p7 = new Text("READ");
    private final Object p8 = new Text("WRITE");
    private final Object p9 = new Text("All");

    @Test
    public void testBinaryStringSplitMapToPrivs() throws HiveException {
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0};
        this.udf.initialize(initArgs);
        GenericUDF.DeferredJavaObject args = new GenericUDF.DeferredJavaObject((Object)new Text("1 0 0 0 0 0 0 0 0 0"));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 0 0 0 0 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 0 0 0 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 1 0 0 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2, this.p3), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 1 1 0 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2, this.p3, this.p4), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 1 1 1 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2, this.p3, this.p4, this.p5), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 1 1 1 1 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 1 1 1 1 1 1 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 0 1 1 1 1 1 1 1 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerify(Arrays.asList(this.p0, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7, this.p8), evalArgs);
    }

    @Test
    public void binaryStringMapingShouldFail() throws HiveException {
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0};
        this.udf.initialize(initArgs);
        GenericUDF.DeferredJavaObject args = new GenericUDF.DeferredJavaObject((Object)new Text("1 0 0 0 0 0 0 0 0 0"));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerifyNotTrue(Arrays.asList(this.p1), evalArgs);
        args = new GenericUDF.DeferredJavaObject((Object)new Text("1 1 0 0 0 0 0 0 0 0"));
        evalArgs = new GenericUDF.DeferredObject[]{args};
        this.runAndVerifyNotTrue(Arrays.asList(this.p0, this.p5), evalArgs);
    }

    private void runAndVerify(List<Object> expResult, GenericUDF.DeferredObject[] evalArgs) throws HiveException {
        ArrayList output = (ArrayList)this.udf.evaluate(evalArgs);
        TestUDFSplitMapPrivs.assertEquals(expResult, (Object)output);
    }

    private void runAndVerifyNotTrue(List<Object> expResult, GenericUDF.DeferredObject[] evalArgs) throws HiveException {
        ArrayList output = (ArrayList)this.udf.evaluate(evalArgs);
        TestUDFSplitMapPrivs.assertNotSame(expResult, (Object)output);
    }
}

