/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFGetSQLSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGenericUDTFGetSQLSchema {
    private static SessionState sessionState;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider");
        sessionState = SessionState.start((HiveConf)conf);
        sessionState.initTxnMgr(conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        SessionState.endStart((SessionState)sessionState);
    }

    @Test
    public void testWithComplexTypes() throws Exception {
        this.invokeUDTFAndTest("select array('val1','val2') c1, named_struct('a',1,'b','2') c2,  array(array(1)) c3, array(named_struct('a',1,'b','2')) c4, map(1,1) c5", new String[]{"c1", "array<string>", "c2", "struct<a:int,b:string>", "c3", "array<array<int>>", "c4", "array<struct<a:int,b:string>>", "c5", "map<int,int>"});
    }

    @Test
    public void testWithSimpleTypes() throws Exception {
        this.invokeUDTFAndTest("select 1 as c1, 'Happy Valentines Day' as c2, 2.2 as c3, cast(2.2 as float) c4, cast(2.2 as double) c5, cast('2019-02-14' as date) c6", new String[]{"c1", "int", "c2", "string", "c3", "decimal(2,1)", "c4", "float", "c5", "double", "c6", "date"});
    }

    @Test
    public void testWithDDL() throws Exception {
        this.invokeUDTFAndTest("show tables", new String[0]);
    }

    private void invokeUDTFAndTest(String query, String[] expected) throws HiveException {
        GenericUDTFGetSQLSchema genericUDTFGetSQLSchema = new GenericUDTFGetSQLSchema();
        ArrayList actual = new ArrayList();
        genericUDTFGetSQLSchema.collector = input -> {
            if (input != null) {
                Object[] udfOutput = (Object[])input;
                actual.add(new String((byte[])udfOutput[0]));
                actual.add(new String((byte[])udfOutput[1]));
            }
        };
        genericUDTFGetSQLSchema.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaStringObjectInspector});
        genericUDTFGetSQLSchema.process(new Object[]{query});
        Assert.assertEquals((long)expected.length, (long)actual.size());
        Assert.assertTrue((String)("Failed for query: " + query + ". Expected: " + Arrays.toString(expected) + ". Actual: " + actual), (boolean)Arrays.equals(expected, actual.toArray()));
    }
}

