/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGenericUDFToUnixTimestamp {
    public static void runAndVerify(GenericUDFToUnixTimeStamp udf, Object arg, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    public static void runAndVerify(GenericUDFToUnixTimeStamp udf, Object arg1, Object arg2, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1), new GenericUDF.DeferredJavaObject(arg2)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    @Test
    public void testTimestamp() throws HiveException {
        GenericUDFToUnixTimeStamp udf = new GenericUDFToUnixTimeStamp();
        WritableTimestampObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        MapredContext mockContext = (MapredContext)Mockito.mock(MapredContext.class);
        Mockito.when((Object)mockContext.getJobConf()).thenReturn((Object)new JobConf((Configuration)new HiveConf()));
        udf.configure(mockContext);
        udf.initialize(arguments);
        Timestamp ts = Timestamp.valueOf((String)"1970-01-01 00:00:00");
        TimestampTZ tstz = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new TimestampWritableV2(ts), new LongWritable(tstz.getEpochSecond()));
        ts = Timestamp.valueOf((String)"2001-02-03 01:02:03");
        tstz = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new TimestampWritableV2(ts), new LongWritable(tstz.getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, null, null);
    }

    @Test
    public void testDate() throws HiveException {
        GenericUDFToUnixTimeStamp udf = new GenericUDFToUnixTimeStamp();
        WritableDateObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        MapredContext mockContext = (MapredContext)Mockito.mock(MapredContext.class);
        Mockito.when((Object)mockContext.getJobConf()).thenReturn((Object)new JobConf((Configuration)new HiveConf()));
        udf.configure(mockContext);
        udf.initialize(arguments);
        Date date = Date.valueOf((String)"1970-01-01");
        TimestampTZ tstz = TimestampTZUtil.convert((Date)date, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, new DateWritableV2(date), new LongWritable(tstz.getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf, null, null);
    }

    @Test
    public void testString() throws HiveException {
        GenericUDFToUnixTimeStamp udf1 = new GenericUDFToUnixTimeStamp();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        MapredContext mockContext = (MapredContext)Mockito.mock(MapredContext.class);
        Mockito.when((Object)mockContext.getJobConf()).thenReturn((Object)new JobConf((Configuration)new HiveConf()));
        udf1.configure(mockContext);
        udf1.initialize(arguments);
        String val = "2001-01-01 01:02:03";
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, new Text(val), new LongWritable(TimestampTZUtil.parse((String)val, (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf1, null, null);
        GenericUDFToUnixTimeStamp udf2 = new GenericUDFToUnixTimeStamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf2.configure(mockContext);
        udf2.initialize(args2);
        val = "2001-01-01";
        String format = "yyyy-MM-dd";
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text(val), new Text(format), new LongWritable(TimestampTZUtil.parse((String)val, (ZoneId)ZoneId.systemDefault()).getEpochSecond()));
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, null, null, null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, null, new Text(format), null);
        TestGenericUDFToUnixTimestamp.runAndVerify(udf2, new Text(val), null, null);
    }
}

