/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSurrogateKey;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.tez.runtime.api.ProcessorContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestGenericUDFSurrogateKey {
    private GenericUDFSurrogateKey udf;
    private TezContext mockTezContext;
    private ProcessorContext mockProcessorContest;
    private ObjectInspector[] emptyArguments = new ObjectInspector[0];
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void init() {
        this.udf = new GenericUDFSurrogateKey();
        this.mockTezContext = (TezContext)Mockito.mock(TezContext.class);
        this.mockProcessorContest = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        Mockito.when((Object)this.mockTezContext.getTezProcessorContext()).thenReturn((Object)this.mockProcessorContest);
    }

    @Test
    public void testSurrogateKeyDefault() throws HiveException {
        Mockito.when((Object)this.mockProcessorContest.getTaskIndex()).thenReturn((Object)1);
        this.udf.initialize(this.emptyArguments);
        this.udf.configure((MapredContext)this.mockTezContext);
        this.udf.setWriteId(1L);
        this.runAndVerifyConst(0x10001000000L, this.udf);
        this.runAndVerifyConst(0x10001000001L, this.udf);
        this.runAndVerifyConst(0x10001000002L, this.udf);
    }

    @Test
    public void testSurrogateKeyBitsSet() throws HiveException {
        Mockito.when((Object)this.mockProcessorContest.getTaskIndex()).thenReturn((Object)1);
        this.udf.initialize(this.getArguments(10, 10));
        this.udf.configure((MapredContext)this.mockTezContext);
        this.udf.setWriteId(1L);
        this.runAndVerifyConst(0x40100000000000L, this.udf);
        this.runAndVerifyConst(0x40100000000001L, this.udf);
        this.runAndVerifyConst(18031990695526402L, this.udf);
    }

    @Test
    public void testIllegalNumberOfArgs() throws HiveException {
        this.expectedException.expect(UDFArgumentLengthException.class);
        this.expectedException.expectMessage("The function SURROGATE_KEY takes 0 or 2 integer arguments (write id bits, taks id bits), but found 1");
        ConstantObjectInspector argument0 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(10));
        ObjectInspector[] arguments = new ObjectInspector[]{argument0};
        this.udf.initialize(arguments);
    }

    @Test
    public void testWriteIdBitsOutOfRange() throws HiveException {
        this.expectedException.expect(UDFArgumentException.class);
        this.expectedException.expectMessage("Write ID bits must be between 1 and 62 (value: 63)");
        this.udf.initialize(this.getArguments(63, 10));
    }

    @Test
    public void testTaskIdBitsOutOfRange() throws HiveException {
        this.expectedException.expect(UDFArgumentException.class);
        this.expectedException.expectMessage("Task ID bits must be between 1 and 62 (value: 0)");
        this.udf.initialize(this.getArguments(10, 0));
    }

    @Test
    public void testBitSumOutOfRange() throws HiveException {
        this.expectedException.expect(UDFArgumentException.class);
        this.expectedException.expectMessage("Write ID bits + Task ID bits must be less than 63 (value: 80)");
        this.udf.initialize(this.getArguments(40, 40));
    }

    @Test
    public void testNotTezContext() throws HiveException {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("surrogate_key function is only supported if the execution engine is Tez");
        MapredContext mockContext = (MapredContext)Mockito.mock(MapredContext.class);
        this.udf.initialize(this.emptyArguments);
        this.udf.configure(mockContext);
    }

    @Test
    public void testNoWriteId() throws HiveException {
        this.expectedException.expect(HiveException.class);
        this.expectedException.expectMessage("Could not obtain Write ID for the surrogate_key function");
        Mockito.when((Object)this.mockProcessorContest.getTaskIndex()).thenReturn((Object)1);
        this.udf.initialize(this.emptyArguments);
        this.udf.configure((MapredContext)this.mockTezContext);
        this.runAndVerifyConst(0L, this.udf);
    }

    @Test
    public void testWriteIdOverLimit() throws HiveException {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Write ID is out of range (10 bits) in surrogate_key");
        this.udf.initialize(this.getArguments(10, 10));
        this.udf.setWriteId(1024L);
    }

    @Test
    public void testTaskIdOverLimit() throws HiveException {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Task ID is out of range (10 bits) in surrogate_key");
        Mockito.when((Object)this.mockProcessorContest.getTaskIndex()).thenReturn((Object)1024);
        this.udf.initialize(this.getArguments(10, 10));
        this.udf.configure((MapredContext)this.mockTezContext);
    }

    @Test
    public void testRowIdOverLimit() throws HiveException {
        this.expectedException.expect(HiveException.class);
        this.expectedException.expectMessage("Row ID is out of range (1 bits) in surrogate_key");
        Mockito.when((Object)this.mockProcessorContest.getTaskIndex()).thenReturn((Object)1);
        this.udf.initialize(this.getArguments(32, 31));
        this.udf.configure((MapredContext)this.mockTezContext);
        this.udf.setWriteId(1L);
        this.runAndVerifyConst(0x100000002L, this.udf);
        this.runAndVerifyConst(0x100000003L, this.udf);
        this.runAndVerifyConst(0x100000004L, this.udf);
    }

    private ObjectInspector[] getArguments(int writeIdBits, int taskIdBits) {
        ConstantObjectInspector argument0 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(writeIdBits));
        ConstantObjectInspector argument1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(taskIdBits));
        ObjectInspector[] arguments = new ObjectInspector[]{argument0, argument1};
        return arguments;
    }

    private void runAndVerifyConst(long expResult, GenericUDFSurrogateKey udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{};
        LongWritable output = (LongWritable)udf.evaluate(args);
        Assert.assertEquals((String)"surrogate_key() test ", (long)expResult, (long)output.get());
    }

    @After
    public void close() throws IOException {
        this.udf.close();
    }
}

