/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSubstringIndex;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFSubstringIndex {
    @Test
    public void testSubstringIndex() throws HiveException {
        GenericUDFSubstringIndex udf = new GenericUDFSubstringIndex();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerify("www.apache.org", ".", 3, "www.apache.org", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", 2, "www.apache", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", 1, "www", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", 0, "", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", -1, "org", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", -2, "apache.org", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", -3, "www.apache.org", (GenericUDF)udf);
        this.runAndVerify("", ".", 1, "", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", "", 1, "", (GenericUDF)udf);
        this.runAndVerify("www.apache.org", "-", 2, "www.apache.org", (GenericUDF)udf);
        this.runAndVerify("www||apache||org", "||", 2, "www||apache", (GenericUDF)udf);
        this.runAndVerify(null, ".", 2, null, (GenericUDF)udf);
        this.runAndVerify("www.apache.org", null, 2, null, (GenericUDF)udf);
        this.runAndVerify("www.apache.org", ".", null, null, (GenericUDF)udf);
    }

    @Test
    public void testSubstringIndexConst() throws HiveException {
        GenericUDFSubstringIndex udf = new GenericUDFSubstringIndex();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text delim = new Text(".");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)delim);
        IntWritable count = new IntWritable(2);
        ConstantObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)count);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runAndVerifyConst("www.apache.org", "www.apache", (GenericUDF)udf);
    }

    private void runAndVerify(String str, String delim, Integer count, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject(delim != null ? new Text(delim) : delim);
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)(count != null ? new IntWritable(count.intValue()) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1, valueObj2};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"substring_index() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }

    private void runAndVerifyConst(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"substring_index() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }
}

