/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSoundex;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFSoundex {
    @Test
    public void testSoundex() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerify("Miller", "M460", (GenericUDF)udf);
        this.runAndVerify("miler", "M460", (GenericUDF)udf);
        this.runAndVerify("myller", "M460", (GenericUDF)udf);
        this.runAndVerify("muller", "M460", (GenericUDF)udf);
        this.runAndVerify("m", "M000", (GenericUDF)udf);
        this.runAndVerify("mu", "M000", (GenericUDF)udf);
        this.runAndVerify("mil", "M400", (GenericUDF)udf);
        this.runAndVerify("Peterson", "P362", (GenericUDF)udf);
        this.runAndVerify("Pittersen", "P362", (GenericUDF)udf);
        this.runAndVerify("", "", (GenericUDF)udf);
        this.runAndVerify(null, null, (GenericUDF)udf);
        this.runAndVerify("\u3500\u3501\u3502\u3503", null, (GenericUDF)udf);
    }

    @Test
    public void testSoundexWrongType0() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableIntObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"soundex test. UDFArgumentTypeException is expected", (boolean)false);
        }
        catch (UDFArgumentTypeException e) {
            Assert.assertEquals((String)"soundex test", (Object)"soundex only takes STRING_GROUP types as 1st argument, got INT", (Object)e.getMessage());
        }
    }

    @Test
    public void testSoundexWrongLength() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableHiveVarcharObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        WritableHiveVarcharObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"soundex test. UDFArgumentLengthException is expected", (boolean)false);
        }
        catch (UDFArgumentLengthException e) {
            Assert.assertEquals((String)"soundex test", (Object)"soundex requires 1 argument, got 2", (Object)e.getMessage());
        }
    }

    private void runAndVerify(String str0, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str0 != null ? new Text(str0) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        Text output = (Text)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((String)"soundex test ", (Object)output);
        } else {
            Assert.assertNotNull((String)"soundex test", (Object)output);
            Assert.assertEquals((String)"soundex test", (Object)expResult, (Object)output.toString());
        }
    }
}

