/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFQuarter;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFQuarter {
    @Test
    public void testQuarterStr() throws HiveException {
        GenericUDFQuarter udf = new GenericUDFQuarter();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerifyStr("2014-01-10", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-02-10", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-03-31", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-04-02", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2014-05-28", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2016-06-03", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2016-07-28", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-08-29", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-09-29", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-10-29", 4, (GenericUDF)udf);
        this.runAndVerifyStr("2016-11-29", 4, (GenericUDF)udf);
        this.runAndVerifyStr("2016-12-29", 4, (GenericUDF)udf);
        this.runAndVerifyStr("1966-01-01", 1, (GenericUDF)udf);
        this.runAndVerifyStr("1966-03-31", 1, (GenericUDF)udf);
        this.runAndVerifyStr("1966-04-01", 2, (GenericUDF)udf);
        this.runAndVerifyStr("1966-12-31", 4, (GenericUDF)udf);
        this.runAndVerifyStr("2014-01-01 00:00:00", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-02-10 15:23:00", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-03-31 15:23:00", 1, (GenericUDF)udf);
        this.runAndVerifyStr("2014-04-02 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2014-05-28 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2016-06-03 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2016-07-28 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-08-29 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-09-29 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyStr("2016-10-29 15:23:00", 4, (GenericUDF)udf);
        this.runAndVerifyStr("2016-11-29 15:23:00", 4, (GenericUDF)udf);
        this.runAndVerifyStr("2016-12-31 23:59:59.999", 4, (GenericUDF)udf);
        this.runAndVerifyStr("1966-01-01 00:00:00", 1, (GenericUDF)udf);
        this.runAndVerifyStr("1966-03-31 23:59:59.999", 1, (GenericUDF)udf);
        this.runAndVerifyStr("1966-04-01 00:00:00", 2, (GenericUDF)udf);
        this.runAndVerifyStr("1966-12-31 23:59:59.999", 4, (GenericUDF)udf);
    }

    @Test
    public void testWrongDateStr() throws HiveException {
        GenericUDFQuarter udf = new GenericUDFQuarter();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerifyStr("2016-03-35", 2, (GenericUDF)udf);
        this.runAndVerifyStr("2014-01-32", 1, (GenericUDF)udf);
        this.runAndVerifyStr("01/14/2014", null, (GenericUDF)udf);
        this.runAndVerifyStr(null, null, (GenericUDF)udf);
    }

    @Test
    public void testQuarterDt() throws HiveException {
        GenericUDFQuarter udf = new GenericUDFQuarter();
        WritableDateObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerifyDt("2014-01-01", 1, (GenericUDF)udf);
        this.runAndVerifyDt("2014-02-10", 1, (GenericUDF)udf);
        this.runAndVerifyDt("2014-03-31", 1, (GenericUDF)udf);
        this.runAndVerifyDt("2014-04-02", 2, (GenericUDF)udf);
        this.runAndVerifyDt("2014-05-28", 2, (GenericUDF)udf);
        this.runAndVerifyDt("2016-06-03", 2, (GenericUDF)udf);
        this.runAndVerifyDt("2016-07-28", 3, (GenericUDF)udf);
        this.runAndVerifyDt("2016-08-29", 3, (GenericUDF)udf);
        this.runAndVerifyDt("2016-09-29", 3, (GenericUDF)udf);
        this.runAndVerifyDt("2016-10-29", 4, (GenericUDF)udf);
        this.runAndVerifyDt("2016-11-29", 4, (GenericUDF)udf);
        this.runAndVerifyDt("2016-12-31", 4, (GenericUDF)udf);
        this.runAndVerifyDt("1966-01-01", 1, (GenericUDF)udf);
        this.runAndVerifyDt("1966-03-31", 1, (GenericUDF)udf);
        this.runAndVerifyDt("1966-04-01", 2, (GenericUDF)udf);
        this.runAndVerifyDt("1966-12-31", 4, (GenericUDF)udf);
    }

    @Test
    public void testQuarterTs() throws HiveException {
        GenericUDFQuarter udf = new GenericUDFQuarter();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerifyTs("2014-01-01 00:00:00", 1, (GenericUDF)udf);
        this.runAndVerifyTs("2014-02-10 15:23:00", 1, (GenericUDF)udf);
        this.runAndVerifyTs("2014-03-31 15:23:00", 1, (GenericUDF)udf);
        this.runAndVerifyTs("2014-04-02 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyTs("2014-05-28 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyTs("2016-06-03 15:23:00", 2, (GenericUDF)udf);
        this.runAndVerifyTs("2016-07-28 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyTs("2016-08-29 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyTs("2016-09-29 15:23:00", 3, (GenericUDF)udf);
        this.runAndVerifyTs("2016-10-29 15:23:00", 4, (GenericUDF)udf);
        this.runAndVerifyTs("2016-11-29 15:23:00", 4, (GenericUDF)udf);
        this.runAndVerifyTs("2016-12-31 23:59:59.999", 4, (GenericUDF)udf);
        this.runAndVerifyTs("1966-01-01 00:00:00", 1, (GenericUDF)udf);
        this.runAndVerifyTs("1966-03-31 23:59:59", 1, (GenericUDF)udf);
        this.runAndVerifyTs("1966-04-01 00:00:00", 2, (GenericUDF)udf);
        this.runAndVerifyTs("1966-12-31 23:59:59.999", 4, (GenericUDF)udf);
    }

    private void runAndVerifyStr(String str, Integer expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        IntWritable output = (IntWritable)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((Object)output);
        } else {
            Assert.assertNotNull((Object)output);
            Assert.assertEquals((String)"quarter() test ", (long)expResult.intValue(), (long)output.get());
        }
    }

    private void runAndVerifyDt(String str, Integer expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new DateWritableV2(Date.valueOf((String)str)) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        IntWritable output = (IntWritable)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((Object)output);
        } else {
            Assert.assertNotNull((Object)output);
            Assert.assertEquals((String)"quarter() test ", (long)expResult.intValue(), (long)output.get());
        }
    }

    private void runAndVerifyTs(String str, Integer expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new TimestampWritableV2(Timestamp.valueOf((String)str)) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        IntWritable output = (IntWritable)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((Object)output);
        } else {
            Assert.assertNotNull((Object)output);
            Assert.assertEquals((String)"quarter() test ", (long)expResult.intValue(), (long)output.get());
        }
    }
}

