/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPPositive {
    private static final double EPSILON = 1.0E-6;

    @Test
    public void testByte() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        ByteWritable input = new ByteWritable(4);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.byteTypeInfo, (Object)oi.getTypeInfo());
        ByteWritable res = (ByteWritable)udf.evaluate(args);
        Assert.assertEquals((long)4L, (long)res.get());
    }

    @Test
    public void testShort() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        ShortWritable input = new ShortWritable(74);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.shortTypeInfo, (Object)oi.getTypeInfo());
        ShortWritable res = (ShortWritable)udf.evaluate(args);
        Assert.assertEquals((long)74L, (long)res.get());
    }

    @Test
    public void testInt() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        IntWritable input = new IntWritable(747);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intTypeInfo, (Object)oi.getTypeInfo());
        IntWritable res = (IntWritable)udf.evaluate(args);
        Assert.assertEquals((long)747L, (long)res.get());
    }

    @Test
    public void testLong() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        LongWritable input = new LongWritable(3234747L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.longTypeInfo, (Object)oi.getTypeInfo());
        LongWritable res = (LongWritable)udf.evaluate(args);
        Assert.assertEquals((long)3234747L, (long)res.get());
    }

    @Test
    public void testFloat() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        FloatWritable input = new FloatWritable(323.4747f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.floatTypeInfo, (Object)oi.getTypeInfo());
        FloatWritable res = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((double)323.4747, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDouble() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        DoubleWritable input = new DoubleWritable(32300.004747);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)32300.004747, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDecimal() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        HiveDecimalWritable input = new HiveDecimalWritable(HiveDecimal.create((String)"32300.004747"));
        DecimalTypeInfo inputTypeInfo = TypeInfoFactory.getDecimalTypeInfo((int)11, (int)6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)inputTypeInfo)};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)inputTypeInfo, (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"32300.004747"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testString() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        Text input = new Text("32300.004747");
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)32300.004747, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testVarchar() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        HiveVarchar vc = new HiveVarchar("32300.004747", 12);
        HiveVarcharWritable input = new HiveVarcharWritable(vc);
        VarcharTypeInfo inputTypeInfo = TypeInfoFactory.getVarcharTypeInfo((int)12);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)inputTypeInfo)};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)32300.004747, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testChar() throws HiveException {
        GenericUDFOPPositive udf = new GenericUDFOPPositive();
        HiveChar vc = new HiveChar("32300.004747", 12);
        HiveCharWritable input = new HiveCharWritable(vc);
        CharTypeInfo inputTypeInfo = TypeInfoFactory.getCharTypeInfo((int)12);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)inputTypeInfo)};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)32300.004747, (double)res.get(), (double)1.0E-6);
    }
}

