/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPOr {
    @Test
    public void testTrueOrTrue() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        BooleanWritable left = new BooleanWritable(true);
        BooleanWritable right = new BooleanWritable(true);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableBooleanObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals((Object)true, (Object)res.get());
        udf.close();
    }

    @Test
    public void testTrueOrFalse() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        BooleanWritable left = new BooleanWritable(true);
        BooleanWritable right = new BooleanWritable(false);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableBooleanObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals((Object)true, (Object)res.get());
        udf.close();
    }

    @Test
    public void testFalseOrFalse() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        BooleanWritable left = new BooleanWritable(false);
        BooleanWritable right = new BooleanWritable(false);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableBooleanObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals((Object)false, (Object)res.get());
        udf.close();
    }

    @Test
    public void testTrueOrNull() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        BooleanWritable left = new BooleanWritable(true);
        Object right = null;
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableVoidObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject(right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals((Object)true, (Object)res.get());
        udf.close();
    }

    @Test
    public void testFalseOrNull() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        BooleanWritable left = new BooleanWritable(false);
        Object right = null;
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, PrimitiveObjectInspectorFactory.writableVoidObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject(right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals(null, (Object)res);
        udf.close();
    }

    @Test
    public void testNullOrNull() throws HiveException, IOException {
        GenericUDFOPOr udf = new GenericUDFOPOr();
        Object left = null;
        Object right = null;
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableVoidObjectInspector, PrimitiveObjectInspectorFactory.writableVoidObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(left), new GenericUDF.DeferredJavaObject(right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.booleanTypeInfo);
        BooleanWritable res = (BooleanWritable)udf.evaluate(args);
        Assert.assertEquals(null, (Object)res);
        udf.close();
    }
}

