/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTestGenericUDFOPNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPMultiply
extends AbstractTestGenericUDFOPNumeric {
    private static final double EPSILON = 1.0E-6;

    @Test
    public void testByteTimesShort() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        ByteWritable left = new ByteWritable(4);
        ShortWritable right = new ShortWritable(6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.shortTypeInfo);
        ShortWritable res = (ShortWritable)udf.evaluate(args);
        Assert.assertEquals((long)24L, (long)res.get());
    }

    @Test
    public void testVarcharTimesInt() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("123");
        IntWritable right = new IntWritable(456);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)56088.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDoubleTimesLong() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(10L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)45.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLongTimesDecimal() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        LongWritable left = new LongWritable(104L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)29, (int)4), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"24436.88"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testFloatTimesFloat() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(0.0f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.floatTypeInfo);
        FloatWritable res = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDouleTimesDecimal() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        DoubleWritable left = new DoubleWritable(74.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)17509.9644, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDecimalTimesDecimal() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)3), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"3407.065"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalTimesDecimalSameParams() throws HiveException {
        GenericUDFOPMultiply udf = new GenericUDFOPMultiply();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)11, (int)4), (Object)oi.getTypeInfo());
    }

    @Test
    public void testReturnTypeBackwardCompat() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "0.12");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "decimal(10,2)", "decimal(21,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "decimal(10,2)", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(10,2)", "decimal(10,2)", "decimal(21,4)");
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
    }

    @Test
    public void testReturnTypeAnsiSql() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "int", "decimal(10,2)", "decimal(21,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "float", "decimal(10,2)", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(10,2)", "decimal(10,2)", "decimal(21,4)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(38,18)", "decimal(38,18)", "decimal(38,6)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(38,38)", "decimal(38,38)", "decimal(38,37)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(38,0)", "decimal(38,0)", "decimal(38,0)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(38,38)", "decimal(38,0)", "decimal(38,6)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPMultiply(), "decimal(20,2)", "decimal(20,0)", "decimal(38,2)");
    }
}

