/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericUDFMacro {
    private String name;
    private GenericUDFMacro udf;
    private List<String> colNames;
    private List<TypeInfo> colTypes;
    private ObjectInspector[] inspectors;
    private GenericUDF.DeferredObject[] arguments;
    private IntWritable x;
    private IntWritable y;
    private ExprNodeConstantDesc bodyDesc;
    private int expected;

    @Before
    public void setup() throws Exception {
        this.name = "fixed_number";
        this.colNames = new ArrayList<String>();
        this.colTypes = new ArrayList<TypeInfo>();
        this.colNames.add("x");
        this.colTypes.add((TypeInfo)TypeInfoFactory.intTypeInfo);
        this.colNames.add("y");
        this.colTypes.add((TypeInfo)TypeInfoFactory.intTypeInfo);
        this.x = new IntWritable(1);
        this.y = new IntWritable(2);
        this.expected = this.x.get() + this.y.get();
        this.bodyDesc = new ExprNodeConstantDesc((Object)this.expected);
        this.inspectors = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)this.x), PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)this.y)};
        this.arguments = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)this.x), new GenericUDF.DeferredJavaObject((Object)this.y)};
    }

    @Test
    public void testUDF() throws Exception {
        this.udf = new GenericUDFMacro(this.name, (ExprNodeDesc)this.bodyDesc, this.colNames, this.colTypes);
        this.udf.initialize(this.inspectors);
        Object actual = this.udf.evaluate(this.arguments);
        Assert.assertEquals((Object)this.bodyDesc.getValue(), (Object)((IntWritable)actual).get());
        Assert.assertTrue((boolean)this.udf.isDeterministic());
        Assert.assertFalse((boolean)this.udf.isStateful());
        Assert.assertEquals((Object)this.name, (Object)this.udf.getMacroName());
        Assert.assertEquals((Object)this.bodyDesc, (Object)this.udf.getBody());
        Assert.assertEquals(this.colNames, (Object)this.udf.getColNames());
        Assert.assertEquals(this.colTypes, (Object)this.udf.getColTypes());
        Assert.assertEquals((Object)(this.name + "(x, y)"), (Object)this.udf.getDisplayString(new String[]{"x", "y"}));
    }

    @Test
    public void testNoArgsContructor() throws Exception {
        this.udf = new GenericUDFMacro();
        Assert.assertTrue((boolean)this.udf.isDeterministic());
        Assert.assertFalse((boolean)this.udf.isStateful());
    }
}

