/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLevenshtein;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFLevenshtein {
    @Test
    public void testLevenshtein() throws HiveException {
        GenericUDFLevenshtein udf = new GenericUDFLevenshtein();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("kitten", "sitting", 3, (GenericUDF)udf);
        this.runAndVerify("Test String1", "Test String2", 1, (GenericUDF)udf);
        this.runAndVerify("Test String1", "test String2", 2, (GenericUDF)udf);
        this.runAndVerify("Test String1", "", 12, (GenericUDF)udf);
        this.runAndVerify("", "Test String2", 12, (GenericUDF)udf);
        this.runAndVerify(null, "sitting", null, (GenericUDF)udf);
        this.runAndVerify("kitten", null, null, (GenericUDF)udf);
        this.runAndVerify(null, null, null, (GenericUDF)udf);
    }

    @Test
    public void testLevenshteinWrongType0() throws HiveException {
        GenericUDFLevenshtein udf = new GenericUDFLevenshtein();
        WritableIntObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"levenshtein test. UDFArgumentTypeException is expected", (boolean)false);
        }
        catch (UDFArgumentTypeException e) {
            Assert.assertEquals((String)"levenshtein test", (Object)"levenshtein only takes STRING_GROUP, VOID_GROUP types as 1st argument, got INT", (Object)e.getMessage());
        }
    }

    @Test
    public void testLevenshteinWrongType1() throws HiveException {
        GenericUDFLevenshtein udf = new GenericUDFLevenshtein();
        WritableHiveVarcharObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        WritableFloatObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"levenshtein test. UDFArgumentTypeException is expected", (boolean)false);
        }
        catch (UDFArgumentTypeException e) {
            Assert.assertEquals((String)"levenshtein test", (Object)"levenshtein only takes STRING_GROUP, VOID_GROUP types as 2nd argument, got FLOAT", (Object)e.getMessage());
        }
    }

    @Test
    public void testLevenshteinWrongLength() throws HiveException {
        GenericUDFLevenshtein udf = new GenericUDFLevenshtein();
        WritableHiveVarcharObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"levenshtein test. UDFArgumentLengthException is expected", (boolean)false);
        }
        catch (UDFArgumentLengthException e) {
            Assert.assertEquals((String)"levenshtein test", (Object)"levenshtein requires 2 argument(s), got 1", (Object)e.getMessage());
        }
    }

    private void runAndVerify(String str0, String str1, Integer expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str0 != null ? new Text(str0) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)(str1 != null ? new Text(str1) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        IntWritable output = (IntWritable)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((String)"levenshtein test ", (Object)output);
        } else {
            Assert.assertNotNull((String)"levenshtein test", (Object)output);
            Assert.assertEquals((String)"levenshtein test", (long)expResult.intValue(), (long)output.get());
        }
    }
}

