/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.errors.DataConstraintViolationError;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEnforceConstraint;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFEnforceConstraint {
    @Test
    public void testNull() throws HiveException {
        try {
            GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
            WritableBooleanObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
            udf.initialize(arguments);
            BooleanWritable input = new BooleanWritable(false);
            GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
            udf.evaluate(args);
            Assert.fail((String)"Unreachable line");
        }
        catch (DataConstraintViolationError e) {
            Assert.assertTrue((boolean)e.getMessage().contains("NOT NULL constraint violated!"));
        }
    }

    @Test
    public void testInvalidArgumentsLength() throws HiveException {
        try {
            GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
            WritableBooleanObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            WritableBooleanObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
            udf.initialize(arguments);
            Assert.fail((String)"Unreachable line");
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid number of arguments"));
        }
    }

    @Test
    public void testCorrect() throws HiveException {
        GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
        WritableBooleanObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        BooleanWritable input = new BooleanWritable(true);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        BooleanWritable writable = (BooleanWritable)udf.evaluate(args);
        Assert.assertTrue((String)("Not expected result: expected [true] actual  [ " + writable.get() + " ]"), (boolean)writable.get());
    }
}

