/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.ParseException;
import java.time.LocalDateTime;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFDateDiff {
    @Test
    public void testStringToDateISOFormat() throws HiveException, ParseException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new Text("2019-09-09T10:45:49+02:00"));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new Text("2019-11-07 23:20:39.503"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        Assert.assertEquals((String)"date_iff() test for STRING failed ", (Object)"-59", (Object)output.toString());
    }

    @Test
    public void testStringToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-20"));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-22"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        Assert.assertEquals((String)"date_iff() test for STRING failed ", (Object)"-2", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    @Test
    public void testTimestampToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        WritableTimestampObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        WritableTimestampObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(Timestamp.valueOf((String)LocalDateTime.of(109, 6, 20, 0, 0, 0, 0).toString())));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(Timestamp.valueOf((String)LocalDateTime.of(109, 6, 17, 0, 0, 0, 0).toString())));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        Assert.assertEquals((String)"datediff() test for TIMESTAMP failed ", (Object)"3", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    @Test
    public void testDateWritablepToDate() throws HiveException {
        GenericUDFDateDiff udf = new GenericUDFDateDiff();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        WritableDateObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)20)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)10)));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        IntWritable output = udf.evaluate(args);
        Assert.assertEquals((String)"datediff() test for DATEWRITABLE failed ", (Object)"10", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }
}

