/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.LocalDateTime;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFDate {
    @Test
    public void testStringToDate() throws HiveException {
        GenericUDFDate udf = new GenericUDFDate();
        JavaStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-30"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"to_date() test for STRING failed ", (Object)"2009-07-30", (Object)output.toString());
        GenericUDF.DeferredObject[] nullArgs = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null)};
        output = (DateWritableV2)udf.evaluate(nullArgs);
        Assert.assertNull((String)"to_date() with null STRING", (Object)output);
    }

    @Test
    public void testTimestampToDate() throws HiveException {
        GenericUDFDate udf = new GenericUDFDate();
        WritableTimestampObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(Timestamp.valueOf((String)LocalDateTime.of(109, 6, 30, 4, 17, 52, 0).toString())));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"to_date() test for TIMESTAMP failed ", (Object)"0109-06-30", (Object)output.toString());
        GenericUDF.DeferredObject[] nullArgs = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null)};
        output = (DateWritableV2)udf.evaluate(nullArgs);
        Assert.assertNull((String)"to_date() with null TIMESTAMP", (Object)output);
    }

    @Test
    public void testDateWritablepToDate() throws HiveException {
        GenericUDFDate udf = new GenericUDFDate();
        WritableDateObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)30)));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"to_date() test for DATEWRITABLE failed ", (Object)"0109-06-30", (Object)output.toString());
        GenericUDF.DeferredObject[] nullArgs = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null)};
        output = (DateWritableV2)udf.evaluate(nullArgs);
        Assert.assertNull((String)"to_date() with null DATE", (Object)output);
    }

    @Test
    public void testVoidToDate() throws HiveException {
        GenericUDFDate udf = new GenericUDFDate();
        WritableVoidObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null)};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertNull((String)"to_date() with null DATE ", (Object)output);
        GenericUDF.DeferredObject[] junkArgs = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text("2015-11-22"))};
        try {
            udf.evaluate(junkArgs);
            Assert.fail((String)"to_date() test with VOID non-null failed");
        }
        catch (UDFArgumentException udfae) {
            Assert.assertEquals((Object)"TO_DATE() received non-null object of VOID type", (Object)udfae.getMessage());
        }
    }
}

