/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCbrt;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFCbrt {
    @Test
    public void testCbrt() throws HiveException {
        GenericUDFCbrt udf = new GenericUDFCbrt();
        WritableDoubleObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerify(0.0, 0.0, (GenericUDF)udf);
        this.runAndVerify(1.0, 1.0, (GenericUDF)udf);
        this.runAndVerify(-1.0, -1.0, (GenericUDF)udf);
        this.runAndVerify(27.0, 3.0, (GenericUDF)udf);
        this.runAndVerify(-27.0, -3.0, (GenericUDF)udf);
        this.runAndVerify(8.786058327293048E16, 444561.0, (GenericUDF)udf);
        this.runAndVerify(null, null, (GenericUDF)udf);
    }

    private void runAndVerify(Double in, Double expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(in != null ? new DoubleWritable(in.doubleValue()) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        if (expResult == null) {
            Assert.assertNull((String)"cbrt() test", (Object)output);
        } else {
            Assert.assertNotNull((String)"cbrt() test", (Object)output);
            Assert.assertEquals((String)"cbrt() test", (double)expResult, (double)output.get(), (double)1.0E-10);
        }
    }
}

