/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileCont;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileDisc;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDAFPercentileDisc {
    GenericUDAFPercentileDisc.PercentileDiscLongCalculator calc = new GenericUDAFPercentileDisc.PercentileDiscLongCalculator();

    @Test
    public void testNoInterpolation() throws Exception {
        Long[] items = new Long[]{1L, 2L, 3L, 4L, 5L};
        this.checkPercentile(items, 0.5, 3.0);
    }

    @Test
    public void testInterpolateLower() throws Exception {
        Long[] items = new Long[]{1L, 2L, 3L, 4L, 5L};
        this.checkPercentile(items, 0.49, 3.0);
    }

    @Test
    public void testInterpolateHigher() throws Exception {
        Long[] items = new Long[]{1L, 2L, 3L, 4L, 5L};
        this.checkPercentile(items, 0.51, 4.0);
    }

    @Test
    public void testSingleItem50() throws Exception {
        Long[] items = new Long[]{1L};
        this.checkPercentile(items, 0.5, 1.0);
    }

    @Test
    public void testSingleItem100() throws Exception {
        Long[] items = new Long[]{1L};
        this.checkPercentile(items, 1.0, 1.0);
    }

    @Test
    public void testPostgresRefExample() throws Exception {
        Long[] items = new Long[]{54L, 35L, 15L, 15L, 76L, 87L, 78L};
        this.checkPercentile(items, 0.5, 54.0);
    }

    @Test
    public void testPostgresRefExample2() throws Exception {
        Long[] items = new Long[]{54L, 35L, 15L, 15L, 76L, 87L, 78L};
        this.checkPercentile(items, 0.72, 78.0);
    }

    @Test
    public void testDoubleNoInterpolation() throws Exception {
        Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.checkPercentile(items, 0.5, 3.0);
    }

    @Test
    public void testDoubleInterpolateLower() throws Exception {
        Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.checkPercentile(items, 0.49, 3.0);
    }

    @Test
    public void testDoubleInterpolateHigher() throws Exception {
        Double[] items = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.checkPercentile(items, 0.51, 4.0);
    }

    @Test
    public void testDoubleSingleItem50() throws Exception {
        Double[] items = new Double[]{1.0};
        this.checkPercentile(items, 0.5, 1.0);
    }

    @Test
    public void testDoubleSingleItem100() throws Exception {
        Double[] items = new Double[]{1.0};
        this.checkPercentile(items, 1.0, 1.0);
    }

    @Test
    public void testDoublePostgresRefExample() throws Exception {
        Double[] items = new Double[]{54.0, 35.0, 15.0, 15.0, 76.0, 87.0, 78.0};
        this.checkPercentile(items, 0.5, 54.0);
    }

    @Test
    public void testDoublePostgresRefExample2() throws Exception {
        Double[] items = new Double[]{54.5, 35.3, 15.7, 15.7, 76.8, 87.34, 78.0};
        this.checkPercentile(items, 0.72, 78.0);
    }

    private void checkPercentile(Long[] items, double percentile, double expected) throws Exception {
        GenericUDAFPercentileDisc.PercentileDiscLongEvaluator eval = new GenericUDAFPercentileDisc.PercentileDiscLongEvaluator();
        GenericUDAFPercentileCont.PercentileContEvaluator.PercentileAgg agg = new GenericUDAFPercentileCont.PercentileContEvaluator.PercentileAgg((GenericUDAFPercentileCont.PercentileContEvaluator)new GenericUDAFPercentileCont.PercentileContLongEvaluator());
        agg.percentiles = new ArrayList();
        agg.percentiles.add(new DoubleWritable(percentile));
        agg.isAscending = true;
        for (int i = 0; i < items.length; ++i) {
            eval.increment(agg, (Object)new LongWritable(items[i].longValue()), 1L);
        }
        DoubleWritable result = (DoubleWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)agg);
        Assert.assertEquals((double)expected, (double)result.get(), (double)0.01);
        eval.close();
    }

    private void checkPercentile(Double[] items, double percentile, double expected) throws Exception {
        GenericUDAFPercentileDisc.PercentileDiscDoubleEvaluator eval = new GenericUDAFPercentileDisc.PercentileDiscDoubleEvaluator();
        GenericUDAFPercentileCont.PercentileContEvaluator.PercentileAgg agg = new GenericUDAFPercentileCont.PercentileContEvaluator.PercentileAgg((GenericUDAFPercentileCont.PercentileContEvaluator)new GenericUDAFPercentileDisc.PercentileDiscDoubleEvaluator());
        agg.percentiles = new ArrayList();
        agg.percentiles.add(new DoubleWritable(percentile));
        agg.isAscending = true;
        for (int i = 0; i < items.length; ++i) {
            eval.increment(agg, (Object)new DoubleWritable(items[i].doubleValue()), 1L);
        }
        DoubleWritable result = (DoubleWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)agg);
        Assert.assertEquals((double)expected, (double)result.get(), (double)0.01);
        eval.close();
    }
}

