/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDAFCorrelation {
    @Test
    public void testCorr() throws HiveException {
        GenericUDAFCorrelation corr = new GenericUDAFCorrelation();
        GenericUDAFEvaluator eval1 = corr.getEvaluator(new TypeInfo[]{TypeInfoFactory.doubleTypeInfo, TypeInfoFactory.doubleTypeInfo});
        GenericUDAFEvaluator eval2 = corr.getEvaluator(new TypeInfo[]{TypeInfoFactory.doubleTypeInfo, TypeInfoFactory.doubleTypeInfo});
        ObjectInspector poi1 = eval1.init(GenericUDAFEvaluator.Mode.PARTIAL1, new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, PrimitiveObjectInspectorFactory.javaDoubleObjectInspector});
        ObjectInspector poi2 = eval2.init(GenericUDAFEvaluator.Mode.PARTIAL1, new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, PrimitiveObjectInspectorFactory.javaDoubleObjectInspector});
        GenericUDAFEvaluator.AggregationBuffer buffer1 = eval1.getNewAggregationBuffer();
        eval1.iterate(buffer1, new Object[]{100.0, 200.0});
        eval1.iterate(buffer1, new Object[]{150.0, 210.0});
        eval1.iterate(buffer1, new Object[]{200.0, 220.0});
        Object object1 = eval1.terminatePartial(buffer1);
        GenericUDAFEvaluator.AggregationBuffer buffer2 = eval2.getNewAggregationBuffer();
        eval2.iterate(buffer2, new Object[]{250.0, 230.0});
        eval2.iterate(buffer2, new Object[]{250.0, 240.0});
        eval2.iterate(buffer2, new Object[]{300.0, 250.0});
        eval2.iterate(buffer2, new Object[]{350.0, 260.0});
        Object object2 = eval2.terminatePartial(buffer2);
        ObjectInspector coi = eval2.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{poi1});
        GenericUDAFEvaluator.AggregationBuffer buffer3 = eval2.getNewAggregationBuffer();
        eval2.merge(buffer3, object1);
        eval2.merge(buffer3, object2);
        Object result = eval2.terminate(buffer3);
        Assert.assertEquals((Object)"0.987829161147262", (Object)String.valueOf(result));
    }
}

