/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBinarySetFunctions;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGenericUDAFBinarySetFunctions {
    private List<Object[]> rowSet;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"seq/seq", RowSetGenerator.generate(10, new RowSetGenerator.DoubleSequence(0), new RowSetGenerator.DoubleSequence(0))});
        ret.add(new Object[]{"seq/ones", RowSetGenerator.generate(10, new RowSetGenerator.DoubleSequence(0), new RowSetGenerator.ConstantSequence(1.0))});
        ret.add(new Object[]{"ones/seq", RowSetGenerator.generate(10, new RowSetGenerator.ConstantSequence(1.0), new RowSetGenerator.DoubleSequence(0))});
        ret.add(new Object[]{"empty", RowSetGenerator.generate(0, new RowSetGenerator.DoubleSequence(0), new RowSetGenerator.DoubleSequence(0))});
        ret.add(new Object[]{"lonely", RowSetGenerator.generate(1, new RowSetGenerator.DoubleSequence(10), new RowSetGenerator.DoubleSequence(10))});
        ret.add(new Object[]{"seq/seq+10", RowSetGenerator.generate(10, new RowSetGenerator.DoubleSequence(0), new RowSetGenerator.DoubleSequence(10))});
        ret.add(new Object[]{"seq/null", RowSetGenerator.generate(10, new RowSetGenerator.DoubleSequence(0), new RowSetGenerator.ConstantSequence(null))});
        ret.add(new Object[]{"null/seq0", RowSetGenerator.generate(10, new RowSetGenerator.ConstantSequence(null), new RowSetGenerator.DoubleSequence(0))});
        return ret;
    }

    public TestGenericUDAFBinarySetFunctions(String label, List<Object[]> rowSet) {
        this.rowSet = rowSet;
    }

    @Test
    public void regr_count() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.count(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrCount());
    }

    @Test
    public void regr_sxx() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.sxx(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrSXX());
    }

    @Test
    public void regr_syy() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.syy(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrSYY());
    }

    @Test
    public void regr_sxy() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.sxy(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrSXY());
    }

    @Test
    public void regr_avgx() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.avgx(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrAvgX());
    }

    @Test
    public void regr_avgy() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.avgy(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrAvgY());
    }

    @Test
    public void regr_slope() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.slope(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrSlope());
    }

    @Test
    public void regr_r2() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.r2(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrR2());
    }

    @Test
    public void regr_intercept() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.intercept(), (GenericUDAFResolver2)new GenericUDAFBinarySetFunctions.RegrIntercept());
    }

    @Test
    public void corr() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.corr(), (GenericUDAFResolver2)new GenericUDAFCorrelation());
    }

    @Test
    public void covar_pop() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.covar_pop(), (GenericUDAFResolver2)new GenericUDAFCovariance());
    }

    @Test
    public void covar_samp() throws Exception {
        RegrIntermediate expected = RegrIntermediate.computeFor(this.rowSet);
        this.validateUDAF(expected.covar_samp(), (GenericUDAFResolver2)new GenericUDAFCovarianceSample());
    }

    private void validateUDAF(Double expectedResult, GenericUDAFResolver2 udaf) throws Exception {
        ObjectInspector[] params = new ObjectInspector[]{PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, PrimitiveObjectInspectorFactory.javaDoubleObjectInspector};
        SimpleGenericUDAFParameterInfo gpi = new SimpleGenericUDAFParameterInfo(params, false, false, false);
        GenericUDAFExecutor executor = new GenericUDAFExecutor(udaf, (GenericUDAFParameterInfo)gpi);
        List<Object> values = executor.run(this.rowSet);
        if (expectedResult == null) {
            for (Object v : values) {
                Assert.assertNull((Object)v);
            }
        } else {
            for (Object v : values) {
                if (v instanceof DoubleWritable) {
                    Assert.assertEquals((double)expectedResult, (double)((DoubleWritable)v).get(), (double)1.0E-10);
                    continue;
                }
                Assert.assertEquals((double)expectedResult, (double)((LongWritable)v).get(), (double)1.0E-10);
            }
        }
    }

    static class RegrIntermediate {
        public double sum_x2;
        public double sum_y2;
        public double sum_x;
        public double sum_y;
        public double sum_xy;
        public double n;

        RegrIntermediate() {
        }

        public void add(Double y, Double x) {
            if (x == null || y == null) {
                return;
            }
            this.sum_x2 += x * x;
            this.sum_y2 += y * y;
            this.sum_x += x.doubleValue();
            this.sum_y += y.doubleValue();
            this.sum_xy += x * y;
            this.n += 1.0;
        }

        public Double intercept() {
            double xx = this.n * this.sum_x2 - this.sum_x * this.sum_x;
            if (this.n == 0.0 || xx == 0.0) {
                return null;
            }
            return (this.sum_y * this.sum_x2 - this.sum_x * this.sum_xy) / xx;
        }

        public Double sxy() {
            if (this.n == 0.0) {
                return null;
            }
            return this.sum_xy - this.sum_x * this.sum_y / this.n;
        }

        public Double covar_pop() {
            if (this.n == 0.0) {
                return null;
            }
            return (this.sum_xy - this.sum_x * this.sum_y / this.n) / this.n;
        }

        public Double covar_samp() {
            if (this.n <= 1.0) {
                return null;
            }
            return (this.sum_xy - this.sum_x * this.sum_y / this.n) / (this.n - 1.0);
        }

        public Double corr() {
            double xx = this.n * this.sum_x2 - this.sum_x * this.sum_x;
            double yy = this.n * this.sum_y2 - this.sum_y * this.sum_y;
            if (this.n == 0.0 || xx == 0.0 || yy == 0.0) {
                return null;
            }
            double c = this.n * this.sum_xy - this.sum_x * this.sum_y;
            return Math.sqrt(c * c / xx / yy);
        }

        public Double r2() {
            double xx = this.n * this.sum_x2 - this.sum_x * this.sum_x;
            double yy = this.n * this.sum_y2 - this.sum_y * this.sum_y;
            if (this.n == 0.0 || xx == 0.0) {
                return null;
            }
            if (yy == 0.0) {
                return 1.0;
            }
            double c = this.n * this.sum_xy - this.sum_x * this.sum_y;
            return c * c / xx / yy;
        }

        public Double slope() {
            if (this.n == 0.0 || this.n * this.sum_x2 == this.sum_x * this.sum_x) {
                return null;
            }
            return (this.n * this.sum_xy - this.sum_x * this.sum_y) / (this.n * this.sum_x2 - this.sum_x * this.sum_x);
        }

        public Double avgx() {
            if (this.n == 0.0) {
                return null;
            }
            return this.sum_x / this.n;
        }

        public Double avgy() {
            if (this.n == 0.0) {
                return null;
            }
            return this.sum_y / this.n;
        }

        public Double count() {
            return this.n;
        }

        public Double sxx() {
            if (this.n == 0.0) {
                return null;
            }
            return this.sum_x2 - this.sum_x * this.sum_x / this.n;
        }

        public Double syy() {
            if (this.n == 0.0) {
                return null;
            }
            return this.sum_y2 - this.sum_y * this.sum_y / this.n;
        }

        public static RegrIntermediate computeFor(List<Object[]> rows) {
            RegrIntermediate ri = new RegrIntermediate();
            for (Object[] objects : rows) {
                ri.add((Double)objects[0], (Double)objects[1]);
            }
            return ri;
        }
    }

    public static class RowSetGenerator {
        public static List<Object[]> generate(int numRows, FieldGenerator ... generators) {
            ArrayList<Object[]> ret = new ArrayList<Object[]>(numRows);
            for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (FieldGenerator g : generators) {
                    row.add(g.apply(rowIdx));
                }
                ret.add(row.toArray());
            }
            return ret;
        }

        public static class DoubleSequence
        implements FieldGenerator {
            private int offset;

            public DoubleSequence(int offset) {
                this.offset = offset;
            }

            @Override
            public Object apply(int rowIndex) {
                double d = rowIndex + this.offset;
                return d;
            }
        }

        public static class ConstantSequence
        implements FieldGenerator {
            private Object constant;

            public ConstantSequence(Object constant) {
                this.constant = constant;
            }

            @Override
            public Object apply(int rowIndex) {
                return this.constant;
            }
        }

        public static interface FieldGenerator {
            public Object apply(int var1);
        }
    }

    public static class GenericUDAFExecutor {
        private GenericUDAFResolver2 evaluatorFactory;
        private GenericUDAFParameterInfo info;
        private ObjectInspector[] partialOIs;

        public GenericUDAFExecutor(GenericUDAFResolver2 evaluatorFactory, GenericUDAFParameterInfo info) throws Exception {
            this.evaluatorFactory = evaluatorFactory;
            this.info = info;
            GenericUDAFEvaluator eval0 = evaluatorFactory.getEvaluator(info);
            this.partialOIs = new ObjectInspector[]{eval0.init(GenericUDAFEvaluator.Mode.PARTIAL1, info.getParameterObjectInspectors())};
        }

        List<Object> run(List<Object[]> values) throws Exception {
            Object r1 = this.runComplete(values);
            Object r2 = this.runPartialFinal(values);
            Object r3 = this.runPartial2Final(values);
            return Lists.newArrayList((Object[])new Object[]{r1, r2, r3});
        }

        private Object runComplete(List<Object[]> values) throws SemanticException, HiveException {
            GenericUDAFEvaluator eval = this.evaluatorFactory.getEvaluator(this.info);
            eval.init(GenericUDAFEvaluator.Mode.COMPLETE, this.info.getParameterObjectInspectors());
            GenericUDAFEvaluator.AggregationBuffer agg = eval.getNewAggregationBuffer();
            for (Object[] parameters : values) {
                eval.iterate(agg, parameters);
            }
            return eval.terminate(agg);
        }

        private Object runPartialFinal(List<Object[]> values) throws Exception {
            GenericUDAFEvaluator eval = this.evaluatorFactory.getEvaluator(this.info);
            eval.init(GenericUDAFEvaluator.Mode.FINAL, this.partialOIs);
            GenericUDAFEvaluator.AggregationBuffer buf = eval.getNewAggregationBuffer();
            for (Object partialResult : this.runPartial1(values)) {
                eval.merge(buf, partialResult);
            }
            return eval.terminate(buf);
        }

        private Object runPartial2Final(List<Object[]> values) throws Exception {
            GenericUDAFEvaluator eval = this.evaluatorFactory.getEvaluator(this.info);
            eval.init(GenericUDAFEvaluator.Mode.FINAL, this.partialOIs);
            GenericUDAFEvaluator.AggregationBuffer buf = eval.getNewAggregationBuffer();
            for (Object partialResult : this.runPartial2(this.runPartial1(values))) {
                eval.merge(buf, partialResult);
            }
            return eval.terminate(buf);
        }

        private List<Object> runPartial1(List<Object[]> values) throws Exception {
            ArrayList<Object> ret = new ArrayList<Object>();
            int batchSize = 1;
            Iterator<Object[]> iter = values.iterator();
            do {
                GenericUDAFEvaluator eval = this.evaluatorFactory.getEvaluator(this.info);
                eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, this.info.getParameterObjectInspectors());
                GenericUDAFEvaluator.AggregationBuffer buf = eval.getNewAggregationBuffer();
                for (int i = 0; i < batchSize - 1 && iter.hasNext(); ++i) {
                    eval.iterate(buf, iter.next());
                }
                batchSize <<= 1;
                ret.add(eval.terminatePartial(buf));
            } while (iter.hasNext());
            return ret;
        }

        private List<Object> runPartial2(List<Object> values) throws Exception {
            ArrayList<Object> ret = new ArrayList<Object>();
            int batchSize = 1;
            Iterator<Object> iter = values.iterator();
            do {
                GenericUDAFEvaluator eval = this.evaluatorFactory.getEvaluator(this.info);
                eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, this.partialOIs);
                GenericUDAFEvaluator.AggregationBuffer buf = eval.getNewAggregationBuffer();
                for (int i = 0; i < batchSize - 1 && iter.hasNext(); ++i) {
                    eval.merge(buf, iter.next());
                }
                batchSize <<= 1;
                ret.add(eval.terminatePartial(buf));
            } while (iter.hasNext());
            return ret;
        }
    }
}

