/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFMd5;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestUDFMd5 {
    @Test
    public void testMD5Str() throws HiveException {
        UDFMd5 udf = new UDFMd5();
        this.runAndVerifyStr("ABC", "902fbdd2b1df0c4f70b4a5d23525e932", udf);
        this.runAndVerifyStr("", "d41d8cd98f00b204e9800998ecf8427e", udf);
        this.runAndVerifyStr(null, null, udf);
    }

    @Test
    public void testMD5Bin() throws HiveException {
        UDFMd5 udf = new UDFMd5();
        this.runAndVerifyBin(new byte[]{65, 66, 67}, "902fbdd2b1df0c4f70b4a5d23525e932", udf);
        this.runAndVerifyBin(new byte[0], "d41d8cd98f00b204e9800998ecf8427e", udf);
        this.runAndVerifyBin(null, null, udf);
    }

    private void runAndVerifyStr(String str, String expResult, UDFMd5 udf) throws HiveException {
        Text t = str != null ? new Text(str) : null;
        Text output = udf.evaluate(t);
        Assert.assertEquals((String)"md5() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }

    private void runAndVerifyBin(byte[] binV, String expResult, UDFMd5 udf) throws HiveException {
        BytesWritable binWr = binV != null ? new BytesWritable(binV) : null;
        Text output = udf.evaluate(binWr);
        Assert.assertEquals((String)"md5() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }
}

