/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StringableMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWorker
extends CompactorTest {
    private static final String CLASS_NAME = TestWorker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    @Test
    public void nothing() throws Exception {
        this.startWorker();
    }

    @Test
    public void stringableMap() throws Exception {
        StringableMap m = new StringableMap(new HashMap());
        String s = m.toString();
        Assert.assertEquals((Object)"0:", (Object)s);
        m = new StringableMap(s);
        Assert.assertEquals((long)0L, (long)m.size());
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("mary", "poppins");
        base.put("bert", null);
        base.put(null, "banks");
        m = new StringableMap(base);
        s = m.toString();
        m = new StringableMap(s);
        Assert.assertEquals((long)3L, (long)m.size());
        HashMap<String, Boolean> saw = new HashMap<String, Boolean>(3);
        saw.put("mary", false);
        saw.put("bert", false);
        saw.put(null, false);
        for (Map.Entry e : m.entrySet()) {
            saw.put((String)e.getKey(), true);
            if ("mary".equals(e.getKey())) {
                Assert.assertEquals((Object)"poppins", e.getValue());
                continue;
            }
            if ("bert".equals(e.getKey())) {
                Assert.assertNull(e.getValue());
                continue;
            }
            if (null == e.getKey()) {
                Assert.assertEquals((Object)"banks", e.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected value " + (String)e.getKey()));
        }
        Assert.assertEquals((long)3L, (long)saw.size());
        Assert.assertTrue((boolean)((Boolean)saw.get("mary")));
        Assert.assertTrue((boolean)((Boolean)saw.get("bert")));
        Assert.assertTrue((boolean)((Boolean)saw.get(null)));
    }

    @Test
    public void stringableList() throws Exception {
        CompactorMR.StringableList ls = new CompactorMR.StringableList();
        String s = ls.toString();
        Assert.assertEquals((Object)"0:", (Object)s);
        ls = new CompactorMR.StringableList(s);
        Assert.assertEquals((long)0L, (long)ls.size());
        ls = new CompactorMR.StringableList();
        ls.add((Object)new Path("/tmp"));
        ls.add((Object)new Path("/usr"));
        s = ls.toString();
        Assert.assertTrue((String)("Expected 2:4:/tmp4:/usr or 2:4:/usr4:/tmp, got " + s), ("2:4:/tmp4:/usr".equals(s) || "2:4:/usr4:/tmp".equals(s) ? 1 : 0) != 0);
        ls = new CompactorMR.StringableList(s);
        Assert.assertEquals((long)2L, (long)ls.size());
        boolean sawTmp = false;
        boolean sawUsr = false;
        for (Path p : ls) {
            if ("/tmp".equals(p.toString())) {
                sawTmp = true;
                continue;
            }
            if ("/usr".equals(p.toString())) {
                sawUsr = true;
                continue;
            }
            Assert.fail((String)("Unexpected path " + p.toString()));
        }
        Assert.assertTrue((boolean)sawTmp);
        Assert.assertTrue((boolean)sawUsr);
    }

    @Test
    public void inputSplit() throws Exception {
        String basename = "/warehouse/foo/base_1";
        String delta1 = "/warehouse/foo/delta_2_3";
        String delta2 = "/warehouse/foo/delta_4_7";
        HiveConf conf = new HiveConf();
        Path file = new Path(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "newWriteInputSplitTest");
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(file);
        for (int i = 0; i < 10; ++i) {
            os.writeBytes("mary had a little lamb its fleece was white as snow\n");
        }
        os.close();
        ArrayList<Path> files = new ArrayList<Path>(1);
        files.add(file);
        Path[] deltas = new Path[]{new Path(delta1), new Path(delta2)};
        CompactorMR.CompactorInputSplit split = new CompactorMR.CompactorInputSplit((Configuration)conf, 3, files, new Path(basename), deltas, new HashMap());
        Assert.assertEquals((long)520L, (long)split.getLength());
        String[] locations = split.getLocations();
        Assert.assertEquals((long)1L, (long)locations.length);
        Assert.assertEquals((Object)"localhost", (Object)locations[0]);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        split.write((DataOutput)out);
        split = new CompactorMR.CompactorInputSplit();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
        split.readFields((DataInput)in);
        Assert.assertEquals((long)3L, (long)split.getBucket());
        Assert.assertEquals((Object)basename, (Object)split.getBaseDir().toString());
        deltas = split.getDeltaDirs();
        Assert.assertEquals((long)2L, (long)deltas.length);
        Assert.assertEquals((Object)delta1, (Object)deltas[0].toString());
        Assert.assertEquals((Object)delta2, (Object)deltas[1].toString());
    }

    @Test
    public void inputSplitNullBase() throws Exception {
        String delta1 = "/warehouse/foo/delta_2_3";
        String delta2 = "/warehouse/foo/delta_4_7";
        HiveConf conf = new HiveConf();
        Path file = new Path(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "newWriteInputSplitTest");
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(file);
        for (int i = 0; i < 10; ++i) {
            os.writeBytes("mary had a little lamb its fleece was white as snow\n");
        }
        os.close();
        ArrayList<Path> files = new ArrayList<Path>(1);
        files.add(file);
        Path[] deltas = new Path[]{new Path(delta1), new Path(delta2)};
        CompactorMR.CompactorInputSplit split = new CompactorMR.CompactorInputSplit((Configuration)conf, 3, files, null, deltas, new HashMap());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        split.write((DataOutput)out);
        split = new CompactorMR.CompactorInputSplit();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
        split.readFields((DataInput)in);
        Assert.assertEquals((long)3L, (long)split.getBucket());
        Assert.assertNull((Object)split.getBaseDir());
        deltas = split.getDeltaDirs();
        Assert.assertEquals((long)2L, (long)deltas.length);
        Assert.assertEquals((Object)delta1, (Object)deltas[0].toString());
        Assert.assertEquals((Object)delta2, (Object)deltas[1].toString());
    }

    @Test
    public void sortedTable() throws Exception {
        ArrayList<Order> sortCols = new ArrayList<Order>(1);
        sortCols.add(new Order("b", 1));
        Table t = this.newTable("default", "st", false, new HashMap<String, String>(), sortCols, false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "st", 25);
        CompactionRequest rqst = new CompactionRequest("default", "st", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
    }

    @Test
    public void sortedPartition() throws Exception {
        ArrayList<Order> sortCols = new ArrayList<Order>(1);
        sortCols.add(new Order("b", 1));
        Table t = this.newTable("default", "sp", true, new HashMap<String, String>(), sortCols, false);
        Partition p = this.newPartition(t, "today", sortCols);
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "sp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "sp", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
    }

    @Test
    public void minorTableWithBase() throws Exception {
        LOG.debug("Starting minorTableWithBase");
        Table t = this.newTable("default", "mtwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "mtwb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)5L, (long)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            FileStatus[] buckets;
            if (stat[i].getPath().getName().equals(this.makeDeltaDirNameCompacted(21L, 24L) + "_v0000026")) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
            }
            if (stat[i].getPath().getName().equals(this.makeDeleteDeltaDirNameCompacted(21L, 24L) + "_v0000026")) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the delta file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewDelta);
    }

    @Test
    public void minorWithOpenInMiddle() throws Exception {
        LOG.debug("Starting minorWithOpenInMiddle");
        Table t = this.newTable("default", "mtwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 25L, 3);
        this.addLengthFile(t, null, 23L, 25L, 3);
        this.addDeltaFile(t, null, 26L, 27L, 2);
        this.burnThroughTransactions("default", "mtwb", 27, new HashSet<Long>(Arrays.asList(23L)), null);
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Object[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((String)TestWorker.toString((FileStatus[])stat), (long)4L, (long)stat.length);
        Arrays.sort(stat);
        Assert.assertEquals((Object)"base_20", (Object)stat[0].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(21L, 22L), (Object)stat[1].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(23L, 25L), (Object)stat[2].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(26L, 27L), (Object)stat[3].getPath().getName());
    }

    @Test
    public void minorWithAborted() throws Exception {
        LOG.debug("Starting minorWithAborted");
        Table t = this.newTable("default", "mtwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 25L, 3);
        this.addLengthFile(t, null, 23L, 25L, 3);
        this.addDeltaFile(t, null, 26L, 27L, 2);
        this.burnThroughTransactions("default", "mtwb", 27, null, new HashSet<Long>(Arrays.asList(24L, 25L)));
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Object[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)6L, (long)stat.length);
        Arrays.sort(stat);
        Assert.assertEquals((Object)"base_20", (Object)stat[0].getPath().getName());
        Assert.assertEquals((Object)(this.makeDeleteDeltaDirNameCompacted(21L, 27L) + "_v0000028"), (Object)stat[1].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(21L, 22L), (Object)stat[2].getPath().getName());
        Assert.assertEquals((Object)(this.makeDeltaDirNameCompacted(21L, 27L) + "_v0000028"), (Object)stat[3].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(23L, 25L), (Object)stat[4].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(26L, 27L), (Object)stat[5].getPath().getName());
    }

    @Test
    public void minorPartitionWithBase() throws Exception {
        Table t = this.newTable("default", "mpwb", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "mpwb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "mpwb", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((long)5L, (long)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            FileStatus[] buckets;
            if (stat[i].getPath().getName().equals(this.makeDeltaDirNameCompacted(21L, 24L) + "_v0000026")) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
            }
            if (stat[i].getPath().getName().equals(this.makeDeleteDeltaDirNameCompacted(21L, 24L))) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the delta file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewDelta);
    }

    @Test
    public void minorTableNoBase() throws Exception {
        LOG.debug("Starting minorTableWithBase");
        Table t = this.newTable("default", "mtnb", false);
        this.addDeltaFile(t, null, 1L, 2L, 2);
        this.addDeltaFile(t, null, 3L, 4L, 2);
        this.burnThroughTransactions("default", "mtnb", 5);
        CompactionRequest rqst = new CompactionRequest("default", "mtnb", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            FileStatus[] buckets;
            if (stat[i].getPath().getName().equals(this.makeDeltaDirNameCompacted(1L, 4L) + "_v0000006")) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
            }
            if (stat[i].getPath().getName().equals(this.makeDeleteDeltaDirNameCompacted(1L, 4L) + "_v0000006")) {
                sawNewDelta = true;
                buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the delta file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewDelta);
    }

    @Test
    public void majorTableWithBase() throws Exception {
        LOG.debug("Starting majorTableWithBase");
        Table t = this.newTable("default", "matwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "matwb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "matwb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024_v0000026")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)624L, (long)buckets[0].getLen());
                Assert.assertEquals((long)624L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewBase);
    }

    @Test
    public void minorNoBaseLotsOfDeltas() throws Exception {
        this.compactNoBaseLotsOfDeltas(CompactionType.MINOR);
    }

    @Test
    public void majorNoBaseLotsOfDeltas() throws Exception {
        this.compactNoBaseLotsOfDeltas(CompactionType.MAJOR);
    }

    private void compactNoBaseLotsOfDeltas(CompactionType type) throws Exception {
        this.conf.setIntVar(HiveConf.ConfVars.COMPACTOR_MAX_NUM_DELTA, 2);
        Table t = this.newTable("default", "mapwb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 21L, 21L, 2);
        this.addDeltaFile(t, p, 23L, 23L, 2);
        this.addDeltaFile(t, p, 25L, 29L, 2);
        this.addDeltaFile(t, p, 31L, 32L, 3);
        this.addDeltaFile(t, p, 31L, 33L, 5);
        this.addDeltaFile(t, p, 35L, 35L, 1);
        this.burnThroughTransactions("default", "mapwb", 35);
        CompactionRequest rqst = new CompactionRequest("default", "mapwb", type);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        int numFilesExpected = 11 + (type == CompactionType.MINOR ? 1 : 0);
        Assert.assertEquals((long)numFilesExpected, (long)stat.length);
        ArrayList<String> matchesNotFound = new ArrayList<String>(numFilesExpected);
        matchesNotFound.add(this.makeDeleteDeltaDirNameCompacted(21L, 23L) + "_v\\d+");
        matchesNotFound.add(this.makeDeleteDeltaDirNameCompacted(25L, 33L) + "_v\\d+");
        matchesNotFound.add(this.makeDeltaDirName(21L, 21L));
        matchesNotFound.add(this.makeDeltaDirName(23L, 23L));
        matchesNotFound.add(this.makeDeltaDirNameCompacted(25L, 29L));
        matchesNotFound.add(this.makeDeltaDirNameCompacted(31L, 32L));
        matchesNotFound.add(this.makeDeltaDirNameCompacted(31L, 33L));
        matchesNotFound.add(this.makeDeltaDirName(35L, 35L));
        matchesNotFound.add(this.makeDeltaDirNameCompacted(21L, 23L) + "_v\\d+");
        matchesNotFound.add(this.makeDeltaDirNameCompacted(25L, 33L) + "_v\\d+");
        if (type == CompactionType.MINOR) {
            matchesNotFound.add(this.makeDeltaDirNameCompacted(21L, 35L) + "_v\\d+");
            matchesNotFound.add(this.makeDeleteDeltaDirNameCompacted(21L, 35L) + "_v\\d+");
        }
        if (type == CompactionType.MAJOR) {
            matchesNotFound.add(AcidUtils.baseDir((long)35L) + "_v\\d+");
        }
        block0: for (FileStatus f : stat) {
            for (int j = 0; j < matchesNotFound.size(); ++j) {
                if (!f.getPath().getName().matches((String)matchesNotFound.get(j))) continue;
                matchesNotFound.remove(j);
                continue block0;
            }
        }
        if (matchesNotFound.size() == 0) {
            return;
        }
        Assert.assertTrue((String)("Files remaining: " + matchesNotFound + "; " + TestWorker.toString(stat)), (boolean)false);
    }

    @Test
    public void majorPartitionWithBase() throws Exception {
        LOG.debug("Starting majorPartitionWithBase");
        Table t = this.newTable("default", "mapwb", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "mapwb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "mapwb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024_v0000026")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)624L, (long)buckets[0].getLen());
                Assert.assertEquals((long)624L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewBase);
    }

    @Test
    public void majorTableNoBase() throws Exception {
        LOG.debug("Starting majorTableNoBase");
        Table t = this.newTable("default", "matnb", false);
        this.addDeltaFile(t, null, 1L, 2L, 2);
        this.addDeltaFile(t, null, 3L, 4L, 2);
        this.burnThroughTransactions("default", "matnb", 4);
        CompactionRequest rqst = new CompactionRequest("default", "matnb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)3L, (long)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000004_v0000005")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)104L, (long)buckets[0].getLen());
                Assert.assertEquals((long)104L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewBase);
    }

    private static String toString(FileStatus[] stat) {
        StringBuilder sb = new StringBuilder("stat{");
        if (stat == null) {
            return sb.toString();
        }
        for (FileStatus f : stat) {
            sb.append(f.getPath()).append(",");
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Test
    public void majorTableLegacy() throws Exception {
        LOG.debug("Starting majorTableLegacy");
        Table t = this.newTable("default", "matl", false);
        this.addLegacyFile(t, null, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "matl", 25);
        CompactionRequest rqst = new CompactionRequest("default", "matl", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000024_v0000026")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertEquals((long)624L, (long)buckets[0].getLen());
                Assert.assertEquals((long)624L, (long)buckets[1].getLen());
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewBase);
    }

    @Test
    public void minorTableLegacy() throws Exception {
        LOG.debug("Starting minorTableLegacy");
        Table t = this.newTable("default", "mtl", false);
        this.addLegacyFile(t, null, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "mtl", 25);
        CompactionRequest rqst = new CompactionRequest("default", "mtl", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        boolean sawNewDelta = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals(this.makeDeltaDirNameCompacted(21L, 24L) + "_v0000026")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), AcidUtils.hiddenFileFilter);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewDelta);
    }

    @Test
    public void majorPartitionWithBaseMissingBuckets() throws Exception {
        LOG.debug("Starting majorPartitionWithBaseMissingBuckets");
        Table t = this.newTable("default", "mapwbmb", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20, 2, false);
        this.addDeltaFile(t, p, 21L, 22L, 2, 2, false);
        this.addDeltaFile(t, p, 23L, 26L, 4);
        this.burnThroughTransactions("default", "mapwbmb", 27);
        CompactionRequest rqst = new CompactionRequest("default", "mapwbmb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(p.getSd().getLocation()));
        Assert.assertEquals((long)4L, (long)stat.length);
        boolean sawNewBase = false;
        for (int i = 0; i < stat.length; ++i) {
            if (stat[i].getPath().getName().equals("base_0000026_v0000028")) {
                sawNewBase = true;
                FileStatus[] buckets = fs.listStatus(stat[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)2L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue(("bucket_00000".equals(buckets[0].getPath().getName()) && 104L == buckets[0].getLen() && "bucket_00001".equals(buckets[1].getPath().getName()) && 676L == buckets[1].getLen() || "bucket_00000".equals(buckets[1].getPath().getName()) && 104L == buckets[1].getLen() && "bucket_00001".equals(buckets[0].getPath().getName()) && 676L == buckets[0].getLen() ? 1 : 0) != 0);
                continue;
            }
            LOG.debug("This is not the file you are looking for " + stat[i].getPath().getName());
        }
        Assert.assertTrue((String)TestWorker.toString(stat), (boolean)sawNewBase);
    }

    @Test
    public void majorWithOpenInMiddle() throws Exception {
        LOG.debug("Starting majorWithOpenInMiddle");
        Table t = this.newTable("default", "mtwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 25L, 3);
        this.addLengthFile(t, null, 23L, 25L, 3);
        this.addDeltaFile(t, null, 26L, 27L, 2);
        this.burnThroughTransactions("default", "mtwb", 27, new HashSet<Long>(Arrays.asList(23L)), null);
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Object[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)5L, (long)stat.length);
        Arrays.sort(stat);
        Assert.assertEquals((Object)"base_0000022_v0000028", (Object)stat[0].getPath().getName());
        Assert.assertEquals((Object)"base_20", (Object)stat[1].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(21L, 22L), (Object)stat[2].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(23L, 25L), (Object)stat[3].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(26L, 27L), (Object)stat[4].getPath().getName());
    }

    @Test
    public void majorWithAborted() throws Exception {
        LOG.debug("Starting majorWithAborted");
        Table t = this.newTable("default", "mtwb", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 25L, 3);
        this.addLengthFile(t, null, 23L, 25L, 3);
        this.addDeltaFile(t, null, 26L, 27L, 2);
        this.burnThroughTransactions("default", "mtwb", 27, null, new HashSet<Long>(Arrays.asList(24L, 25L)));
        CompactionRequest rqst = new CompactionRequest("default", "mtwb", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Object[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)5L, (long)stat.length);
        Arrays.sort(stat);
        Assert.assertEquals((Object)"base_0000027_v0000028", (Object)stat[0].getPath().getName());
        Assert.assertEquals((Object)"base_20", (Object)stat[1].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(21L, 22L), (Object)stat[2].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(23L, 25L), (Object)stat[3].getPath().getName());
        Assert.assertEquals((Object)this.makeDeltaDirName(26L, 27L), (Object)stat[4].getPath().getName());
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @Test
    public void droppedTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addDeltaFile(t, null, 1L, 2L, 2);
        this.addDeltaFile(t, null, 3L, 4L, 2);
        this.burnThroughTransactions("default", "dt", 4);
        CompactionRequest rqst = new CompactionRequest("default", "dt", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        this.ms.dropTable("default", "dt");
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void droppedPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "dp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dp", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void oneDeltaWithAbortedTxn() throws Exception {
        Table t = this.newTable("default", "delta1", false);
        this.addDeltaFile(t, null, 0L, 2L, 3);
        HashSet<Long> aborted = new HashSet<Long>();
        aborted.add(1L);
        this.burnThroughTransactions("default", "delta1", 3, null, aborted);
        this.verifyTxn1IsAborted(0, t, CompactionType.MAJOR);
        this.verifyTxn1IsAborted(1, t, CompactionType.MINOR);
        this.conf.setBoolVar(HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED, true);
        this.verifyTxn1IsAborted(2, t, CompactionType.MAJOR);
        this.verifyTxn1IsAborted(3, t, CompactionType.MINOR);
        this.conf.setBoolVar(HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED, false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("transactional_properties", "insert_only");
        Table mm = this.newTable("default", "delta1", false, parameters);
        this.addDeltaFile(mm, null, 0L, 2L, 3);
        this.burnThroughTransactions("default", "delta1", 3, null, aborted);
        this.verifyTxn1IsAborted(0, t, CompactionType.MAJOR);
        this.verifyTxn1IsAborted(1, t, CompactionType.MINOR);
    }

    @Test
    public void insertOnlyDisabled() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("transactional_properties", "insert_only");
        Table t = this.newTable("default", "iod", false, parameters);
        this.addDeltaFile(t, null, 1L, 2L, 2);
        this.addDeltaFile(t, null, 3L, 4L, 2);
        this.burnThroughTransactions("default", "iod", 5);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM, false);
        CompactionRequest rqst = new CompactionRequest("default", "iod", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"failed", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
    }

    private void verifyTxn1IsAborted(int compactionNum, Table t, CompactionType type) throws Exception {
        CompactionRequest rqst = new CompactionRequest("default", t.getTableName(), type);
        this.txnHandler.compact(rqst);
        this.startWorker();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileStatus[] stat = fs.listStatus(new Path(t.getSd().getLocation()));
        Assert.assertEquals((long)1L, (long)stat.length);
        Assert.assertEquals((Object)this.makeDeltaDirName(0L, 2L), (Object)stat[0].getPath().getName());
        List compacts = this.txnHandler.showCompact(new ShowCompactRequest()).getCompacts();
        Assert.assertEquals((long)(compactionNum + 1), (long)compacts.size());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(compactionNum)).getState());
        this.startCleaner();
        List openTxns = HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf).showTxns().getOpen_txns();
        Assert.assertEquals((long)1L, (long)((TxnInfo)openTxns.get(0)).getId());
        Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)openTxns.get(0)).getState());
    }

    @Test(timeout=1000L)
    public void testNormalRun() throws Exception {
        this.runTimeoutTest(10000L, false, true);
    }

    @Test(timeout=1000L)
    public void testTimeoutWithInterrupt() throws Exception {
        this.runTimeoutTest(1L, true, false);
    }

    @Test(timeout=1000L)
    public void testTimeoutWithoutInterrupt() throws Exception {
        this.runTimeoutTest(1L, true, true);
    }

    private void runTimeoutTest(long timeout, boolean runForever, boolean swallowInterrupt) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        HiveConf timeoutConf = new HiveConf(this.conf);
        timeoutConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, timeout, TimeUnit.MILLISECONDS);
        TimeoutWorker timeoutWorker = this.getTimeoutWorker(timeoutConf, executor, runForever, swallowInterrupt);
        while (!timeoutWorker.looped.get()) {
            Thread.sleep(10L);
        }
        timeoutWorker.looped.set(false);
        while (!timeoutWorker.looped.get()) {
            Thread.sleep(10L);
        }
        timeoutWorker.stop.set(true);
        executor.shutdownNow();
    }

    private TimeoutWorker getTimeoutWorker(HiveConf conf, ExecutorService executor, boolean runForever, boolean swallowInterrupt) throws Exception {
        TimeoutWorker timeoutWorker = new TimeoutWorker(runForever, swallowInterrupt);
        timeoutWorker.setThreadId((int)timeoutWorker.getId());
        timeoutWorker.setConf((Configuration)conf);
        timeoutWorker.init(new AtomicBoolean(false));
        executor.submit(() -> timeoutWorker.run());
        return timeoutWorker;
    }

    @After
    public void tearDown() throws Exception {
        this.compactorTestCleanup();
    }

    private static final class TimeoutWorker
    extends Worker {
        private boolean runForever;
        private boolean swallowInterrupt;
        private AtomicBoolean looped;

        private TimeoutWorker(boolean runForever, boolean swallowInterrupt) {
            this.runForever = runForever;
            this.swallowInterrupt = swallowInterrupt;
            this.looped = new AtomicBoolean(false);
        }

        protected Boolean findNextCompactionAndExecute(boolean computeStats) throws InterruptedException {
            this.looped.set(true);
            if (this.runForever) {
                while (!this.stop.get()) {
                    try {
                        this.looped.set(true);
                        Thread.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException ie) {
                        if (!this.swallowInterrupt) {
                            throw ie;
                        }
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
            }
            return true;
        }
    }
}

