/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCleaner
extends CompactorTest {
    @Test
    public void nothing() throws Exception {
        this.startCleaner();
    }

    @Test
    public void cleanupAfterMajorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25_v26", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorTableCompactionWithLongRunningQuery() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25, 26L);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        ci.runAs = System.getProperty("user.name");
        long compactTxn = this.openTxn(TxnType.COMPACTION);
        this.txnHandler.updateCompactorState(ci, compactTxn);
        this.txnHandler.markCompacted(ci);
        long longQuery = this.openTxn();
        this.txnHandler.commitTxn(new CommitTxnRequest(compactTxn));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)4L, (long)paths.size());
        this.txnHandler.commitTxn(new CommitTxnRequest(longQuery));
        Thread.sleep(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25_v26", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "campc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campc", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMinorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camitc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camitc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camitc", CompactionType.MINOR);
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path p : paths) {
            if (p.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (p.getName().equals(this.makeDeltaDirName(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + p.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMinorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "camipc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camipc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMajorPartitionCompactionNoBase() throws Exception {
        Table t = this.newTable("default", "campcnb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campcnb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campcnb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void droppedTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addDeltaFile(t, null, 1L, 22L, 22);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dt", CompactionType.MINOR);
        this.compactInTxn(rqst);
        this.ms.dropTable("default", "dt");
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void droppedPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "dp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dp", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void processCompactionCandidatesInParallel() throws Exception {
        int i;
        Table t = this.newTable("default", "camipc", true);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (i = 0; i < 10; ++i) {
            Partition p = this.newPartition(t, "today" + i);
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            this.addDeltaFile(t, p, 21L, 24L, 4);
            partitions.add(p);
        }
        this.burnThroughTransactions("default", "camipc", 25);
        for (i = 0; i < 10; ++i) {
            CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
            rqst.setPartitionname("ds=today" + i);
            this.compactInTxn(rqst);
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM, 3);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)10L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        for (Partition pa : partitions) {
            List<Path> paths = this.getDirectories(this.conf, t, pa);
            Assert.assertEquals((long)2L, (long)paths.size());
            boolean sawBase = false;
            boolean sawDelta = false;
            for (Path path : paths) {
                if (path.getName().equals("base_20")) {
                    sawBase = true;
                    continue;
                }
                if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                    sawDelta = true;
                    continue;
                }
                Assert.fail((String)("Unexpected file " + path.getName()));
            }
            Assert.assertTrue((boolean)sawBase);
            Assert.assertTrue((boolean)sawDelta);
        }
    }

    @Test
    public void delayedCleanupAfterMajorCompaction() throws Exception {
        Table t = this.newTable("default", "dcamc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dcamc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void delayedCleanupAfterMinorCompactionOnPartition() throws Exception {
        Table t = this.newTable("default", "dcamicop", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "dcamicop", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamicop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void delayedCleanupAfterMinorAndMajorCompaction() throws Exception {
        Table t = this.newTable("default", "dcamimcop", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 21L, 1);
        this.addDeltaFile(t, p, 22L, 22L, 1);
        this.burnThroughTransactions("default", "dcamimcop", 22);
        CompactionRequest rqst = new CompactionRequest("default", "dcamimcop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 23L, 1);
        this.burnThroughTransactions("default", "dcamimcop", 1);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        rqst = new CompactionRequest("default", "dcamimcop", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, p, 23L, 23, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        for (ShowCompactResponseElement c : rsp.getCompacts()) {
            if (c.getType() == CompactionType.MAJOR) {
                Assert.assertEquals((Object)"ready for cleaning", (Object)c.getState());
                continue;
            }
            Assert.assertEquals((Object)"succeeded", (Object)c.getState());
        }
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)4L, (long)paths.size());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(1)).getState());
        paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_23_v25", (Object)paths.get(0).getName());
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @After
    public void tearDown() throws Exception {
        this.compactorTestCleanup();
    }
}

