/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorTestUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(CompactorTestUtilities.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int ORC_ACID_VERSION_DEFAULT = 0;

    private static int getAcidVersionFromDataFile(Path dataFile, FileSystem fs) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(dataFile);
        Reader orcReader = OrcFile.createReader((Path)dataFile, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)fs.getConf()).filesystem(fs).maxLength(AcidUtils.getLogicalLength((FileSystem)fs, (FileStatus)fileStatus)));
        if (orcReader.hasMetadataValue("hive.acid.version")) {
            char[] versionChar = UTF8.decode(orcReader.getMetadataValue("hive.acid.version")).array();
            String version = new String(versionChar);
            return Integer.valueOf(version);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getAcidVersionFromMetaFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
        Path formatFile = AcidUtils.OrcAcidVersion.getVersionFilePath((Path)deltaOrBaseDir);
        try (FSDataInputStream inputStream = fs.open(formatFile);){
            byte[] bytes = new byte[1];
            int read = inputStream.read(bytes);
            if (read != -1) {
                String version = new String(bytes, UTF8);
                int n2 = Integer.valueOf(version);
                return n2;
            }
            int n = 0;
            return n;
        }
        catch (FileNotFoundException fnf) {
            LOG.debug(formatFile + " not found, returning default: " + 0);
            return 0;
        }
        catch (IOException ex) {
            LOG.error(formatFile + " is unreadable due to: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public static void checkAcidVersion(RemoteIterator<LocatedFileStatus> files, FileSystem fs, boolean hasVersionFile, String[] expectedTypes) throws IOException {
        HashSet<String> foundPrefixes = new HashSet<String>(expectedTypes.length);
        HashSet foundDirectories = new HashSet(expectedTypes.length);
        while (files.hasNext()) {
            Path parent;
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            Path path = file.getPath();
            if (!path.getName().equals("_orc_acid_version")) {
                int version = CompactorTestUtilities.getAcidVersionFromDataFile(path, fs);
                Assert.assertEquals((String)("Unexpected version marker in " + path.getName()), (long)2L, (long)version);
            }
            if (foundDirectories.contains(parent = path.getParent())) continue;
            if (parent.getName().startsWith("base_")) {
                foundPrefixes.add("base_");
            } else if (parent.getName().startsWith("delta_")) {
                foundPrefixes.add("delta_");
            } else if (parent.getName().startsWith("delete_delta_")) {
                foundPrefixes.add("delete_delta_");
            }
            if (hasVersionFile) {
                Assert.assertTrue((String)"Version marker should exists", (boolean)fs.exists(AcidUtils.OrcAcidVersion.getVersionFilePath((Path)parent)));
                int versionFromMetaFile = CompactorTestUtilities.getAcidVersionFromMetaFile(parent, fs);
                Assert.assertEquals((String)("Unexpected version marker in " + parent), (long)2L, (long)versionFromMetaFile);
                continue;
            }
            Assert.assertFalse((String)"Version marker should not exists", (boolean)fs.exists(AcidUtils.OrcAcidVersion.getVersionFilePath((Path)parent)));
        }
        Assert.assertEquals((String)"Did not found all types of directories", new HashSet<String>(Arrays.asList(expectedTypes)), foundPrefixes);
    }

    public static enum CompactorThreadType {
        INITIATOR,
        WORKER,
        CLEANER;

    }
}

