/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestHivePrivilegeObjectOwnerNameAndType {
    protected static HiveConf conf;
    protected static Driver driver;
    private static final String TABLE_NAME;
    static HiveAuthorizer mockedAuthorizer;

    @BeforeClass
    public static void beforeTest() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)"hive"));
        conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, MockedHiveAuthorizerFactory.class.getName());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, DbTxnManager.class.getName());
        conf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        TestTxnDbUtil.prepDb((Configuration)conf);
        SessionState.start((HiveConf)conf);
        driver = new Driver(conf);
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("create table " + TABLE_NAME + " (i int, j int, k string) partitioned by (city string, `date` string) ");
    }

    private static void runCmd(String cmd) throws Exception {
        driver.run(cmd);
    }

    @AfterClass
    public static void afterTests() throws Exception {
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("drop table if exists " + TABLE_NAME);
        driver.close();
    }

    @Test
    public void testOwnerNames() throws Exception {
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        driver.compile("create table default.t1 (name string)", true);
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        boolean containsDBOwnerName = false;
        boolean containsTblOwnerName = false;
        for (HivePrivilegeObject hpo : (List)io.getLeft()) {
            if (hpo.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE && hpo.getOwnerName() != null) {
                containsDBOwnerName = true;
            }
            if (hpo.getType() != HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW || hpo.getOwnerName() == null) continue;
            containsTblOwnerName = true;
        }
        for (HivePrivilegeObject hpo : (List)io.getRight()) {
            if (hpo.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE && hpo.getOwnerName() != null) {
                containsDBOwnerName = true;
            }
            if (hpo.getType() != HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW || hpo.getOwnerName() == null) continue;
            containsTblOwnerName = true;
        }
        if (!containsTblOwnerName || !containsDBOwnerName) {
            String errorMessage = "Ownername is not present in HivePrivilegeObject";
            throw new HiveAuthzPluginException(errorMessage);
        }
    }

    @Test
    public void testOwnerType() throws Exception {
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        driver.compile("create table default.t1 (name string)", true);
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        boolean containsOwnerType = false;
        for (HivePrivilegeObject hpo : (List)io.getLeft()) {
            if (hpo.getOwnerType() == null) continue;
            containsOwnerType = true;
        }
        for (HivePrivilegeObject hpo : (List)io.getRight()) {
            if (hpo.getOwnerType() == null) continue;
            containsOwnerType = true;
        }
        Assert.assertTrue((boolean)containsOwnerType);
    }

    private Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> getHivePrivilegeObjectInputs() throws HiveAuthzPluginException, HiveAccessControlException {
        Class<List> classListPrivObjects = List.class;
        ArgumentCaptor inputsCapturer = ArgumentCaptor.forClass(classListPrivObjects);
        ArgumentCaptor outputsCapturer = ArgumentCaptor.forClass(classListPrivObjects);
        ((HiveAuthorizer)Mockito.verify((Object)mockedAuthorizer)).checkPrivileges((HiveOperationType)ArgumentMatchers.any(HiveOperationType.class), (List)inputsCapturer.capture(), (List)outputsCapturer.capture(), (HiveAuthzContext)ArgumentMatchers.any(HiveAuthzContext.class));
        return new ImmutablePair(inputsCapturer.getValue(), outputsCapturer.getValue());
    }

    static {
        TABLE_NAME = TestHivePrivilegeObjectOwnerNameAndType.class.getSimpleName() + "Table";
    }

    static class MockedHiveAuthorizerFactory
    implements HiveAuthorizerFactory {
        MockedHiveAuthorizerFactory() {
        }

        public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) {
            mockedAuthorizer = (HiveAuthorizer)Mockito.mock(HiveAuthorizer.class);
            return mockedAuthorizer;
        }
    }
}

