/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.schq;

import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.model.MScheduledQuery;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestScheduledQueryStatements {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf.set("hive.security.authorization.scheduled.queries.supported", "true");
        TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf.setVar(HiveConf.ConfVars.USERS_IN_ADMIN_ROLE, System.getProperty("user.name"));
        IDriver driver = TestScheduledQueryStatements.createDriver();
        TestScheduledQueryStatements.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(c int)", "create database asd", "create table asd.tasd(c int)"}) {
            driver.run(cmd);
        }
        ScheduledQueryExecutionService.startScheduledQueryExecutorService((HiveConf)TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        TestScheduledQueryStatements.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"tu"}) {
            driver.run("drop table if exists " + t);
        }
    }

    private void checkScheduleCreation(String schqName, String schedule, String expectedSchedule) throws CommandProcessorException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("set role admin");
        driver.run("create scheduled query " + schqName + " " + schedule + " as select 1 from tu");
        try (CloseableObjectStore os = new CloseableObjectStore(TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf);){
            Optional sq = os.getMScheduledQuery(new ScheduledQueryKey(schqName, "hive"));
            Assert.assertTrue((boolean)sq.isPresent());
            Assert.assertEquals((Object)expectedSchedule, (Object)((MScheduledQuery)sq.get()).getSchedule());
        }
    }

    @Test
    public void testSimpleCreate() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "cron '* * * * * ? *'", "* * * * * ? *");
    }

    private String getMethodName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return stackTrace[1].getMethodName();
    }

    @Test
    public void testMinutes() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every minute", "0 * * * * ? *");
    }

    @Test
    public void test10Minutes() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every 10 minutes", "0 */10 * * * ? *");
    }

    @Test
    public void test10Seconds() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every 10 seconds", "*/10 * * * * ? *");
    }

    @Test
    public void test4Hours() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every 4 hours", "0 0 */4 * * ? *");
    }

    @Test
    public void test4Hours2() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every 4 hours offset by '2:03:04'", "4 3 2/4 * * ? *");
    }

    @Test
    public void testDay() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every day offset by '2:03:04'", "4 3 2 * * ? *");
    }

    @Test
    public void testDay2() throws ParseException, Exception {
        this.checkScheduleCreation(this.getMethodName(), "every day at '2:03:04'", "4 3 2 * * ? *");
    }

    @Test(expected=CommandProcessorException.class)
    public void testNonExistentTable1() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("create scheduled query nonexist cron '* * * * * ? *' as select 1 from nonexist");
    }

    @Test(expected=CommandProcessorException.class)
    public void testNonExistentTable2() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("use asd");
        driver.run("create scheduled query nonexist2 cron '* * * * * ? *' as select 1 from tu");
    }

    @Test
    public void testCreateFromNonDefaultDatabase() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("set role admin");
        driver.run("use asd");
        driver.run("create table tt (a integer)");
        driver.run("create scheduled query nonDef cron '* * * * * ? *' as select 1 from tt");
        try (CloseableObjectStore os = new CloseableObjectStore(TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf);){
            Optional sq = os.getMScheduledQuery(new ScheduledQueryKey("nonDef", "hive"));
            Assert.assertTrue((boolean)sq.isPresent());
            Assert.assertEquals((Object)"select 1 from `asd`.`tt`", (Object)((MScheduledQuery)sq.get()).toThrift().getQuery());
        }
    }

    @Test(expected=CommandProcessorException.class)
    public void testDoubleCreate() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("create scheduled query dc cron '* * * * * ? *' as select 1 from tu");
        driver.run("create scheduled query dc cron '* * * * * ? *' as select 1 from tu");
    }

    @Test
    public void testAlter() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("set role admin");
        driver.run("create scheduled query alter1 cron '0 0 7 * * ? *' as select 1 from tu");
        driver.run("alter scheduled query alter1 executed as 'user3'");
        driver.run("alter scheduled query alter1 defined as select 22 from tu");
        try (CloseableObjectStore os = new CloseableObjectStore(TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf);){
            Optional sq = os.getMScheduledQuery(new ScheduledQueryKey("alter1", "hive"));
            Assert.assertTrue((boolean)sq.isPresent());
            Assert.assertEquals((Object)"user3", (Object)((MScheduledQuery)sq.get()).toThrift().getUser());
            Assert.assertThat((Object)((MScheduledQuery)sq.get()).getNextExecution(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf((int)(System.currentTimeMillis() / 1000L))));
        }
    }

    @Test
    public void testExecuteImmediate() throws ParseException, Exception {
        TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf.setVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_NAMESPACE, "immed");
        IDriver driver = TestScheduledQueryStatements.createDriver();
        driver.run("set role admin");
        driver.run("create scheduled query immed cron '0 0 7 * * ? *' as select 1");
        int cnt0 = ScheduledQueryExecutionService.getForcedScheduleCheckCount();
        driver.run("alter scheduled query immed execute");
        try (CloseableObjectStore os = new CloseableObjectStore(TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf);){
            Optional sq = os.getMScheduledQuery(new ScheduledQueryKey("immed", "immed"));
            Assert.assertTrue((boolean)sq.isPresent());
            Assert.assertThat((Object)((MScheduledQuery)sq.get()).getNextExecution(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf((int)(System.currentTimeMillis() / 1000L))));
            int cnt1 = ScheduledQueryExecutionService.getForcedScheduleCheckCount();
            Assert.assertNotEquals((long)cnt1, (long)cnt0);
        }
    }

    @Test
    public void testImpersonation() throws ParseException, Exception {
        HiveConf conf = TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf;
        IDriver driver = TestScheduledQueryStatements.createDriver();
        this.setupAuthorization();
        driver.run("create table t1 (a integer)");
        conf.set("user.name", "user1");
        driver.run("drop table t1");
    }

    private void setupAuthorization() {
        HiveConf conf = TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf;
        conf.set("hive.test.authz.sstd.hs2.mode", "true");
        conf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactoryForTest");
        conf.set("hive.security.authenticator.manager", "org.apache.hadoop.hive.ql.security.SessionStateConfigUserAuthenticator");
        conf.set("hive.security.authorization.enabled", "true");
    }

    private static IDriver createDriver() {
        HiveConf conf = TestScheduledQueryStatements.env_setup.getTestCtx().hiveConf;
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }

    static class CloseableObjectStore
    extends ObjectStore
    implements AutoCloseable {
        public CloseableObjectStore(HiveConf hiveConf) {
            super.setConf((Configuration)hiveConf);
        }

        @Override
        public void close() throws Exception {
            super.shutdown();
        }
    }
}

