/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.schq;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.QueryState;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.scheduled.IScheduledQueryMaintenanceService;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionContext;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestScheduledQueryService {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        TestScheduledQueryService.env_setup.getTestCtx().hiveConf.setVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_EXECUTOR_IDLE_SLEEP_TIME, "1s");
        TestScheduledQueryService.env_setup.getTestCtx().hiveConf.setVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_EXECUTOR_PROGRESS_REPORT_INTERVAL, "1s");
        IDriver driver = TestScheduledQueryService.createDriver();
        TestScheduledQueryService.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(c int)"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestScheduledQueryService.createDriver();
        TestScheduledQueryService.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"tu"}) {
            driver.run("drop table if exists " + t);
        }
    }

    private int getNumRowsReturned(IDriver driver, String query) throws Exception {
        driver.run(query);
        FetchTask ft = driver.getFetchTask();
        ArrayList res = new ArrayList();
        if (ft == null) {
            return 0;
        }
        ft.fetch(res);
        return res.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduledQueryExecution() throws ParseException, Exception {
        IDriver driver = TestScheduledQueryService.createDriver();
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SchQ %d").build());
        HiveConf conf = TestScheduledQueryService.env_setup.getTestCtx().hiveConf;
        MockScheduledQueryService qService = new MockScheduledQueryService("insert into tu values(1),(2),(3),(4),(5)");
        ScheduledQueryExecutionContext ctx = new ScheduledQueryExecutionContext(executor, conf, (IScheduledQueryMaintenanceService)qService);
        try (ScheduledQueryExecutionService sQ = ScheduledQueryExecutionService.startScheduledQueryExecutorService((ScheduledQueryExecutionContext)ctx);){
            SessionState.getConsole().logInfo("Waiting for query execution to finish ...");
            Object object = qService.notifier;
            synchronized (object) {
                qService.notifier.wait(30000L);
            }
            SessionState.getConsole().logInfo("Done waiting for query execution!");
        }
        Assert.assertThat((Object)qService.lastProgressInfo.isSetExecutorQueryId(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)qService.lastProgressInfo.getExecutorQueryId(), (Matcher)Matchers.containsString((String)(ctx.executorHostName + "/")));
        int nr = this.getNumRowsReturned(driver, "select 1 from tu");
        Assert.assertThat((Object)nr, (Matcher)Matchers.equalTo((Object)5));
    }

    private static IDriver createDriver() {
        HiveConf conf = TestScheduledQueryService.env_setup.getTestCtx().hiveConf;
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }

    public static class MockScheduledQueryService
    implements IScheduledQueryMaintenanceService {
        Object notifier = new Object();
        int id = 0;
        private String stmt;
        ScheduledQueryProgressInfo lastProgressInfo;

        public MockScheduledQueryService(String string) {
            this.stmt = string;
        }

        public ScheduledQueryPollResponse scheduledQueryPoll() {
            ScheduledQueryPollResponse r = new ScheduledQueryPollResponse();
            r.setExecutionId((long)this.id++);
            r.setQuery(this.stmt);
            r.setScheduleKey(new ScheduledQueryKey("sch1", this.getClusterNamespace()));
            r.setUser("nobody");
            if (this.id == 1) {
                return r;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduledQueryProgress(ScheduledQueryProgressInfo info) {
            System.out.printf("%d, state: %s, error: %s", info.getScheduledExecutionId(), info.getState(), info.getErrorMessage());
            this.lastProgressInfo = info;
            if (info.getState() == QueryState.FINISHED || info.getState() == QueryState.FAILED) {
                Object object = this.notifier;
                synchronized (object) {
                    this.notifier.notifyAll();
                }
            }
        }

        public String getClusterNamespace() {
            return "default";
        }
    }
}

