/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.File;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CompileProcessor;
import org.junit.Assert;
import org.junit.Test;

public class TestCompileProcessor {
    @Test
    public void testSyntax() throws Exception {
        CompileProcessor cp = new CompileProcessor();
        cp.run("` public class x { \n }` AS GROOVY NAMED x.groovy");
        Assert.assertEquals((Object)"GROOVY", (Object)cp.getLang());
        Assert.assertEquals((Object)" public class x { \n }", (Object)cp.getCode());
        Assert.assertEquals((Object)"x.groovy", (Object)cp.getNamed());
        try {
            cp.run("");
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)1L, (long)e.getResponseCode());
        }
        try {
            cp.run("bla bla ");
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)1L, (long)e.getResponseCode());
        }
        CompileProcessor cp2 = new CompileProcessor();
        CommandProcessorResponse response = cp2.run("` import org.apache.hadoop.hive.ql.exec.UDF \n public class x { \n }` AS GROOVY NAMED x.groovy");
        File f = new File(response.getMessage());
        Assert.assertTrue((boolean)f.exists());
        f.delete();
    }
}

