/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.sql.SQLException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommandProcessorFactory {
    private final String[] testOnlyCommands = new String[]{"crypto", "erasure"};
    private HiveConf conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HiveConf();
    }

    @Test
    public void testInvalidCommands() throws Exception {
        Assert.assertNull((String)"Null should have returned null", (Object)CommandProcessorFactory.getForHiveCommand(null, (HiveConf)this.conf));
        Assert.assertNull((String)"Blank should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{" "}, (HiveConf)this.conf));
        Assert.assertNull((String)"Set role should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"set role"}, (HiveConf)this.conf));
        Assert.assertNull((String)"Set role should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"set", "role"}, (HiveConf)this.conf));
        Assert.assertNull((String)"SQL should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"SELECT * FROM TABLE"}, (HiveConf)this.conf));
        Assert.assertNull((String)"Test only command should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"CRYPTO --listZones"}, (HiveConf)this.conf));
    }

    @Test
    public void testAvailableCommands() throws Exception {
        String[] cmd;
        this.enableTestOnlyCmd(this.conf);
        SessionState.start((HiveConf)this.conf);
        for (HiveCommand command : HiveCommand.values()) {
            cmd = command.name().toLowerCase().split("_");
            Assert.assertNotNull((String)("Cmd " + cmd[0] + " not return null"), (Object)CommandProcessorFactory.getForHiveCommandInternal((String[])cmd, (HiveConf)this.conf, (boolean)command.isOnlyForTesting()));
            Assert.assertNotNull((String)("Cmd " + cmd + " not return null"), (Object)CommandProcessorFactory.getForHiveCommandInternal((String[])cmd, (HiveConf)this.conf, (boolean)command.isOnlyForTesting()));
        }
        this.conf.set(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.toString(), "");
        for (HiveCommand command : HiveCommand.values()) {
            cmd = command.name().toLowerCase().split("_");
            try {
                CommandProcessorFactory.getForHiveCommandInternal((String[])cmd, (HiveConf)this.conf, (boolean)command.isOnlyForTesting());
                Assert.fail((String)("Expected SQLException for " + cmd[0] + " as available commands is empty"));
            }
            catch (SQLException e) {
                Assert.assertEquals((Object)("Insufficient privileges to execute " + cmd[0]), (Object)e.getMessage());
                Assert.assertEquals((Object)"42000", (Object)e.getSQLState());
            }
        }
    }

    private void enableTestOnlyCmd(HiveConf conf) {
        StringBuilder securityCMDs = new StringBuilder(conf.getVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST));
        for (String c : this.testOnlyCommands) {
            securityCMDs.append(",");
            securityCMDs.append(c);
        }
        conf.set(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.toString(), securityCMDs.toString());
    }
}

