/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapping;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.signature.TestOperatorSignature;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.OperatorStatsReaderHook;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestOperatorCmp {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestOperatorCmp.createDriver();
        TestOperatorCmp.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(id_uv int,id_uw int,u int)", "create table tv(id_uv int,v int)", "create table tw(id_uw int,w int)", "insert into tu values (10,10,10),(1,1,1),(2,2,2),(3,3,3),(4,4,4),(5,5,5),(6,6,6)", "insert into tv values (10,10),(1,1),(2,2),(3,3)", "insert into tw values (10,10),(1,1),(2,2),(3,3),(4,4),(5,5),(6,6),(7,7),(8,8),(9,9)"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestOperatorCmp.createDriver();
        TestOperatorCmp.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"tu", "tv", "tw"}) {
            driver.run("drop table if exists " + t);
        }
    }

    private PlanMapper getMapperForQuery(IDriver driver, String query) throws CommandProcessorException {
        driver.run(query);
        PlanMapper pm0 = driver.getContext().getPlanMapper();
        return pm0;
    }

    @Test
    public void testUnrelatedFiltersAreNotMatched0() throws ParseException, CommandProcessorException {
        IDriver driver = TestOperatorCmp.createDriver();
        String query = "select u from tu where id_uv = 1 union all select v from tv where id_uv = 1";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        List fos = pm.getAll(FilterOperator.class);
        Assert.assertEquals((long)4L, (long)fos.size());
        int cnt = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (!this.compareOperators((Operator)fos.get(i), (Operator)fos.get(j))) continue;
                ++cnt;
            }
        }
        Assert.assertEquals((long)2L, (long)cnt);
    }

    @Test
    public void testUnrelatedFiltersAreNotMatched1() throws ParseException, CommandProcessorException {
        IDriver driver = TestOperatorCmp.createDriver();
        PlanMapper pm0 = this.getMapperForQuery(driver, "select u from tu where id_uv = 1 group by u");
        PlanMapper pm1 = this.getMapperForQuery(driver, "select v from tv where id_uv = 1 group by v");
        List fos0 = pm0.getAll(FilterOperator.class);
        List fos1 = pm1.getAll(FilterOperator.class);
        Assert.assertEquals((long)1L, (long)fos0.size());
        Assert.assertEquals((long)1L, (long)fos1.size());
        Assert.assertFalse((String)"logicalEquals", (boolean)this.compareOperators((Operator)fos0.get(0), (Operator)fos1.get(0)));
    }

    @Test
    public void testDifferentFiltersAreNotMatched() throws ParseException, CommandProcessorException {
        IDriver driver = TestOperatorCmp.createDriver();
        PlanMapper pm0 = this.getMapperForQuery(driver, "select u from tu where id_uv = 1 group by u");
        PlanMapper pm1 = this.getMapperForQuery(driver, "select u from tu where id_uv = 2 group by u");
        this.assertHelper(AssertHelperOp.NOT_SAME, pm0, pm1, FilterOperator.class);
    }

    @Test
    public void testSameFiltersMatched() throws ParseException, Exception {
        IDriver driver = TestOperatorCmp.createDriver();
        PlanMapper pm0 = this.getMapperForQuery(driver, "select u from tu where id_uv = 1 group by u");
        PlanMapper pm1 = this.getMapperForQuery(driver, "select u from tu where id_uv = 1 group by u");
        this.assertHelper(AssertHelperOp.SAME, pm0, pm1, FilterOperator.class);
        this.assertHelper(AssertHelperOp.SAME, pm0, pm1, TableScanOperator.class);
    }

    @Test
    public void testSameJoinMatched() throws ParseException, Exception {
        IDriver driver = TestOperatorCmp.createDriver();
        PlanMapper pm0 = this.getMapperForQuery(driver, "select u,v from tu,tv where tu.id_uv = tv.id_uv and u>1 and v<10 group by u,v");
        PlanMapper pm1 = this.getMapperForQuery(driver, "select u,v from tu,tv where tu.id_uv = tv.id_uv and u>1 and v<10 group by u,v");
        this.assertHelper(AssertHelperOp.SAME, pm0, pm1, CommonMergeJoinOperator.class);
        this.assertHelper(AssertHelperOp.SAME, pm0, pm1, JoinOperator.class);
    }

    private <T extends Operator<?>> void assertHelper(AssertHelperOp same, PlanMapper pm0, PlanMapper pm1, Class<T> clazz) {
        List fos0 = pm0.getAll(clazz);
        List fos1 = pm1.getAll(clazz);
        Assert.assertEquals((long)1L, (long)fos0.size());
        Assert.assertEquals((long)1L, (long)fos1.size());
        Operator opL = (Operator)fos0.get(0);
        Operator opR = (Operator)fos1.get(0);
        if (same == AssertHelperOp.SAME) {
            Assert.assertTrue((String)(clazz + " " + (Object)((Object)same)), (boolean)this.compareOperators(opL, opR));
            TestOperatorSignature.checkEquals(opL, opR);
            TestOperatorSignature.checkTreeEquals(opL, opR);
        } else {
            Assert.assertFalse((String)(clazz + " " + (Object)((Object)same)), (boolean)this.compareOperators(opL, opR));
            TestOperatorSignature.checkNotEquals((Operator<? extends OperatorDesc>)opL, (Operator<? extends OperatorDesc>)opR);
            TestOperatorSignature.checkTreeNotEquals((Operator<? extends OperatorDesc>)opL, (Operator<? extends OperatorDesc>)opR);
        }
    }

    private boolean compareOperators(Operator<?> opL, Operator<?> opR) {
        return opL.logicalEqualsTree(opR);
    }

    private static IDriver createDriver() {
        HiveConf conf = TestOperatorCmp.env_setup.getTestCtx().hiveConf;
        conf.setBoolVar(HiveConf.ConfVars.HIVEOPTPPD, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS, true);
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, "reoptimize");
        conf.set("zzz", "1");
        conf.set("reexec.overlay.zzz", "2000");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.POSTEXECHOOKS, (String)OperatorStatsReaderHook.class.getName());
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }

    static enum AssertHelperOp {
        SAME,
        NOT_SAME;

    }
}

