/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public class TestTypeCheckProcFactory {
    @Mock
    private PrimitiveTypeInfo typeInfo;
    @Mock
    private ExprNodeConstantDesc nodeDesc;
    private TypeCheckProcFactory.DefaultExprProcessor testSubject;
    private final BigDecimal maxValue;
    private final PrimitiveObjectInspectorUtils.PrimitiveTypeEntry constType;
    private final Object expectedValue;
    private final boolean intType;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"127", PrimitiveObjectInspectorUtils.byteTypeEntry, (byte)127, true}, {"32767", PrimitiveObjectInspectorUtils.shortTypeEntry, (short)Short.MAX_VALUE, true}, {"2147483647", PrimitiveObjectInspectorUtils.intTypeEntry, Integer.MAX_VALUE, true}, {"9223372036854775807", PrimitiveObjectInspectorUtils.longTypeEntry, Long.MAX_VALUE, true}, {"111.1", PrimitiveObjectInspectorUtils.floatTypeEntry, Float.valueOf(111.1f), false}, {"111.1", PrimitiveObjectInspectorUtils.doubleTypeEntry, 111.1, false});
    }

    public TestTypeCheckProcFactory(String maxValue, PrimitiveObjectInspectorUtils.PrimitiveTypeEntry constType, Object expectedValue, boolean intType) {
        this.maxValue = new BigDecimal(maxValue);
        this.constType = constType;
        this.expectedValue = expectedValue;
        this.intType = intType;
    }

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.testSubject = ExprNodeTypeCheck.getExprNodeDefaultExprProcessor();
    }

    public void testOneCase(Object constValue) throws Exception {
        Mockito.when((Object)this.nodeDesc.getValue()).thenReturn(constValue);
        Mockito.when((Object)this.typeInfo.getPrimitiveTypeEntry()).thenReturn((Object)this.constType);
        ExprNodeConstantDesc result = (ExprNodeConstantDesc)this.testSubject.interpretNodeAsConstant(this.typeInfo, (Object)this.nodeDesc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.expectedValue, (Object)result.getValue());
    }

    public void testNullCase(Object constValue) throws Exception {
        Mockito.when((Object)this.nodeDesc.getValue()).thenReturn(constValue);
        Mockito.when((Object)this.typeInfo.getPrimitiveTypeEntry()).thenReturn((Object)this.constType);
        ExprNodeConstantDesc result = (ExprNodeConstantDesc)this.testSubject.interpretNodeAsConstant(this.typeInfo, (Object)this.nodeDesc);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testWithSring() throws Exception {
        this.testOneCase(this.maxValue.toString());
    }

    @Test
    public void testWithLSuffix() throws Exception {
        if (this.intType) {
            this.testOneCase(this.maxValue.toString() + "L");
        }
    }

    @Test
    public void testWithZeroFraction() throws Exception {
        if (this.intType) {
            this.testOneCase(this.maxValue.toString() + ".0");
        }
    }

    @Test
    public void testWithFSuffix() throws Exception {
        this.testOneCase(this.maxValue.toString() + "f");
    }

    @Test
    public void testWithDSuffix() throws Exception {
        this.testOneCase(this.maxValue.toString() + "D");
    }

    @Test
    public void testOverflow() throws Exception {
        if (this.intType) {
            this.testNullCase(this.maxValue.add(BigDecimal.valueOf(1L)).toString());
        }
    }

    @Test
    public void testWithNonZeroFraction() throws Exception {
        if (this.intType) {
            this.testNullCase("100.1");
        }
    }
}

