/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.ArrayList;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestExprProcessorGetFuncExpr {
    @Before
    public void setUp() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_ALLOW_UDF_LOAD_ON_DEMAND, true);
        SessionState sessionState = new SessionState(hiveConf, System.getProperty("user.name"));
        SessionState.setCurrentSessionState((SessionState)sessionState);
        Function function = new Function("myupper", sessionState.getCurrentDatabase(), "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper", sessionState.getUserName(), PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, null);
        Hive.get().createFunction(function);
    }

    @Test
    public void testLookupFunctionOnDemand() throws Exception {
        TypeCheckProcFactory.DefaultExprProcessor defaultExprProcessor = ExprNodeTypeCheck.getExprNodeDefaultExprProcessor();
        ASTNode funcExpr = new ASTNode((Token)new CommonToken(933, "TOK_FUNCTION"));
        funcExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, "myupper")));
        funcExpr.addChild((Tree)new ASTNode((Token)new CommonToken(404, "test")));
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>();
        children.add(new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"test"));
        ExprNodeDesc exprNodeDesc = (ExprNodeDesc)defaultExprProcessor.getXpathOrFuncExprNodeDesc(funcExpr, true, children, new TypeCheckCtx(null));
        Assert.assertNotNull((Object)exprNodeDesc);
        Assert.assertNotNull((Object)((ExprNodeGenericFuncDesc)exprNodeDesc).getGenericUDF());
    }

    @After
    public void tearDown() {
        Hive.closeCurrent();
        SessionState.detachSession();
    }
}

