/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReplicationMetricCollector {
    HiveConf conf;

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.conf.set("scheduled.query.schedulename", "repl");
        this.conf.set("scheduled.query.executionid", "1");
        MetricCollector.getInstance().init(this.conf);
    }

    @After
    public void finalize() {
        MetricCollector.getInstance().deinit();
    }

    @Test
    public void testFailureCacheHardLimit() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector collector = MetricCollector.getInstance();
        MetricCollector metricCollectorSpy = (MetricCollector)Mockito.spy((Object)collector);
        ((MetricCollector)Mockito.doReturn((Object)1L).when((Object)metricCollectorSpy)).getMaxSize((HiveConf)Mockito.any());
        metricCollectorSpy.init(this.conf);
        metricCollectorSpy.addMetric(new ReplicationMetric(1L, "repl", 0L, null));
        try {
            metricCollectorSpy.addMetric(new ReplicationMetric(2L, "repl", 0L, null));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"Metrics are not getting collected. ", (Object)e.getMessage());
        }
    }

    @Test
    public void testFailureNoScheduledId() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector.getInstance().init(this.conf);
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
    }

    @Test
    public void testFailureNoPolicyId() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector.getInstance().init(this.conf);
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
    }

    @Test
    public void testSuccessBootstrapDumpMetrics() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L);
        bootstrapDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.BOOTSTRAP, "staging");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessIncrDumpMetrics() throws Exception {
        IncrementalDumpMetricCollector incrDumpMetricCollector = new IncrementalDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        incrDumpMetricCollector.reportStageStart("dump", metricMap);
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L);
        incrDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.INCREMENTAL, "staging");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessBootstrapLoadMetrics() throws Exception {
        BootstrapLoadMetricCollector bootstrapLoadMetricCollector = new BootstrapLoadMetricCollector("db", "staging", 1L, this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapLoadMetricCollector.reportStageStart("dump", metricMap);
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapLoadMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L);
        bootstrapLoadMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.BOOTSTRAP, "staging");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 1L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessIncrLoadMetrics() throws Exception {
        IncrementalLoadMetricCollector incrLoadMetricCollector = new IncrementalLoadMetricCollector("db", "staging", 1L, this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        incrLoadMetricCollector.reportStageStart("dump", metricMap);
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrLoadMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L);
        incrLoadMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.INCREMENTAL, "staging");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 1L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    private void checkSuccess(ReplicationMetric actual, ReplicationMetric expected, String stageName, List<String> metricNames) {
        Assert.assertEquals((long)expected.getDumpExecutionId(), (long)actual.getDumpExecutionId());
        Assert.assertEquals((Object)expected.getPolicy(), (Object)actual.getPolicy());
        Assert.assertEquals((long)expected.getScheduledExecutionId(), (long)actual.getScheduledExecutionId());
        Assert.assertEquals((Object)expected.getMetadata().getReplicationType(), (Object)actual.getMetadata().getReplicationType());
        Assert.assertEquals((Object)expected.getMetadata().getDbName(), (Object)actual.getMetadata().getDbName());
        Assert.assertEquals((Object)expected.getMetadata().getStagingDir(), (Object)actual.getMetadata().getStagingDir());
        Assert.assertEquals((long)expected.getMetadata().getLastReplId(), (long)actual.getMetadata().getLastReplId());
        Assert.assertEquals((Object)expected.getProgress().getStatus(), (Object)actual.getProgress().getStatus());
        Assert.assertEquals((Object)expected.getProgress().getStageByName(stageName).getStatus(), (Object)actual.getProgress().getStageByName(stageName).getStatus());
        for (String metricName : metricNames) {
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount());
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount());
        }
    }

    @Test
    public void testSuccessStageFailure() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.FAILED);
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric actualMetric = (ReplicationMetric)metricList.get(0);
        Assert.assertEquals((Object)Status.FAILED, (Object)actualMetric.getProgress().getStatus());
    }

    @Test
    public void testSuccessStageFailedAdmin() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "staging", this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.FAILED_ADMIN, "errorlogpath");
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric actualMetric = (ReplicationMetric)metricList.get(0);
        Assert.assertEquals((Object)Status.FAILED_ADMIN, (Object)actualMetric.getProgress().getStatus());
        Assert.assertEquals((Object)"errorlogpath", (Object)actualMetric.getProgress().getStageByName("dump").getErrorLogPath());
    }
}

